/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSException;
import com.sonicsw.esb.ws.invocation.ESBWSParameter;
import com.sonicsw.esb.ws.invocation.ESBWSTypeLibrary;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.instruct.TerminationException;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.substwsdl.DefinitionsDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.w3c.dom.Element;

public class TypeHelper
implements ESBWSTypeLibrary {
    private String m_wsdlURL = null;
    private String m_wsdlXML = null;
    private boolean m_bUseXML = true;
    private SchemaTypeLoader m_baseLoader = null;
    private SchemaTypeLoader m_typeLoader = null;
    private Definition m_def = null;
    private Map m_schemaLocations = new Hashtable();

    public TypeHelper(Definition def) {
        this.m_def = def;
    }

    public void initializeFromURL(String url) throws WSDLHelperException {
        this.m_wsdlURL = url;
        this.m_bUseXML = false;
        this.loadExternalDefinitions();
    }

    public void initializeFromXML(String xml) throws WSDLHelperException {
        this.m_wsdlXML = xml;
        this.m_bUseXML = true;
        this.loadExternalDefinitions();
    }

    private void loadExternalDefinitions() throws WSDLHelperException {
        ArrayList<String> externalSchemaLocations = new ArrayList<String>();
        if (this.m_def == null) {
            return;
        }
        Map importMap = this.m_def.getImports();
        for (String key : importMap.keySet()) {
            List importList = (List)importMap.get(key);
            if (importList == null) continue;
            for (int i = 0; i < importList.size(); ++i) {
                Import imp = (Import)importList.get(i);
                externalSchemaLocations.add(imp.getLocationURI());
            }
        }
        Types types = this.m_def.getTypes();
        if (types != null) {
            List extElements = types.getExtensibilityElements();
            for (ExtensibilityElement elem : extElements) {
                if ((!elem.getElementType().equals(new QName("http://schemas.xmlsoap.org/wsdl/", "import")) || !(elem instanceof UnknownExtensibilityElement)) && (!elem.getElementType().equals(new QName("http://www.w3.org/2001/XMLSchema", "import")) || !(elem instanceof UnknownExtensibilityElement))) continue;
                Element e = ((UnknownExtensibilityElement)elem).getElement();
                String loc = e.getAttribute("schemaLocation");
                if (loc == null || "".equals(loc)) {
                    loc = e.getAttribute("location");
                }
                externalSchemaLocations.add(loc);
            }
        }
        this.loadTypes(externalSchemaLocations);
    }

    private void loadTypes(List externalSchemas) throws WSDLHelperException {
        try {
            this.m_baseLoader = this.createBaseLoader();
            ArrayList<SchemaTypeLoader> typeLoaders = new ArrayList<SchemaTypeLoader>();
            typeLoaders.add(this.m_baseLoader);
            SchemaTypeLoader loader = null;
            loader = this.m_bUseXML ? this.loadOneSchema(this.m_wsdlXML) : this.loadOneSchema(new URL(this.m_wsdlURL));
            if (loader != null) {
                typeLoaders.add(loader);
            }
            for (String uri : externalSchemas) {
                URL url = this.computeURL(uri);
                SchemaTypeLoader importedLoader = this.loadOneSchema(url);
                typeLoaders.add(importedLoader);
            }
            SchemaTypeLoader[] loaderArray = typeLoaders.toArray(new SchemaTypeLoader[typeLoaders.size()]);
            this.m_typeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])loaderArray);
        }
        catch (MalformedURLException e2) {
            throw new WSDLHelperException(e2);
        }
    }

    private URL computeURL(String urlString) throws MalformedURLException {
        MalformedURLException except = null;
        try {
            URL url = new URL(urlString);
            return url;
        }
        catch (MalformedURLException e) {
            except = e;
            if (urlString.indexOf(":") == -1) {
                String baseURI = this.m_def.getDocumentBaseURI();
                int lastSlash = baseURI.lastIndexOf("/");
                baseURI = baseURI.substring(0, lastSlash + 1);
                String absURL = baseURI + urlString;
                return new URL(absURL);
            }
            throw except;
        }
    }

    private SchemaTypeLoader createBaseLoader() throws WSDLHelperException {
        SchemaTypeLoader defLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)SchemaDocument.class.getClassLoader());
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setLoadSubstituteNamespaces(Collections.singletonMap("http://schemas.xmlsoap.org/wsdl/", "http://www.apache.org/internal/xmlbeans/wsdlsubst"));
        try {
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("com/sonicsw/xqimpl/script/wsdl/soap-encoding11.xsd");
            XmlObject doc = defLoader.parse(inStream, null, options);
            SchemaTypeLoader soapLoader = this.loadSchemaObject(doc, null);
            inStream = this.getClass().getClassLoader().getResourceAsStream("com/sonicsw/xqimpl/script/wsdl/soap-env.xsd");
            doc = defLoader.parse(inStream, null, options);
            SchemaTypeLoader soapEnvLoader = this.loadSchemaObject(doc, null);
            SchemaTypeLoader[] loaderArray = new SchemaTypeLoader[]{defLoader, soapLoader, soapEnvLoader};
            return XmlBeans.typeLoaderUnion((SchemaTypeLoader[])loaderArray);
        }
        catch (IOException e1) {
            throw new WSDLHelperException(e1);
        }
        catch (XmlException e2) {
            throw new WSDLHelperException(e2);
        }
    }

    private SchemaTypeLoader loadOneSchema(URL url) throws WSDLHelperException {
        XmlOptions options = TypeHelper.configOptions();
        try {
            XmlObject doc = this.m_baseLoader.parse(url, null, options);
            return this.loadSchemaObject(doc, url.toString());
        }
        catch (IOException e1) {
            throw new WSDLHelperException(e1);
        }
        catch (XmlException e2) {
            throw new WSDLHelperException(e2);
        }
    }

    private SchemaTypeLoader loadOneSchema(String source) throws WSDLHelperException {
        XmlOptions options = TypeHelper.configOptions();
        try {
            XmlObject doc = this.m_baseLoader.parse(source, null, options);
            return this.loadSchemaObject(doc, null);
        }
        catch (XmlException e) {
            throw new WSDLHelperException(e);
        }
    }

    private static XmlOptions configOptions() {
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setCompileNoUpaRule();
        options.setLoadSubstituteNamespaces(Collections.singletonMap("http://schemas.xmlsoap.org/wsdl/", "http://www.apache.org/internal/xmlbeans/wsdlsubst"));
        return options;
    }

    private SchemaTypeLoader loadSchemaObject(XmlObject doc, String location) throws WSDLHelperException {
        try {
            ArrayList<Object> schemaList = new ArrayList<Object>();
            if (doc instanceof DefinitionsDocument) {
                XmlObject[] types = ((DefinitionsDocument)doc).getDefinitions().getTypesArray();
                for (int i = 0; i < types.length; ++i) {
                    XmlObject[] objs = types[0].selectPath("declare namespace xs=\"http://www.w3.org/2001/XMLSchema\" xs:schema");
                    if (objs.length <= 0) continue;
                    SchemaDocument.Schema[] schemas = (SchemaDocument.Schema[])objs;
                    for (int j = 0; j < schemas.length; ++j) {
                        schemaList.add(schemas[j]);
                    }
                }
            } else if (doc instanceof SchemaDocument) {
                schemaList.add(((SchemaDocument)doc).getSchema());
            } else {
                XmlObject[] objs = doc.selectPath("declare namespace xs=\"http://www.w3.org/2001/XMLSchema\" xs:schema");
                if (objs.length > 0) {
                    for (int j = 0; j < objs.length; ++j) {
                        schemaList.add(objs[j]);
                    }
                }
            }
            SchemaDocument.Schema[] schemaDocs = schemaList.toArray(new SchemaDocument.Schema[schemaList.size()]);
            XmlOptions opts = new XmlOptions();
            opts.setLoadAdditionalNamespaces(this.m_def.getNamespaces());
            opts.setCompileDownloadUrls();
            opts.setCompileNoUpaRule();
            SchemaTypeLoader loader = this.m_baseLoader == null ? XmlBeans.getContextTypeLoader() : this.m_baseLoader;
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])schemaDocs, (SchemaTypeLoader)loader, (XmlOptions)opts);
            if (location != null) {
                this.m_schemaLocations.put(sts, location);
            }
            SchemaTypeLoader newLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{sts, loader});
            return newLoader;
        }
        catch (XmlException e) {
            throw new WSDLHelperException(e);
        }
    }

    private String getTypeString(SchemaType typeParam) {
        SchemaType type = typeParam;
        if (type.isSimpleType()) {
            if (type.getSimpleVariety() == 1) {
                while (type.getTypeSystem() != XmlBeans.getBuiltinTypeSystem()) {
                    type = type.getBaseType();
                }
                return "xsd:" + type.getName().getLocalPart();
            }
            return "xsd:string";
        }
        return "xsd:anyType";
    }

    @Override
    public Iterator getImportLocations() {
        return this.m_schemaLocations.values().iterator();
    }

    @Override
    public String getBaseTypeName(QName qname) throws WSDLHelperException {
        SchemaType t = this.getType(qname);
        if (t != null) {
            return this.getTypeString(t);
        }
        throw new WSDLHelperException("type-not-found", new String[]{qname.toString()});
    }

    SchemaType getType(QName qname) {
        SchemaType t = this.m_typeLoader.findType(qname);
        if (t != null) {
            return t;
        }
        t = this.m_typeLoader.findDocumentType(qname);
        return t;
    }

    @Override
    public boolean isSimpleType(QName qname) throws WSDLHelperException {
        SchemaType t = this.getType(qname);
        if (t != null) {
            return t.isSimpleType();
        }
        throw new WSDLHelperException("type-not-found", new String[]{qname.toString()});
    }

    public String getSchema(QName qname, String paramName) throws WSDLHelperException {
        SchemaTypeSystem loader;
        String uri;
        String retval = null;
        SchemaType t = this.getType(qname);
        if (t != null && (uri = (String)this.m_schemaLocations.get(loader = t.getTypeSystem())) != null) {
            try {
                TransformerFactory tfactory = TransformerFactory.newInstance();
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("com/sonicsw/xqimpl/script/wsdl/schema-extract.xsl");
                StreamSource xslSource = new StreamSource(inStream);
                Transformer transformer = tfactory.newTransformer(xslSource);
                transformer.setParameter("elementname", paramName);
                StreamSource docSource = new StreamSource(uri);
                StringWriter writer = new StringWriter();
                transformer.transform(docSource, new StreamResult(writer));
                retval = writer.toString();
            }
            catch (TerminationException te) {
                throw new WSDLHelperException("only-one-schema", new Object[]{qname.toString()});
            }
            catch (Exception e) {
                throw new WSDLHelperException(e);
            }
        }
        return retval;
    }

    public boolean isSchemaAvailable(QName qname) throws WSDLHelperException {
        SchemaTypeSystem loader;
        String uri;
        SchemaType t = this.getType(qname);
        return t != null && (uri = (String)this.m_schemaLocations.get(loader = t.getTypeSystem())) != null;
    }

    @Override
    public QName getQNameForPrefixedName(String prefixedType) throws WSDLHelperException {
        String prefix = XMLTypeUtils.getTypePrefix(prefixedType);
        String localName = XMLTypeUtils.getTypeName(prefixedType);
        String namespace = this.m_def.getNamespace(prefix);
        QName qname = new QName(namespace, localName);
        return qname;
    }

    @Override
    public String getSchema(ESBWSParameter param) throws ESBWSException {
        QName paramType = new QName(param.getTypeURI(), param.getTypeLocalName());
        return this.getSchema(paramType, param.getTypeLocalName());
    }

    @Override
    public boolean isSchemaAvailable(ESBWSParameter param) throws ESBWSException {
        QName paramType = new QName(param.getTypeURI(), param.getTypeLocalName());
        return this.isSchemaAvailable(paramType);
    }
}

