/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import com.sonicsw.xqimpl.util.ClassUtils;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import modelobjects.expr.PostEvalConverter;
import modelobjects.template.BeanWrapper;
import modelobjects.template.DictionaryWrapper;
import modelobjects.template.ParsedTemplate;
import modelobjects.template.TemplateException;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.WrapperConverter;
import modelobjects.util.ObjectWrapper;
import modelobjects.util.PropertiesAccess;

public class TemplateProcessor
implements PropertiesAccess,
ObjectWrapper {
    public static final String TOP_LEVEL_OBJ_ID = new String("TOP_LEVEL");
    private static boolean stackTraceOnErrorEnabled = true;
    protected char[] templateSource;
    protected TemplateFragment[] parsedTemplate;
    protected String sourceFileName;
    protected int fragmentIndex;
    protected PostEvalConverter postEvalConverter;
    protected PrintWriter outputSink;
    protected Object replacementData;
    protected PropertiesAccess replacementDataWrapper;
    protected Stack objectStack;
    protected boolean typeCheckingEnabled;

    public TemplateProcessor(ParsedTemplate parsedTemplate, PrintWriter outputSink, Object replacementData) {
        this(parsedTemplate.getTemplateSource(), parsedTemplate.getTemplateFragments(), parsedTemplate.getTemplateSourceFileName(), outputSink, replacementData);
    }

    public TemplateProcessor(char[] templateSource, TemplateFragment[] parsedTemplate, String templateSourceFileName, PrintWriter outputSink, Object replacementData) {
        this.templateSource = ClassUtils.arrayCopy((char[])templateSource);
        this.parsedTemplate = (TemplateFragment[])ClassUtils.arrayCopy((Object[])parsedTemplate);
        this.outputSink = outputSink;
        this.replacementData = replacementData;
        this.sourceFileName = templateSourceFileName;
        this.postEvalConverter = WrapperConverter.getInstance();
        this.fragmentIndex = 0;
        this.objectStack = new Stack();
        this.typeCheckingEnabled = false;
        this.replacementDataWrapper = replacementData instanceof Dictionary ? new DictionaryWrapper((Dictionary)replacementData) : new BeanWrapper(replacementData);
    }

    public void processTemplate() {
        int numFrags = this.parsedTemplate.length;
        while (this.fragmentIndex < numFrags) {
            TemplateFragment frag = this.parsedTemplate[this.fragmentIndex++];
            try {
                frag.processFragment(this);
            }
            catch (TemplateException e) {
                e.printStackTrace();
                break;
            }
        }
        this.outputSink.flush();
    }

    public boolean isTypeCheckingEnabled() {
        return this.typeCheckingEnabled;
    }

    public void setTypeCheckingEnabled(boolean enabled) {
        this.typeCheckingEnabled = enabled;
    }

    public static PostEvalConverter getDefaultPostEvalConverter() {
        return WrapperConverter.getInstance();
    }

    public PostEvalConverter getPostEvalConverter() {
        return this.postEvalConverter;
    }

    public void setPostEvalConverter(PostEvalConverter converter) {
        this.postEvalConverter = converter;
    }

    public static boolean isStackTraceOnErrorEnabled() {
        return stackTraceOnErrorEnabled;
    }

    public static void setStackTraceOnErrorEnabled(boolean enabled) {
        stackTraceOnErrorEnabled = enabled;
    }

    @Override
    public Object getWrappedObject() {
        return this.replacementData;
    }

    Object getReplacementData() {
        return this.replacementData;
    }

    int getCurrentFragmentIndex() {
        return this.fragmentIndex;
    }

    void setCurrentFragmentIndex(int index) {
        this.fragmentIndex = index;
    }

    @Override
    public Object getProperty(String varName) {
        if (varName == null) {
            throw new NullPointerException("null property name");
        }
        VariableEntry varEntry = this.findVariable(varName);
        if (varEntry != null) {
            return varEntry.getValue();
        }
        if (varName.equalsIgnoreCase(TOP_LEVEL_OBJ_ID)) {
            return this.replacementData;
        }
        Object result = this.replacementDataWrapper.getProperty(varName);
        return result;
    }

    void recordVariable(TemplateFragment frag, String varName, String varType, Object initialValue) {
        this.typeCheck(initialValue, varType, frag.getStartPosition());
        this.objectStack.push(new VariableEntry(varName, initialValue));
    }

    boolean isVariableDefined(String varName) {
        return this.findVariable(varName) != null;
    }

    void popScope(String topVarName) {
        VariableEntry varEntry;
        while (!this.objectStack.isEmpty() && !(varEntry = (VariableEntry)this.objectStack.pop()).getName().equals(topVarName)) {
        }
    }

    void setVariable(String varName, Object value) {
        if (varName == null) {
            throw new NullPointerException("null variable name");
        }
        VariableEntry varEntry = this.findVariable(varName);
        if (varEntry == null) {
            throw new IllegalArgumentException("Unknown variable: " + varName);
        }
        varEntry.setValue(value);
    }

    void writeLiteral(int startPos, int length) {
        this.outputSink.write(this.templateSource, startPos, length);
    }

    void writeString(String val) {
        this.outputSink.write(val);
    }

    static boolean isCollectionValue(Object obj) {
        return obj instanceof Object[] || obj instanceof Vector || obj instanceof Enumeration;
    }

    void typeCheck(Object obj, String type, int fragPos) {
        if (obj == null || type == null || !this.typeCheckingEnabled) {
            return;
        }
        String objTypeName = obj.getClass().getName();
        int dotPos = Math.max(objTypeName.lastIndexOf(46), objTypeName.lastIndexOf(36));
        if (dotPos >= 0) {
            objTypeName = objTypeName.substring(dotPos + 1);
        }
        if (!objTypeName.equalsIgnoreCase(type)) {
            this.typeMismatch(fragPos, "object of type " + objTypeName + " but expected " + type);
        }
    }

    void typeMismatch(int fragPos, String msg) {
        System.err.println("***************************************************");
        System.err.println("Warning - type mismatch in tag on line " + TemplateParser.lineNumber(this.templateSource, fragPos) + "\n\t" + msg);
    }

    private VariableEntry findVariable(String varName) {
        for (int i = this.objectStack.size() - 1; i >= 0; --i) {
            VariableEntry varEntry = (VariableEntry)this.objectStack.elementAt(i);
            if (!varEntry.getName().equalsIgnoreCase(varName)) continue;
            return varEntry;
        }
        return null;
    }

    void reportError(TemplateFragment fragment, Throwable exception) {
        this.reportError(fragment, exception, null);
    }

    void reportError(TemplateFragment fragment, Throwable exception, String message) {
        int lineNumber = TemplateParser.lineNumber(this.templateSource, fragment.getStartPosition());
        String source = this.sourceFileName == null ? "template" : "template file '" + this.sourceFileName + "'";
        String extra = message == null ? "" : " - " + message;
        System.err.println("***************************************************");
        System.err.println("Evaluation error in " + source + " on line " + lineNumber + extra);
        if (TemplateProcessor.isStackTraceOnErrorEnabled()) {
            exception.printStackTrace(System.err);
        } else {
            System.err.println(exception);
        }
    }

    private static final class VariableEntry {
        String name;
        Object value;

        public VariableEntry(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        public final Object getValue() {
            return this.value;
        }

        public void setValue(Object newValue) {
            this.value = newValue;
        }
    }
}

