/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import java.util.HashMap;
import java.util.Map;

public class DefaultToken
implements Token,
Cloneable {
    protected String m_tokenId;
    protected ActivityNode m_fromActivityNode;
    protected ActivityNode m_toActivityNode;
    protected ProcessInstance m_procInst;
    protected Object m_data;
    private Map<String, Object> m_properties;
    private int m_typeMask;

    public DefaultToken(ActivityNode fromActivityNode, ProcessInstance procInst, Object data) {
        this.m_typeMask = Token.Type.DATA.mask;
        this.m_fromActivityNode = fromActivityNode;
        this.m_procInst = procInst;
        this.m_data = data;
    }

    public Token changeOwnership(ActivityNode fromNode) {
        return this.changeOwnership(fromNode, true);
    }

    @Override
    public Token changeOwnership(ActivityNode fromNode, boolean clone) {
        DefaultToken token = this;
        if (clone) {
            token = (DefaultToken)token.clone();
        }
        token.m_fromActivityNode = fromNode;
        token.m_tokenId = null;
        return token;
    }

    @Override
    public ActivityNode getFromActivityNode() {
        return this.m_fromActivityNode;
    }

    @Override
    public String getTokenId() {
        return this.m_tokenId != null ? this.m_tokenId : this.createTokenID();
    }

    protected String createTokenID() {
        this.m_tokenId = this.m_fromActivityNode == null ? "" : this.m_fromActivityNode.getId();
        return this.m_tokenId;
    }

    public Object getData() {
        return this.m_data;
    }

    @Override
    public ActivityNode getDestinationNode() {
        return this.m_toActivityNode;
    }

    public Object clone() {
        try {
            DefaultToken clonedToken = (DefaultToken)super.clone();
            return clonedToken;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <P extends ProcessInstance> void setProcessInstance(P procInst) {
        this.m_procInst = procInst;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, Object>(3);
        }
        this.m_properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.m_properties == null ? null : this.m_properties.get(name);
    }

    @Override
    public Object removeProperty(String name) {
        return this.m_properties != null ? this.m_properties.remove(name) : null;
    }

    @Override
    public void removeAllProperties() {
        if (this.m_properties != null) {
            this.m_properties.clear();
        }
        this.m_properties = null;
    }

    @Override
    @Deprecated
    public void setSourceNode(ActivityNode sourceNode) {
        this.setFromActivityNode(sourceNode);
    }

    @Override
    public void setFromActivityNode(ActivityNode sourceNode) {
        this.m_fromActivityNode = sourceNode;
    }

    @Override
    public void setDestinationNode(ActivityNode destNode) {
        this.m_toActivityNode = destNode;
    }

    @Override
    public void tagType(Token.Type type) {
        if ((type.mask & this.m_typeMask) == 0) {
            this.m_typeMask += type.mask;
        }
    }

    @Override
    public void unTagType(Token.Type type) {
        if ((type.mask & this.m_typeMask) > 0) {
            this.m_typeMask -= type.mask;
        }
    }

    public boolean isTokenOfType(Token.Type type) {
        return this.isTokenOfType(type, false);
    }

    @Override
    public int getTag() {
        return this.m_typeMask;
    }

    @Override
    public boolean isTokenOfType(Token.Type type, boolean removeTag) {
        boolean isTypeTagged;
        boolean bl = isTypeTagged = (this.m_typeMask & type.mask) > 0;
        if (isTypeTagged && removeTag) {
            this.unTagType(type);
        }
        return isTypeTagged;
    }

    public ProcessInstance getProcessInstance() {
        return this.m_procInst;
    }

    public void setData(Object data) {
        this.m_data = data;
    }
}

