/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.endpoint.container.ConnectionManagerException;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAEndpointContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;

public class JCAConnectionManager
implements ConnectionManager {
    private Map m_connectionFactories;
    private Map m_listeners;
    private Map m_pendingReturn;
    private ThreadLocal m_connectionsLocal = new ThreadLocal();
    protected XQLog m_log;

    public JCAConnectionManager() {
        this.m_connectionFactories = new HashMap();
        this.m_listeners = new HashMap();
        this.m_pendingReturn = new HashMap();
    }

    protected void init(XQLog log) {
        this.m_log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo crf) throws ResourceException {
        HashSet<ManagedConnection> conns;
        Object mcs;
        if (mcf == null) {
            throw new ConnectionManagerException("The ManagedConnectionFactory cannot be null");
        }
        ManagedConnection mc = null;
        Map map = this.m_connectionFactories;
        synchronized (map) {
            mcs = (Set)this.m_connectionFactories.get(mcf);
            if (mcs != null) {
                mc = mcf.matchManagedConnections((Set)mcs, null, crf);
                mcs.remove(mc);
            }
        }
        if (mc == null) {
            mc = mcf.createManagedConnection(null, crf);
        }
        if (mc == null) {
            throw new ConnectionManagerException("The ResourceAdapter cannot create the desired connection");
        }
        JCAConnectionEventListener listener = null;
        mcs = this.m_listeners;
        synchronized (mcs) {
            listener = (JCAConnectionEventListener)this.m_listeners.get(mcf);
            if (listener == null) {
                listener = new JCAConnectionEventListener(mcf);
                this.m_listeners.put(mcf, listener);
            }
        }
        listener.addConnection(mc);
        if (JCAEndpointContext.getQoSLevel() == 1 || JCAEndpointContext.getQoSLevel() == 3) {
            listener.addTransaction(mc, mc.getLocalTransaction());
        }
        if ((conns = (HashSet<ManagedConnection>)this.m_connectionsLocal.get()) == null) {
            conns = new HashSet<ManagedConnection>();
            this.m_connectionsLocal.set(conns);
        }
        conns.add(mc);
        return mc.getConnection(null, crf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPending(ManagedConnectionFactory mcf, ManagedConnection mc) {
        Map map = this.m_pendingReturn;
        synchronized (map) {
            Set mcs = this.populateConnectionFactories(this.m_pendingReturn, mcf);
            mcs.add(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnToPool(ManagedConnectionFactory mcf, Set connections) {
        Map map = this.m_connectionFactories;
        synchronized (map) {
            Set mcs = this.populateConnectionFactories(this.m_connectionFactories, mcf);
            mcs.addAll(connections);
        }
    }

    private Set populateConnectionFactories(Map m_connectionFactories, ManagedConnectionFactory mcf) {
        HashSet mcs = (HashSet)m_connectionFactories.get(mcf);
        if (mcs == null) {
            mcs = new HashSet();
            m_connectionFactories.put(mcf, mcs);
        }
        return mcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSendCompletion(ManagedConnectionFactory mcf, boolean success) {
        HashSet set = (HashSet)this.m_connectionsLocal.get();
        JCAConnectionEventListener listener = null;
        Map map = this.m_listeners;
        synchronized (map) {
            listener = (JCAConnectionEventListener)this.m_listeners.get(mcf);
        }
        if (listener != null) {
            Iterator conns = set.iterator();
            while (conns.hasNext()) {
                listener.handleCloseEvent((ManagedConnection)conns.next(), success);
            }
        }
        if (!success) {
            this.haveConnectionsClosedProperly(mcf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean haveConnectionsClosedProperly(ManagedConnectionFactory mcf) {
        HashSet conns = (HashSet)this.m_connectionsLocal.get();
        boolean returnValue = false;
        if (conns != null) {
            try {
                Map map = this.m_pendingReturn;
                synchronized (map) {
                    Set mcs = (Set)this.m_pendingReturn.get(mcf);
                    if (mcs != null && conns != null) {
                        returnValue = mcs.containsAll(conns);
                        mcs.removeAll(conns);
                    }
                }
                this.returnToPool(mcf, conns);
            }
            finally {
                conns.clear();
            }
        }
        return returnValue;
    }

    private void destroyConnection(ManagedConnection mc) {
        try {
            mc.destroy();
        }
        catch (ResourceException log) {
            this.m_log.logError("Exception encountered while attempting to destroy a JCA Connection.");
            this.m_log.logError((Throwable)log);
        }
    }

    private class JCAConnectionEventListener
    implements ConnectionEventListener {
        private ManagedConnectionFactory m_mcf;
        private List m_connectionsInUse;
        private Map m_transactions;
        private List m_closingConnections;
        private List m_errorConnections;
        private List m_userStartedTransactions;

        public JCAConnectionEventListener(ManagedConnectionFactory mcf) {
            this.m_mcf = mcf;
            this.m_connectionsInUse = new ArrayList();
            this.m_transactions = new HashMap();
            this.m_closingConnections = new ArrayList();
            this.m_errorConnections = new ArrayList();
            this.m_userStartedTransactions = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionEvent event) {
            ManagedConnection mc = (ManagedConnection)event.getSource();
            List list = this.m_closingConnections;
            synchronized (list) {
                this.m_closingConnections.add(mc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleCloseEvent(ManagedConnection mc, boolean success) {
            List list = this.m_errorConnections;
            synchronized (list) {
                if (this.m_errorConnections.contains(mc)) {
                    JCAConnectionManager.this.destroyConnection(mc);
                    return;
                }
            }
            list = this.m_closingConnections;
            synchronized (list) {
                if (!this.m_closingConnections.contains(mc)) {
                    return;
                }
                this.m_closingConnections.remove(mc);
            }
            this.removeConnection(mc);
            try {
                this.cleanupTransaction(mc, success);
                this.cleanupConnection(mc);
            }
            catch (ResourceException re) {
                JCAConnectionManager.this.destroyConnection(mc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void localTransactionStarted(ConnectionEvent event) {
            List list = this.m_userStartedTransactions;
            synchronized (list) {
                this.m_userStartedTransactions.add(event.getSource());
            }
        }

        public void localTransactionCommitted(ConnectionEvent event) {
        }

        public void localTransactionRolledback(ConnectionEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionErrorOccurred(ConnectionEvent event) {
            List list = this.m_errorConnections;
            synchronized (list) {
                this.m_errorConnections.add(event.getSource());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConnection(ManagedConnection mc) {
            mc.addConnectionEventListener((ConnectionEventListener)this);
            List list = this.m_connectionsInUse;
            synchronized (list) {
                this.m_connectionsInUse.add(mc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTransaction(ManagedConnection mc, LocalTransaction lt) throws ResourceException {
            lt.begin();
            Map map = this.m_transactions;
            synchronized (map) {
                this.m_transactions.put(mc, lt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTransaction(ManagedConnection mc) {
            Map map = this.m_transactions;
            synchronized (map) {
                this.m_transactions.remove(mc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeConnection(ManagedConnection mc) {
            mc.removeConnectionEventListener((ConnectionEventListener)this);
            List list = this.m_connectionsInUse;
            synchronized (list) {
                this.m_connectionsInUse.remove(mc);
            }
        }

        private void cleanupConnection(ManagedConnection mc) {
            try {
                mc.cleanup();
                JCAConnectionManager.this.addToPending(this.m_mcf, mc);
            }
            catch (ResourceException re) {
                JCAConnectionManager.this.m_log.logError("Exception encountered while attempting to cleanup a JCA Connection.  Now attempting destroy.");
                JCAConnectionManager.this.m_log.logError((Throwable)re);
                JCAConnectionManager.this.destroyConnection(mc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupTransaction(ManagedConnection mc, boolean success) throws ResourceException {
            LocalTransaction lt = null;
            Object object = this.m_transactions;
            synchronized (object) {
                lt = (LocalTransaction)this.m_transactions.get(mc);
            }
            if (lt != null) {
                this.removeTransaction(mc);
                object = this.m_userStartedTransactions;
                synchronized (object) {
                    if (this.m_userStartedTransactions.contains(mc)) {
                        this.m_userStartedTransactions.remove(mc);
                        throw new ConnectionManagerException("The user attempted to start a nested transaction.");
                    }
                }
                if (success) {
                    this.commitTransaction(lt);
                } else {
                    this.rollbackTransaction(lt);
                }
            }
        }

        private void commitTransaction(LocalTransaction lt) throws ResourceException {
            try {
                lt.commit();
            }
            catch (ResourceException re) {
                JCAConnectionManager.this.m_log.logError("Exception encountered while attempting to commit a LocalTransaction.  Now attempting rollback and destroy.");
                JCAConnectionManager.this.m_log.logError((Throwable)re);
                this.rollbackTransaction(lt);
                throw re;
            }
        }

        private void rollbackTransaction(LocalTransaction lt) throws ResourceException {
            try {
                lt.rollback();
            }
            catch (ResourceException re) {
                JCAConnectionManager.this.m_log.logError("Exception encountered while attempting to rollback a LocalTransaction.");
                JCAConnectionManager.this.m_log.logError((Throwable)re);
                throw re;
            }
        }
    }
}

