/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Decision;
import com.sonicsw.esb.itinerary.def.Fanout;
import com.sonicsw.esb.itinerary.def.Step;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.ItineraryStartNode;
import com.sonicsw.esb.itinerary.model.ProcessExitConnector;
import com.sonicsw.esb.itinerary.model.StepConnector;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.impl.DefaultActivityEdge;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Itinerary {
    public static final String ITINERARY = "itinerary";

    public static void parse(ESBProcess process, XMLStreamReader xsr) throws XMLStreamException {
        ItineraryStartNode initialNode = new ItineraryStartNode(process);
        process.setInitialNode(initialNode);
        ActivityNode previousNode = Itinerary.parseSteps(xsr, (MainProcess)process, (ActivityNode)initialNode);
        Itinerary.initCounts(previousNode, process);
    }

    static ActivityNode parseSteps(XMLStreamReader xsr, MainProcess process, ActivityNode startNode) throws XMLStreamException {
        ActivityNode previousNode = startNode;
        ActivityNode[] nodes = null;
        while (xsr.hasNext()) {
            String stepElemName;
            int eventType = xsr.next();
            if (eventType == 1) {
                stepElemName = xsr.getLocalName();
                if (stepElemName.equals(ITINERARY)) continue;
                if (stepElemName.equals("step")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("decision")) {
                    nodes = Decision.parse(xsr, process);
                } else if (stepElemName.equals("fanout")) {
                    nodes = Fanout.parse(xsr, process);
                } else if (stepElemName.equals("fault")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("throw")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("exit")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("terminate")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("resubmit")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("rethrow")) {
                    nodes = Step.parse(xsr, process);
                } else if (stepElemName.equals("transform")) {
                    nodes = Step.parse(xsr, process);
                } else {
                    throw new Error("Invalid artifact " + stepElemName + " in ESB process");
                }
                previousNode = Itinerary.retrievePreviousNode(nodes, previousNode, process);
                continue;
            }
            if (eventType != 2 || !(stepElemName = xsr.getLocalName()).equals(ITINERARY) && !stepElemName.equals("path") && !stepElemName.equals("option")) continue;
            break;
        }
        return previousNode;
    }

    public static void parse(ESBProcess process, Element itineraryRootElem) {
        assert (itineraryRootElem.getLocalName().equals(ITINERARY));
        ItineraryStartNode initialNode = new ItineraryStartNode(process);
        process.setInitialNode(initialNode);
        ActivityNode previousNode = Itinerary.parseSteps(itineraryRootElem, (MainProcess)process, (ActivityNode)initialNode);
        Itinerary.initCounts(previousNode, process);
    }

    private static void initCounts(ActivityNode previousNode, ESBProcess process) {
        Itinerary.addEdge(process, previousNode, null, true);
        Decision.count = 0;
        Fanout.count = 0;
        Step.count = 0;
    }

    static ActivityNode parseSteps(Element rootElem, MainProcess process, ActivityNode startNode) {
        ActivityNode previousNode = startNode;
        NodeList childNodes = rootElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            Element stepElem = (Element)childNodes.item(i);
            String stepElemName = stepElem.getLocalName();
            ActivityNode[] nodes = null;
            if (stepElemName.equals("step")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("decision")) {
                nodes = Decision.parse(stepElem, process);
            } else if (stepElemName.equals("fanout")) {
                nodes = Fanout.parse(stepElem, process);
            } else if (stepElemName.equals("fault")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("throw")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("exit")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("terminate")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("resubmit")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("rethrow")) {
                nodes = Step.parse(stepElem, process);
            } else if (stepElemName.equals("transform")) {
                nodes = Step.parse(stepElem, process);
            } else {
                throw new Error("Invalid artifact " + stepElemName + " in ESB process");
            }
            previousNode = Itinerary.retrievePreviousNode(nodes, previousNode, process);
        }
        return previousNode;
    }

    private static ActivityNode retrievePreviousNode(ActivityNode[] nodes, ActivityNode previousNode, MainProcess process) {
        ActivityNode currentNode = nodes[0];
        Itinerary.addEdge(process, previousNode, currentNode, false);
        return nodes[1];
    }

    private static void addEdge(MainProcess process, ActivityNode previousNode, ActivityNode currentNode, boolean lastEdge) {
        DefaultActivityEdge edge = null;
        if (lastEdge) {
            if (previousNode instanceof ItineraryEndNode) {
                process.setEndNode((ItineraryEndNode)previousNode);
            } else {
                ItineraryEndNode finalNode = new ItineraryEndNode(process);
                process.addActivityNode(finalNode);
                edge = new ProcessExitConnector(previousNode, finalNode);
                process.setEndNode(finalNode);
            }
        } else if (!(previousNode instanceof FlowTerminationNode)) {
            edge = currentNode instanceof ItineraryEndNode ? new ProcessExitConnector(previousNode, (ItineraryEndNode)currentNode) : (currentNode instanceof EsbNode ? new StepConnector(previousNode, currentNode) : new DefaultActivityEdge(previousNode, currentNode));
        }
        if (edge != null) {
            process.addActivityEdge(edge);
            if (edge instanceof ProcessExitConnector && edge.getSource() instanceof ItineraryStartNode) {
                ((ItineraryStartNode)edge.getSource()).setEmptyProcess(true);
            }
        }
    }
}

