/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Caching;
import com.sonicsw.esb.itinerary.def.Common;
import com.sonicsw.esb.itinerary.def.FaultHandlerSerializer;
import com.sonicsw.esb.itinerary.def.MessageMapperSerializer;
import com.sonicsw.esb.itinerary.def.Params;
import com.sonicsw.esb.itinerary.model.DynamicAddressStepNode;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FaultNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.MappingCapable;
import com.sonicsw.esb.itinerary.model.OldTerminateStepNode;
import com.sonicsw.esb.itinerary.model.RejectStepNode;
import com.sonicsw.esb.itinerary.model.ResubmitNode;
import com.sonicsw.esb.itinerary.model.RethrowNode;
import com.sonicsw.esb.itinerary.model.TerminateStepNode;
import com.sonicsw.esb.itinerary.model.TransformationStepNode;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Step {
    public static final String START = "start";
    public static final String STEP = "step";
    public static final String FAULT = "fault";
    public static final String THROW = "throw";
    public static final String EXIT = "exit";
    public static final String TERMINATE = "terminate";
    public static final String RESUBMIT = "resubmit";
    public static final String RETHROW = "rethrow";
    public static final String CUSTOM = "custom";
    public static final String TRANSFORM = "transform";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String ENDPOINT_REF = "endpoint_ref";
    static int count = 0;
    private static final String REPLY_TO = "REPLY_TO";

    public static ActivityNode[] parse(XMLStreamReader xsr, MainProcess parentProcess) throws XMLStreamException {
        String stepName = xsr.getAttributeValue(null, NAME);
        stepName = Step.updateStepName(stepName);
        ActivityNode esbStepNode = null;
        String stepElemLocalName = xsr.getLocalName();
        if (stepElemLocalName.equals(STEP)) {
            String destinationName = xsr.getAttributeValue(null, ENDPOINT_REF);
            String destinationType = null;
            destinationType = destinationName.equals(REPLY_TO) ? REPLY_TO : xsr.getAttributeValue(null, TYPE);
            esbStepNode = Step.retrieveEsbStepNode(destinationName, destinationType, esbStepNode, parentProcess, stepName);
        } else if (stepElemLocalName.equals(FAULT)) {
            esbStepNode = new FaultNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(THROW)) {
            esbStepNode = new RejectStepNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(EXIT)) {
            esbStepNode = new ItineraryEndNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(TERMINATE)) {
            esbStepNode = new TerminateStepNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(RESUBMIT)) {
            esbStepNode = new ResubmitNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(RETHROW)) {
            esbStepNode = new RethrowNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (!stepElemLocalName.equals(CUSTOM) && !stepElemLocalName.equals(START) && stepElemLocalName.equals(TRANSFORM)) {
            esbStepNode = new TransformationStepNode(Step.getStepId(stepName), stepName, parentProcess);
        }
        Step.validateNodePopulateDisplayName(esbStepNode, stepElemLocalName, stepName);
        while (xsr.hasNext()) {
            String stepChildElemName;
            int eventType = xsr.next();
            if (eventType == 1) {
                stepChildElemName = xsr.getLocalName();
                if (stepChildElemName.equals("params")) {
                    XQParameters params = Params.parse(xsr, stepChildElemName);
                    if (!(esbStepNode instanceof EsbNode)) continue;
                    ((EsbNode)esbStepNode).setXQParameters(params);
                    continue;
                }
                if (stepChildElemName.equals("messageMapping")) {
                    if (!(esbStepNode instanceof MappingCapable)) continue;
                    MessageMapper msgMapper = MessageMapperSerializer.parse(xsr);
                    ((MappingCapable)((Object)esbStepNode)).setMessageMapper(msgMapper);
                    continue;
                }
                if (stepChildElemName.equals("faultHandler")) {
                    if (!(esbStepNode instanceof ExecutableNode)) continue;
                    FaultHandlerSerializer.parse((ExecutableNode)esbStepNode, xsr);
                    continue;
                }
                if (!"caching".equals(stepChildElemName) || !(esbStepNode instanceof EsbStepNode)) continue;
                Caching.parse(xsr, (EsbStepNode)esbStepNode);
                continue;
            }
            if (eventType != 2 || !(stepChildElemName = xsr.getLocalName()).equals(STEP) && !stepChildElemName.equals(FAULT) && !stepChildElemName.equals(THROW) && !stepChildElemName.equals(EXIT) && !stepChildElemName.equals(TERMINATE) && !stepChildElemName.equals(RESUBMIT) && !stepChildElemName.equals(RETHROW) && !stepChildElemName.equals(TRANSFORM)) continue;
            break;
        }
        return Step.retrieveNodes(esbStepNode, parentProcess);
    }

    private static String getStepId(String stepName) {
        return stepName + "." + count;
    }

    public static ActivityNode[] parse(Element stepElem, MainProcess parentProcess) {
        String stepElemLocalName = stepElem.getLocalName();
        assert (stepElemLocalName.equals(STEP));
        String stepName = stepElem.getAttribute(NAME);
        stepName = Step.updateStepName(stepName);
        ActivityNode esbStepNode = null;
        if (stepElemLocalName.equals(STEP)) {
            String destinationName = stepElem.getAttribute(ENDPOINT_REF);
            String destinationType = null;
            destinationType = destinationName.equals(REPLY_TO) ? REPLY_TO : stepElem.getAttribute(TYPE);
            esbStepNode = Step.retrieveEsbStepNode(destinationName, destinationType, esbStepNode, parentProcess, stepName);
        } else if (stepElemLocalName.equals(FAULT)) {
            esbStepNode = new FaultNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(THROW)) {
            esbStepNode = new RejectStepNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(EXIT)) {
            esbStepNode = new ItineraryEndNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(TERMINATE)) {
            esbStepNode = new TerminateStepNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(RESUBMIT)) {
            esbStepNode = new ResubmitNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (stepElemLocalName.equals(RETHROW)) {
            esbStepNode = new RethrowNode(Step.getStepId(stepName), stepName, parentProcess);
        } else if (!stepElemLocalName.equals(CUSTOM) && !stepElemLocalName.equals(START) && stepElemLocalName.equals(TRANSFORM)) {
            esbStepNode = new TransformationStepNode(Step.getStepId(stepName), stepName, parentProcess);
        }
        Step.validateNodePopulateDisplayName(esbStepNode, stepElemLocalName, stepName);
        NodeList childNodes = stepElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            Element stepChildElem = (Element)childNodes.item(i);
            String stepChildElemName = stepChildElem.getLocalName();
            if (stepChildElemName.equals("params")) {
                XQParameters params = Params.parse(stepChildElem);
                if (!(esbStepNode instanceof EsbNode)) continue;
                ((EsbNode)esbStepNode).setXQParameters(params);
                continue;
            }
            if (stepChildElemName.equals("messageMapping")) {
                if (!(esbStepNode instanceof MappingCapable)) continue;
                MessageMapper msgMapper = MessageMapperSerializer.parse(stepChildElem);
                ((MappingCapable)((Object)esbStepNode)).setMessageMapper(msgMapper);
                continue;
            }
            if (stepChildElemName.equals("faultHandler")) {
                if (!(esbStepNode instanceof ExecutableNode)) continue;
                FaultHandlerSerializer.parse((ExecutableNode)esbStepNode, stepChildElem);
                continue;
            }
            if (!"caching".equals(stepChildElemName) || !(esbStepNode instanceof EsbStepNode)) continue;
            Caching.parse(stepChildElem, (EsbStepNode)esbStepNode);
        }
        return Step.retrieveNodes(esbStepNode, parentProcess);
    }

    private static void validateNodePopulateDisplayName(ActivityNode esbStepNode, String stepElemLocalName, String stepName) {
        if (null == esbStepNode) {
            throw new ProcessModelException("Invalid element in the esb process model named '" + stepElemLocalName + "'");
        }
        esbStepNode.setDisplayName(stepName);
    }

    private static ActivityNode[] retrieveNodes(ActivityNode esbStepNode, MainProcess parentProcess) {
        parentProcess.addActivityNode(esbStepNode);
        ActivityNode[] nodes = new ActivityNode[]{esbStepNode, esbStepNode};
        return nodes;
    }

    private static String updateStepName(String stepNameParam) {
        String stepName = stepNameParam;
        ++count;
        if (stepName == null || "".equals(stepName.trim())) {
            stepName = "Step-" + count;
        }
        return stepName;
    }

    private static ActivityNode retrieveEsbStepNode(String destinationName, String destinationType, ActivityNode esbStepNodeParam, MainProcess parentProcess, String stepName) {
        ActivityNode esbStepNode = esbStepNodeParam;
        XQAbstractAddressImpl endpointRef = new XQAbstractAddressImpl(destinationName, destinationType, stepName);
        esbStepNode = DynamicAddressStepNode.isExpressionAddress(endpointRef) ? new DynamicAddressStepNode(Step.getStepId(stepName), parentProcess) : (OldTerminateStepNode.isTerminateStepService(endpointRef) ? new OldTerminateStepNode(Step.getStepId(stepName), stepName, parentProcess) : new EsbStepNode(Step.getStepId(stepName), parentProcess));
        ((EsbNode)esbStepNode).setEndpointRef((XQAddress)endpointRef);
        return esbStepNode;
    }

    public static void serialize(EsbNode node, Writer writer) throws IOException {
        writer.write("<xq:step");
        Common.marshallAttribute(NAME, node.getDisplayName(), writer);
        XQAbstractAddressImpl address = (XQAbstractAddressImpl)node.getEndpointRef(null);
        if (address != null) {
            Common.marshallAttribute(TYPE, address.getTypeAsString(), writer);
            Common.marshallAttribute(ENDPOINT_REF, address.getName(), writer);
        }
        writer.write(">");
        Params.serialize(node.getXQParameters(), writer);
        MessageMapper msgMapper = null;
        msgMapper = node.getMessageMapper();
        if (msgMapper != null) {
            MessageMapperSerializer.marshall(msgMapper, writer);
        }
        FaultHandler fh = null;
        fh = node.getScope().getFaultHandlers();
        if (fh != null) {
            FaultHandlerSerializer.marshallFHStep(fh, writer, false);
        }
        if (node instanceof EsbStepNode) {
            EsbStepNode esbStepNode = (EsbStepNode)node;
            Caching.serialize(esbStepNode, writer);
        }
        Common.marshallCloseElement("xq:step", writer);
    }

    public static void serializeTransformStep(TransformationStepNode node, Writer writer) throws IOException {
        writer.write("<xq:transform");
        Common.marshallAttribute(NAME, node.getDisplayName(), writer);
        XQAbstractAddressImpl address = (XQAbstractAddressImpl)node.getEndpointRef(null);
        if (address != null) {
            Common.marshallAttribute(TYPE, address.getTypeAsString(), writer);
            Common.marshallAttribute(ENDPOINT_REF, address.getName(), writer);
        }
        writer.write(">");
        MessageMapper msgMapper = null;
        msgMapper = node.getMessageMapper();
        if (msgMapper != null) {
            MessageMapperSerializer.marshall(msgMapper, writer);
        }
        FaultHandler fh = null;
        fh = node.getScope().getFaultHandlers();
        if (fh != null) {
            FaultHandlerSerializer.marshallFHStep(fh, writer, false);
        }
        if (node instanceof EsbStepNode) {
            TransformationStepNode esbStepNode = node;
            Caching.serialize(esbStepNode, writer);
        }
        Common.marshallCloseElement("xq:transform", writer);
    }

    public static void serializeFlowTermination(ActivityNode node, Writer writer, String stepName) throws IOException {
        writer.write("<xq:" + stepName);
        Common.marshallAttribute(NAME, node.getDisplayName(), writer);
        writer.write(">");
        if (node instanceof EsbNode) {
            Params.serialize(((EsbNode)node).getXQParameters(), writer);
        }
        MessageMapper msgMapper = null;
        if (node instanceof MappingCapable && (msgMapper = ((MappingCapable)((Object)node)).getMessageMapper()) != null) {
            MessageMapperSerializer.marshall(msgMapper, writer);
        }
        FaultHandler fh = null;
        if (node instanceof ExecutableNode && (fh = ((ExecutableNode)node).getScope().getFaultHandlers()) != null) {
            FaultHandlerSerializer.marshallFHStep(fh, writer, false);
        }
        Common.marshallCloseElement("xq:" + stepName, writer);
    }
}

