/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.def.ESBProcessResourceFactory;
import com.sonicsw.esb.itinerary.def.FaultHandlerSerializer;
import com.sonicsw.esb.itinerary.def.ItineraryParserFactory;
import com.sonicsw.esb.itinerary.def.ItinerarySerializerFactory;
import com.sonicsw.esb.itinerary.engine.CannotDetermineRME;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.InvalidItineraryMessageException;
import com.sonicsw.esb.itinerary.engine.ItineraryEngineActionManager;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessChangeEventManager;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.ProcessTrackerNotifier;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceGeneratorFactory;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceSerializerFactory;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.RethrowNode;
import com.sonicsw.esb.process.def.ProcessDefParserFactory;
import com.sonicsw.esb.process.def.ProcessDefSerializerFactory;
import com.sonicsw.esb.process.def.ProcessResource;
import com.sonicsw.esb.process.def.ProcessResourceFactory;
import com.sonicsw.esb.process.engine.EngineException;
import com.sonicsw.esb.process.engine.OutOfBandTokenHandler;
import com.sonicsw.esb.process.engine.PersistenceManager;
import com.sonicsw.esb.process.engine.ProcessEngine;
import com.sonicsw.esb.process.engine.ProcessEngineActionManager;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.engine.ProcessInstanceGenerator;
import com.sonicsw.esb.process.engine.ProcessInstanceGeneratorFactory;
import com.sonicsw.esb.process.engine.ProcessInstanceSerializerFactory;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DataToken;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQProcessAddressImpl;
import com.sonicsw.xqimpl.envelope.XQURLAddressImpl;
import com.sonicsw.xqimpl.service.CriticalException;
import com.sonicsw.xqimpl.service.MessageAlreadyRejected;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQRegistry;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class ItineraryEngine
implements ProcessEngine,
OutOfBandTokenHandler {
    private ProcessResourceFactory m_resourceFactory;
    private ProcessDefParserFactory m_parserFactory;
    private com.sonicsw.esb.process.engine.ProcessChangeEventManager m_processChangeManager;
    private Map<String, ESBProcess> m_cachedProcDefs = new HashMap<String, ESBProcess>();
    private ProcessDefSerializerFactory m_procDefSerializerFactory;
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    private RejectedMessageDispatcher m_rejectedMessageDispatcher = new RejectedMessageDispatcher();
    private ProcessInstanceSerializerFactory m_instSerializerFactory;
    private ProcessInstanceGeneratorFactory m_instGeneratorFactory;
    private ProcessInstanceGenerator m_instGenerator;
    private ProcessEngineActionManager m_actionMgr;
    public static final String INITIATE_PROCESS = "initiate-process";
    public static final String PROCESS_STEP = "PROCESS_STEP";
    public static final String PARENT_PROC_INST = "PARENT_PROCESS_INSTANCE";
    public static final String ACTIVATION_TOKEN = "TokenWithActivationInfo";
    private static List<String> s_reservedServices = new ArrayList<String>();

    public ItineraryEngine() {
        s_reservedServices.add("TerminateStepService");
        s_reservedServices.add("InternalStep.Rethrow");
        s_reservedServices.add("InternalStep.Resubmit");
        s_reservedServices.add("InternalStep.Reject");
        s_reservedServices.add("InternalStep.Fault");
        s_reservedServices.add("InternalStep.Terminate");
        s_reservedServices.add("InternalStep.Exit");
        s_reservedServices.add("InternalStep.Transformation");
    }

    @Override
    public void init() {
        if (this.m_resourceFactory == null) {
            this.m_resourceFactory = new ESBProcessResourceFactory();
        }
        if (this.m_parserFactory == null) {
            this.m_parserFactory = new ItineraryParserFactory();
        }
        if (this.m_procDefSerializerFactory == null) {
            this.m_procDefSerializerFactory = new ItinerarySerializerFactory();
        }
        if (this.m_instGeneratorFactory == null) {
            this.setProcessInstanceGeneratorFactory(new XQProcessInstanceGeneratorFactory());
        }
        if (this.m_instSerializerFactory == null) {
            this.m_instSerializerFactory = new XQProcessInstanceSerializerFactory();
        }
        if (this.m_processChangeManager == null) {
            this.m_processChangeManager = new ProcessChangeEventManager();
            this.m_processChangeManager.registerProcessChangeListener(new ProcessTrackerNotifier());
        }
        if (this.m_actionMgr == null) {
            this.m_actionMgr = new ItineraryEngineActionManager();
            ((ItineraryEngineActionManager)this.m_actionMgr).setupDefaults();
        }
        s_log.logDebug("Itinerary Engine initialized successfully.. ");
    }

    @Override
    public void setProcessResourceFactory(ProcessResourceFactory resourceFactory) {
        this.m_resourceFactory = resourceFactory;
    }

    @Override
    public ProcessResourceFactory getProcessResourceFactory() {
        return this.m_resourceFactory;
    }

    @Override
    public ProcessDefParserFactory getParserFactory() {
        return this.m_parserFactory;
    }

    public <T extends EsbMessageExchange> void handleMessage(T mex) throws Throwable {
        DataToken token = new DataToken(null, null, mex);
        this.handleToken(token);
    }

    @Override
    public void handleToken(Token token) throws Throwable {
        try {
            if (this.isProcessInitiation(token)) {
                this.initiateProcess(token);
            } else {
                this.executeProcess(token);
            }
        }
        catch (EngineException e) {
            this.sendToRME(e, null, token);
        }
        catch (MessageAlreadyRejected e) {
        }
        catch (CriticalException e) {
            throw e;
        }
        catch (Throwable e) {
            ItineraryException ex = new ItineraryException(e, e.getMessage(), token);
            this.sendToRME(ex, null, token);
        }
    }

    public boolean isProcessInitiation(Token token) {
        XQAddress destinationAddr = ((EsbMessageExchange)token.getData()).getDestinationAddress();
        return destinationAddr != null && destinationAddr.getType() == 2;
    }

    @Override
    public void enqueueToken(Token token) {
        if (token == null) {
            return;
        }
        if (token instanceof CompositeToken) {
            for (Token eachToken : ((CompositeToken)token).getTokens()) {
                eachToken.getFromActivityNode().offerOutgoing(eachToken);
            }
        } else {
            token.getFromActivityNode().offerOutgoing(token);
        }
    }

    @Override
    public void destroy() {
        PersistenceManager.destroy();
    }

    @Override
    public ProcessInstance getProcessInstance(Token token) {
        Object procInst = token.getProcessInstance();
        if (procInst == null) {
            procInst = this.m_instGenerator.retrieveProcessInstance(token);
            token.setProcessInstance(procInst);
        }
        return procInst;
    }

    public void initiateProcess(Token token) throws Throwable {
        XQURLAddressImpl urlAddressImpl;
        XQAbstractAddressImpl xqProcessAddr;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQAddress destinationAddr = mex.getDestinationAddress();
        XQAbstractAddressImpl xQAbstractAddressImpl = xqProcessAddr = destinationAddr instanceof XQAbstractAddressImpl ? (XQAbstractAddressImpl)destinationAddr : null;
        if (xqProcessAddr == null && destinationAddr instanceof XQURLAddressImpl && (urlAddressImpl = (XQURLAddressImpl)destinationAddr).getWrappedAddress() instanceof XQAbstractAddressImpl) {
            xqProcessAddr = (XQAbstractAddressImpl)urlAddressImpl.getWrappedAddress();
        }
        if (xqProcessAddr != null) {
            String processName = xqProcessAddr.getName();
            String stepName = xqProcessAddr.getStepName();
            if (stepName == null || stepName.trim().length() == 0) {
                XQProcessConfig procConfig = this.getProcessConfig(xqProcessAddr, token);
                String processEntryPoint = procConfig.getEntryEndpoint();
                String msgReplyTo = Optional.ofNullable(mex.getInputMessage().getReplyTo()).map(XQAddress::getName).orElse(null);
                ItineraryEngine.checkLoopCondition(processEntryPoint, msgReplyTo, token);
                ESBProcess process = this.getProcessByName(processName, procConfig);
                ProcessInstance parentProcInst = (ProcessInstance)token.removeProperty(PARENT_PROC_INST);
                ProcessInstance newProcInst = null;
                newProcInst = parentProcInst == null ? this.m_instGenerator.newProcessInstance(token, process, procConfig) : this.m_instGenerator.newChildProcessInstance(token, process, parentProcInst, procConfig);
                token.setProcessInstance(newProcInst);
                this.logData(processName);
                process.initiate(token);
            } else {
                this.initiateProcessAtStep(token, processName, stepName);
            }
        } else {
            throw new ItineraryException("Cannot determine the process name from address: " + destinationAddr, token);
        }
    }

    private static void checkLoopCondition(String processEntryPoint, String msgReplyTo, Token token) throws ItineraryException {
        if ((System.getProperty("SonicESB.Process.LoopDetection") == null || Boolean.getBoolean("SonicESB.Process.LoopDetection")) && processEntryPoint != null && msgReplyTo != null && StringUtils.equals((CharSequence)processEntryPoint, (CharSequence)msgReplyTo)) {
            throw new ItineraryException("Loop condition detected", token);
        }
    }

    @Override
    public ESBProcess getProcessByName(String processName) {
        XQProcessConfig procConfig = this.lookupProcessConfig(processName, null);
        return this.getProcessByName(processName, procConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESBProcess getProcessByName(String processName, XQProcessConfig procConfig) {
        ESBProcess proc = this.m_cachedProcDefs.get(processName);
        if (proc == null) {
            ItineraryEngine itineraryEngine = this;
            synchronized (itineraryEngine) {
                proc = this.m_cachedProcDefs.get(processName);
                if (proc == null) {
                    Object esbpContent = procConfig.getItineraryString();
                    if (esbpContent == null) {
                        esbpContent = procConfig.getItineraryElement();
                    }
                    if (esbpContent == null) {
                        throw new ItineraryException("Cannot find the contents of the esbp process", null);
                    }
                    ProcessResource procRes = this.m_resourceFactory.createProcessResource(processName, null, esbpContent);
                    proc = (ESBProcess)this.m_parserFactory.getProcessDefParser().parse(procRes);
                    FaultHandlerSerializer.setFaultHandler(proc, procConfig);
                    if (XQContainer.isCacheEnabled() && !procConfig.isDynamicItinerary()) {
                        this.m_cachedProcDefs.put(processName, proc);
                    }
                }
            }
        }
        return proc;
    }

    public Token executeProcess(Token token) throws Throwable {
        XQProcessInstance procInst = (XQProcessInstance)this.getProcessInstance(token);
        if (procInst != null) {
            ActivityNode currentNode;
            if (s_log.isDebugLoggingEnabled()) {
                s_log.logDebug("Continuing ESB process instance " + procInst.getPID());
            }
            if ((currentNode = procInst.getActiveEsbNode(token)) == null) {
                throw new ItineraryException(null, "Cannot find active node to continue ESB process", token);
            }
            token.setFromActivityNode(currentNode);
            currentNode.offerIncoming(token);
        }
        return null;
    }

    private void initiateProcessAtStep(Token token, String processName, String compositeStepName, boolean sendMsg, boolean isContinuation) throws Throwable {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQAddress destinationAddr = mex.getDestinationAddress();
        XQAbstractAddressImpl xqProcessAddr = (XQAbstractAddressImpl)destinationAddr;
        StringTokenizer st = new StringTokenizer(compositeStepName, ":");
        String processStepName = st.nextToken();
        XQProcessConfig procConfig = this.getProcessConfig(xqProcessAddr, token);
        ESBProcess process = this.getProcessByName(processName, procConfig);
        ProcessInstance procInst = this.m_instGenerator.newProcessInstance(token, process, procConfig);
        token.setProcessInstance(procInst);
        this.logData(processName);
        this.initiateProcessStep(procInst, procInst, process, processStepName, st, token, sendMsg, isContinuation);
    }

    private void logData(String processName) {
        if (s_log.isDebugLoggingEnabled()) {
            s_log.logDebug("Initiating ESB process " + processName);
        }
    }

    public void initiateProcessAtStep(Token token, String processName, String compositeStepName) throws Throwable {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        Token activationToken = (Token)((XQMessageInternal)mex.getInputMessage()).removeSidebandProperty(ACTIVATION_TOKEN);
        if (activationToken != null) {
            XQProcessInstance procInst = (XQProcessInstance)activationToken.getProcessInstance();
            ActivityNode node = procInst.getActiveEsbNode(activationToken);
            if (node == null) {
                throw new ItineraryException("Cannot find node to activate the process", token);
            }
            EsbMessageExchange actvMex = (EsbMessageExchange)activationToken.getData();
            if (mex != actvMex) {
                actvMex.setCommitFlag(mex.getCommitFlag());
                actvMex.setConnectionMap(mex.getConnectionMap());
                actvMex.setEndpointContext(mex.getEndpointContext());
                actvMex.setEndpointRegistry(mex.getEndpointRegistry());
                actvMex.setEnvelopeFactory(mex.getEnvelopeFactory());
                actvMex.setExchangeImmediate(mex.isExchangeImmediate());
                actvMex.setMessageFactory(mex.getMessageFactory());
                actvMex.setQOS(mex.getQOS());
                actvMex.setRMEAddress(mex.getRMEAddress());
                actvMex.setSessionName(mex.getSessionName());
                actvMex.setXQDispatcher(mex.getXQDispatcher());
                actvMex.setXQParameters(mex.getXQParameters());
            }
            this.goToStep((EsbStepNode)node, activationToken);
        } else {
            this.initiateProcessAtStep(token, processName, compositeStepName, true, false);
        }
    }

    public void processContinuationTokenForStep(Token token, String processName, String compositeStepName) throws Throwable {
        this.initiateProcessAtStep(token, processName, compositeStepName, false, true);
    }

    private void initiateProcessStep(ProcessInstance topmostProcInst, ProcessInstance procInst, ESBProcess process, String processStepName, StringTokenizer st, Token token, boolean sendMsg, boolean isContinuation) throws Throwable {
        ActivityNode node = process.getActivityNodeByName(processStepName);
        this.assertStepNode(processStepName, node, token);
        if (!isContinuation) {
            procInst.changeProcessState(token, ProcessState.OPEN);
        }
        procInst.setActiveNode(node, null);
        XQAddress stepXQAddr = ((EsbStepNode)node).getEndpointRef(token);
        if (st.hasMoreTokens()) {
            if (stepXQAddr.getType() != 2) {
                throw new ItineraryException("Step name " + processStepName + " in process " + process.getProcessName() + " does not invoke a sub-process", token);
            }
            String subProcessName = stepXQAddr.getName();
            XQProcessConfig subProcConfig = this.getProcessConfig((XQAbstractAddressImpl)stepXQAddr, token);
            ESBProcess subProcess = this.getProcessByName(subProcessName, subProcConfig);
            ProcessInstance subProcInst = this.m_instGenerator.newChildProcessInstance(token, subProcess, procInst, subProcConfig);
            if (s_log.isDebugLoggingEnabled()) {
                s_log.logDebug("Initiated ESB sub-process " + subProcessName);
            }
            token.setProcessInstance(subProcInst);
            this.initiateProcessStep(topmostProcInst, subProcInst, subProcess, st.nextToken(), st, token, sendMsg, isContinuation);
        } else {
            token.setProcessInstance(procInst);
            if (sendMsg) {
                this.goToStep((EsbStepNode)node, token);
            }
        }
    }

    public void continueProcess(Token token, ActivityNode continueFromNode) {
        if (continueFromNode instanceof ESBProcess) {
            XQProcessInstance procInst;
            String processName = continueFromNode.getDisplayName();
            XQProcessConfig procConfig = this.lookupProcessConfig(processName, token);
            ESBProcess process = this.getProcessByName(processName, procConfig);
            XQProcessInstance newProcInst = procInst = (XQProcessInstance)token.getProcessInstance();
            newProcInst.setProcess(process);
            token.setProcessInstance(newProcInst);
            process.offerIncoming(token);
        } else if (continueFromNode instanceof EsbNode) {
            boolean invokeDirectly = ItineraryEngine.useIntraContainerDispatch(((EsbNode)continueFromNode).getEndpointRef(token));
            if (invokeDirectly) {
                continueFromNode.offerIncoming(token);
            } else {
                token.setDestinationNode(continueFromNode);
                XQAddress stepAddress = ((EsbNode)continueFromNode).getEndpointRef(token);
                ((EsbMessageExchange)token.getData()).setDestinationAddress(stepAddress);
                this.handleOutOfBandToken(null, token);
            }
        }
    }

    private XQProcessConfig getProcessConfig(XQAbstractAddressImpl procAddr, Token token) {
        XQProcessConfig procConfig = null;
        if (procAddr instanceof XQProcessAddressImpl) {
            procConfig = ((XQProcessAddressImpl)procAddr).getProcess();
        }
        if (procConfig == null) {
            procConfig = this.lookupProcessConfig(procAddr.getName(), token);
        }
        return procConfig;
    }

    XQProcessConfig lookupProcessConfig(String processName, Token token) {
        try {
            XQProcessConfig procCfg = XQConfigManager.getInstance(null).lookupProcessConfig(processName);
            return (XQProcessConfig)procCfg.clone();
        }
        catch (XQConfigurationException e) {
            throw new ItineraryException(e, "Cannot find process " + processName, token);
        }
    }

    @Override
    public com.sonicsw.esb.process.engine.ProcessChangeEventManager getProcessChangeEventManager() {
        return this.m_processChangeManager;
    }

    @Override
    public ProcessDefSerializerFactory getProcessDefSerializerFactory() {
        return this.m_procDefSerializerFactory;
    }

    @Override
    public ProcessInstanceGeneratorFactory getProcessInstanceGeneratorFactory() {
        return this.m_instGeneratorFactory;
    }

    public ProcessInstanceGenerator getProcessInstanceGenerator() {
        return this.m_instGenerator;
    }

    @Override
    public ProcessInstanceSerializerFactory getProcessInstanceSerializerFactory() {
        return this.m_instSerializerFactory;
    }

    @Override
    public void handleOutOfBandToken(ActivityNode fromNode, Token token) {
        if (token == null || token.isTokenOfType(Token.Type.NULL, false)) {
            return;
        }
        try {
            EsbMessageExchange mex = (EsbMessageExchange)token.getData();
            EsbNode addressToNode = (EsbNode)token.getDestinationNode();
            if (addressToNode != null) {
                XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
                procInst.setActiveNode(addressToNode, null);
                token.setDestinationNode(null);
                this.m_instSerializerFactory.createProcessInstanceSerializer().serialize(addressToNode, token);
                MessageSendingHelper.sendToAddress(mex, "");
            } else if (token.isTokenOfType(Token.Type.RME, false) || token.isTokenOfType(Token.Type.FAULT, false)) {
                boolean result = this.handleFaults(fromNode, token);
                if (!result) {
                    Throwable t = ((EsbMessageExchange)token.getData()).getImmediateThrowable();
                    if (t instanceof ItineraryException) {
                        throw ((ItineraryException)t).getCause();
                    }
                    throw t;
                }
            } else {
                XQAbstractAddressImpl destXQAddress = (XQAbstractAddressImpl)mex.getDestinationAddress();
                if (destXQAddress != null) {
                    if (destXQAddress.getType() == 2) {
                        XQProcessAddressImpl procAddr;
                        String stepName = destXQAddress.getStepName();
                        if (stepName != null) {
                            if (fromNode.getParentProcess().getProcessName().equals(destXQAddress.getName())) {
                                ActivityNode stepNode = ((ESBProcess)fromNode.getParentProcess()).getActivityNodeByName(stepName);
                                if (stepNode != null) {
                                    this.goToStep((EsbNode)stepNode, token);
                                } else {
                                    XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
                                    token.setFromActivityNode(null);
                                    XQProcessConfig procConfig = this.getProcessConfig(destXQAddress, token);
                                    ESBProcess process = this.getProcessByName(destXQAddress.getName(), procConfig);
                                    stepNode = process.getActivityNodeByName(stepName);
                                    if (stepNode == null) {
                                        throw new ItineraryException("Cannot find step `" + stepName + "` in process `" + process.getProcessName(), token);
                                    }
                                    procInst.setProcessConfig(procConfig);
                                    procInst.setProcess(process);
                                    this.continueProcess(token, stepNode);
                                }
                            } else {
                                token.getProcessInstance().changeProcessState(token, ProcessState.ABANDONED);
                                this.initiateProcessAtStep(token, destXQAddress.getName(), stepName);
                            }
                            return;
                        }
                        if (destXQAddress instanceof XQProcessAddressImpl && (procAddr = (XQProcessAddressImpl)destXQAddress).getProcess().isDynamicItinerary() && procAddr.isContinueAsDynamicProcess()) {
                            this.handleDynamicItineraryContinuation(fromNode, token);
                            return;
                        }
                    }
                    mex.setInProcess(false);
                    token.getProcessInstance().changeProcessState(token, ProcessState.ABANDONED);
                    MessageSendingHelper.sendToAddress(mex, "Sending messages that are leaving the itinerary");
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ItineraryException(e, e.getMessage(), token);
        }
    }

    public void handleDynamicItineraryContinuation(ActivityNode fromNode, Token token) {
        XQProcessAddressImpl procAddr;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQAddress address = mex.getDestinationAddress();
        if (address instanceof XQProcessAddressImpl && (procAddr = (XQProcessAddressImpl)address).getProcess().isDynamicItinerary()) {
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            XQProcessConfig procConfig = procAddr.getProcess();
            Object esbpContent = procConfig.getItineraryString();
            if (esbpContent == null) {
                esbpContent = procConfig.getItineraryElement();
            }
            if (esbpContent == null) {
                throw new ItineraryException("Cannot find the contents of the esbp process", null);
            }
            ProcessResource procRes = this.m_resourceFactory.createProcessResource(procAddr.getName(), null, esbpContent);
            ESBProcess process = (ESBProcess)this.m_parserFactory.getProcessDefParser().parse(procRes);
            FaultHandlerSerializer.setFaultHandler(process, procConfig);
            procInst.overrideProcess(process, procConfig, token);
            token.setFromActivityNode(fromNode);
            process.getInitialNode().offerIncoming(token);
        }
    }

    public boolean handleFaults(ActivityNode fromNode, Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst instanceof FaultProcessInstance) {
            RethrowNode.rethrow(token);
            return true;
        }
        FaultHandler fh = ItineraryEngine.findFaultHandler(fromNode, token);
        boolean isTokenRethrown = token.removeProperty("IsRethrown") != null;
        ActivityNode faultHandlerNode = null;
        if (fh != null) {
            try {
                faultHandlerNode = fh.getFaultHandlerActivityNode("*", token);
            }
            catch (Throwable e) {
                s_log.logInformation("Error while computing fault handler for " + fh.getTarget() + ". Error: " + e.getMessage());
                s_log.logDebug(e);
            }
        }
        if (faultHandlerNode != null && faultHandlerNode instanceof ESBProcess) {
            ProcessInstanceProps origProcessProps = procInst.getProcessInstanceProperties();
            ActivityNode activeNode = procInst.getActiveEsbNode(token);
            if (activeNode == null) {
                activeNode = procInst.getPreviousActiveEsbNode(token);
            }
            if (activeNode != null) {
                procInst.setActiveNode(activeNode, token);
            }
            int unWindCount = 0;
            try {
                unWindCount = Integer.valueOf((String)token.getProperty("UnWindCount"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (unWindCount > 0) {
                if (!isTokenRethrown) {
                    origProcessProps.getAllProcessProps().put("Fault.Source.TopProcessName", origProcessProps.getRootProcessName());
                    origProcessProps.getAllProcessProps().put("Fault.Source.ProcessName", origProcessProps.getProcessName());
                    origProcessProps.getAllProcessProps().put("Fault.Source.StepName", origProcessProps.getStepName());
                }
                procInst.unwind(token, unWindCount);
                if (s_log.isDebugLoggingEnabled()) {
                    s_log.logDebug("Escalating fault to process: " + token.getProcessInstance().getPID());
                }
            }
            if (token.isTokenOfType(Token.Type.FAULT, true)) {
                origProcessProps.setUserDefinedFaultAddress(mex.getDestinationAddress());
            }
            if (mex.getImmediateThrowable() != null) {
                RMEMessage rmeMessage = new RMEMessage(((ItineraryException)mex.getImmediateThrowable()).getCause(), mex.getRMEAddress(), mex.getMessageFactory(), mex.getInputMessage(), mex.getXQParameters(), "XQ_SERVICE_EXCEPTION");
                mex.setRMEMessage(rmeMessage);
            }
            if (token.isTokenOfType(Token.Type.RME, true)) {
                this.m_processChangeManager.errorOccurred(token, "SERVICE_ERROR");
            }
            ((XQMessageInternal)mex.getInputMessage()).removeSidebandProperty("SonicESB.LG_REPORT_FAILURE");
            FaultProcessInstance fhProcInst = new FaultProcessInstance(procInst.getProcessInstanceGenerator(), fh, token);
            token.setProcessInstance(fhProcInst);
            if (s_log.isDebugLoggingEnabled()) {
                s_log.logDebug("Using fault handler " + faultHandlerNode.getDisplayName() + " for process instance: " + procInst.getPID());
            }
            faultHandlerNode.offerIncoming(token);
        } else {
            FaultProcessInstance fhProcInst = procInst.getFaultHandlerProcessInstance();
            if (fhProcInst != null) {
                ItineraryEngine.setRmeOrFaultFromFH(fhProcInst, procInst, token);
            }
            if (s_log.isDebugLoggingEnabled()) {
                s_log.logDebug("Did not find any fault handler for process instance: " + procInst.getPID());
            }
            token.getProcessInstance().getProcessDefinition().getEndNode().offerIncoming(token);
        }
        return true;
    }

    private static FaultHandler findFaultHandler(ActivityNode fromNodeParam, Token token) {
        ActivityNode fromNode = fromNodeParam;
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        ProcessInstanceProps props = procInst.getProcessInstanceProperties();
        String parentStepTrail = props.getParentStepsTrail();
        int unwindCount = 0;
        FaultHandler fh = ItineraryEngine.findFaultHandler(fromNode, procInst, token);
        while (fh == null && procInst.isSubProcess()) {
            procInst = procInst.getParentProcessInstance(token, true);
            ++unwindCount;
            props.popParentStepName();
            fromNode = procInst.getActiveEsbNode(token);
            fh = ItineraryEngine.findFaultHandler(fromNode, procInst, token);
        }
        if (unwindCount > 0) {
            props.setParentStepsTrail(parentStepTrail);
        }
        token.setProperty("UnWindCount", unwindCount + "");
        return fh;
    }

    private static FaultHandler findFaultHandler(ActivityNode fromNodeParam, XQProcessInstance procInst, Token token) {
        ActivityNode fromNode = fromNodeParam;
        FaultHandler fh = null;
        if (fromNode == null) {
            fromNode = token.getFromActivityNode();
        }
        if (fromNode != null) {
            if (fromNode instanceof EsbNode) {
                ExecutableNode node = (ExecutableNode)fromNode;
                fh = ItineraryEngine.adjustFaultHandler(procInst, node, token);
            }
            if (fh == null) {
                fh = ItineraryEngine.adjustFaultHandler(procInst, fromNode.getParentProcess(), token);
            }
        }
        return fh;
    }

    private static FaultHandler adjustFaultHandler(XQProcessInstance procInst, ExecutableNode node, Token token) {
        boolean isFaultEscalated;
        boolean isTokenRethrown = token.getProperty("IsRethrown") != null;
        boolean bl = isFaultEscalated = token.removeProperty("IsEscalated") != null;
        if (isTokenRethrown && !isFaultEscalated) {
            token.setProperty("IsEscalated", "true");
            return null;
        }
        FaultHandler fh = node.getScope().getFaultHandlers();
        if (fh != null) {
            if (procInst.isFaultHandlingDisabled(fh, node, token)) {
                s_log.logDebug("Fault handler is disabled for " + node.getDisplayName());
                fh = null;
            } else {
                token.setProperty("TargetNode", node);
            }
        }
        return fh;
    }

    public void goToStep(EsbNode gotoStepNode, Token tokenParam) throws Throwable {
        Token token = tokenParam;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (s_log.isDebugLoggingEnabled()) {
            s_log.logDebug("Sending directly to step " + gotoStepNode.getDisplayName() + " in process instance " + token.getProcessInstance().getPID());
        }
        XQAddress stepAddress = gotoStepNode.getEndpointRef(token);
        mex.setDestinationAddress(stepAddress);
        boolean invokeDirectly = ItineraryEngine.useIntraContainerDispatch(stepAddress);
        if (invokeDirectly) {
            if (gotoStepNode instanceof ItineraryEndNode) {
                token = ItineraryEndNode.createTokens((XQProcessInstance)token.getProcessInstance(), token, gotoStepNode);
            }
            if (token instanceof CompositeToken) {
                for (Token eachToken : ((CompositeToken)token).getTokens()) {
                    gotoStepNode.offerIncoming(eachToken);
                }
            } else {
                gotoStepNode.offerIncoming(token);
            }
        } else {
            token.setDestinationNode(gotoStepNode);
            this.handleOutOfBandToken(null, token);
        }
    }

    private void assertStepNode(String stepName, ActivityNode gotoStep, Token token) {
        if (gotoStep == null) {
            throw new ItineraryException(null, "Cannot find step `" + stepName + "` in this itinerary", token);
        }
        if (!(gotoStep instanceof EsbNode)) {
            throw new ItineraryException(null, "Cannot address to an activity `" + stepName + "` that is not an ESB step node", token);
        }
    }

    public static boolean hasProcessState(XQMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("ItineraryEngine.hasProcessState(): null argument");
        }
        return ItineraryEngine.isBPMessage(msg);
    }

    private static boolean isBPMessage(XQMessage msg) {
        try {
            XQPart part;
            if (msg != null && (part = msg.getPart(0)) != null) {
                String contentType = part.getContentType();
                return contentType != null && contentType.equals("application/x-sonicxq-bpheader; version=2.0");
            }
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
        return false;
    }

    public void sendToRME(String sender, Token token) {
        try {
            this.sendToRME(null, sender, token);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendToRME(EngineException e, String senderParam, Token token) throws Throwable {
        String sender = senderParam;
        Token msgToken = token;
        EsbMessageExchange mex = (EsbMessageExchange)msgToken.getData();
        if (mex.isExchangeImmediate() && e instanceof ItineraryException) {
            mex.setImmediateThrowable(e);
            if (mex.getRMEMessage() == null) {
                RMEMessage rmeMessage = new RMEMessage(((ItineraryException)mex.getImmediateThrowable()).getCause(), mex.getRMEAddress(), mex.getMessageFactory(), mex.getInputMessage(), mex.getXQParameters(), "XQ_SERVICE_EXCEPTION");
                mex.setRMEMessage(rmeMessage);
            }
            EsbNode fromNode = null;
            fromNode = ((ItineraryException)e).getCurrentNode();
            if (!this.handleFaultsImmediate(fromNode, token)) {
                if (e instanceof ItineraryException) {
                    throw ((ItineraryException)e).getCause();
                }
                throw e;
            }
            return;
        }
        String errorCode = "XQ_SERVICE_EXCEPTION";
        if (e != null) {
            Token token2 = msgToken = e.getToken() != null ? e.getToken() : token;
            if (e instanceof InvalidItineraryMessageException) {
                errorCode = "XQ_ITINERARY_EXCEPTION";
            }
            if (e instanceof CannotDetermineRME) {
                XQAddress globalRME = XQAddressFactoryImpl.getGlobalRME();
                if (globalRME == null) {
                    s_log.logError("Invalid itinerary information in the message due to exception: `" + e.toString() + "`. The RME destination cannot be determined and no global RME is configured. This message will be ignored without any further processing. ");
                } else {
                    String errorMsg = "Invalid itinerary information in the message due to exception: `" + e.toString() + "`. Since the RME destination cannot be determined for this process, the RME message is being sent to the global RME desination " + globalRME;
                    s_log.logInformation(errorMsg);
                    RejectedMessageDispatcher.sendMessageToGlobalRME(e, mex.getInputMessage(), globalRME, "MESSAGE_RECEIPT_FAILURE", "XQ_MAXREDELIVERY_EXCEEDED", errorMsg, null, mex.getQOS(), mex.getEndpointRegistry(), null, "");
                }
                return;
            }
            XQMessage rmeMessage = this.m_rejectedMessageDispatcher.createRMEMessage(e, mex.getInputMessage(), mex.getRMEAddress(), errorCode, mex.getXQParameters(), mex.getEndpointContext(), mex.getMessageFactory(), sender);
            mex.setInputMessage(rmeMessage);
        }
        RMEMessage rmeMsg = null;
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst != null && procInst instanceof FaultProcessInstance) {
            rmeMsg = ((FaultProcessInstance)procInst).getOriginalRMEMsg();
        } else {
            rmeMsg = mex.getRMEMessage();
            mex.setRMEMessage(null);
        }
        if (rmeMsg != null) {
            try {
                rmeMsg.setMessage(mex.getInputMessage());
                mex.setInputMessage(rmeMsg.getMessage(true));
            }
            catch (Throwable e1) {
                s_log.logDebug(e1);
            }
        }
        if (!mex.isExchangeImmediate()) {
            EsbMessageExchange newMex = EsbMessageExchange.createImmediate(mex.getSessionName(), mex.getDestinationAddress(), mex.getMessageFactory(), mex.getInputMessage(), mex.getXQParameters(), mex.getQOS(), mex.getCommitFlag(), mex.getEndpointRegistry());
            newMex.setRMEAddress(mex.getRMEAddress());
            newMex.setEnvelopeFactory(mex.getEnvelopeFactory());
            newMex.setXQDispatcher(mex.getXQDispatcher());
            mex = newMex;
        }
        sender = sender == null && msgToken.getProcessInstance() != null ? msgToken.getProcessInstance().getProcessDefinition().getDisplayName() : (e != null && e.getProcessName() != null ? e.getProcessName() : "[Cannot determine process name]");
        RejectedMessageDispatcher rejectedMessageDispatcher = this.getRMEDispatcher(mex);
        if (e != null) {
            rejectedMessageDispatcher.logRMEMessageErrorDebugInfo(sender, errorCode, e);
        }
        rejectedMessageDispatcher.sendRMEMessage(sender, mex);
        this.m_processChangeManager.errorOccurred(token, "SERVICE_ERROR");
    }

    private boolean handleFaultsImmediate(ActivityNode fromNode, Token token) {
        try {
            token.tagType(Token.Type.RME);
            return this.handleFaults(fromNode, token);
        }
        catch (ItineraryException e) {
            EsbNode currentPosition = e.getCurrentNode();
            return this.handleFaultsImmediate(currentPosition, token);
        }
    }

    public RejectedMessageDispatcher getRMEDispatcher(EsbMessageExchange mex) {
        RejectedMessageDispatcher rejectedMessageDispatcher = null;
        XQDispatcher dispatcher = mex.getXQDispatcher();
        if (dispatcher != null) {
            rejectedMessageDispatcher = dispatcher.getRMEDispatcher();
        }
        return rejectedMessageDispatcher == null ? this.m_rejectedMessageDispatcher : rejectedMessageDispatcher;
    }

    public static boolean isReservedServiceName(String svcName) {
        return s_reservedServices.contains(svcName);
    }

    public static boolean useIntraContainerDispatch(XQAddress address) {
        if (address.getType() == 1) {
            String svcName = address.getName();
            return XQContainer.useIntraContainer() && XQRegistry.instance().lookupService(svcName) != null || ItineraryEngine.isReservedServiceName(svcName) || XQContainer.isInternalContainerComponent(svcName);
        }
        return true;
    }

    @Override
    public void setProcessChangeEventManager(com.sonicsw.esb.process.engine.ProcessChangeEventManager manager) {
        this.m_processChangeManager = manager;
    }

    @Override
    public void setProcessDefParserFactory(ProcessDefParserFactory factory) {
        this.m_parserFactory = factory;
    }

    @Override
    public void setProcessDefSerializerFactory(ProcessDefSerializerFactory factory) {
        this.m_procDefSerializerFactory = factory;
    }

    @Override
    public void setProcessInstanceGeneratorFactory(ProcessInstanceGeneratorFactory factory) {
        this.m_instGeneratorFactory = factory;
        this.m_instGenerator = factory.createProcessInstanceGenerator();
    }

    @Override
    public void setProcessInstanceSerializerFactory(ProcessInstanceSerializerFactory factory) {
        this.m_instSerializerFactory = factory;
    }

    public static void setRmeOrFaultFromFH(FaultProcessInstance fhProcInst, XQProcessInstance origProcInst, Token token) {
        XQAddress faultAddress;
        if (fhProcInst.getOriginalRMEMsg() != null) {
            ((EsbMessageExchange)token.getData()).setRMEMessage(fhProcInst.getOriginalRMEMsg());
        } else if (token.isTokenOfType(Token.Type.FAULT, false) && (faultAddress = origProcInst.getProcessInstanceProperties().getUserDefinedFaultAddress()) != null) {
            ((EsbMessageExchange)token.getData()).setDestinationAddress(faultAddress);
        }
    }

    @Override
    public ProcessEngineActionManager getProcessEngineActionManager() {
        return this.m_actionMgr;
    }

    @Override
    public void setProcessEngineActionManager(ProcessEngineActionManager actMgr) {
        this.m_actionMgr = actMgr;
    }
}

