/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FaultNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultActivityNode;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;

public final class RethrowNode
extends EsbStepNode
implements FlowTerminationNode {
    public RethrowNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.setEndpointRef((XQAddress)new XQAbstractAddressImpl("InternalStep.Rethrow", 1, stepName));
    }

    @Override
    public Token execute(Token token) {
        RMEMessage rmeMsg;
        boolean result;
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (!(procInst instanceof FaultProcessInstance)) {
            throw new ItineraryException("Rethrow step " + this.m_id + " is being used in a non-FaultHandler process", token);
        }
        FaultProcessInstance faultProcInst = (FaultProcessInstance)procInst;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (XQContainer.isTestContainer() && !mex.isExchangeImmediate() && (result = RunDebugUtil.execute(mex, token, this))) {
            XQMessageInternal msgInternal = (XQMessageInternal)((EsbMessageExchange)token.getData()).getInputMessage();
            return (Token)msgInternal.getSidebandProperty("TOKEN");
        }
        if (this.m_messageMapper != null) {
            mex.getXQParameters().setParent(this.m_stepParams);
            DefaultMessageMapper.mapInputMessage(this.m_messageMapper, mex);
        }
        if ((rmeMsg = faultProcInst.getOriginalRMEMsg()) != null) {
            token.tagType(Token.Type.RME);
            this.overrideRMEAttributes(mex, rmeMsg);
        } else {
            RethrowNode.tagAsFault(token, faultProcInst, mex, this);
            FaultNode.setFaultHeaders(mex.getInputMessage(), this.m_stepParams, this);
        }
        return token;
    }

    static void tagAsFault(Token token, FaultProcessInstance procInst, EsbMessageExchange mex, ActivityNode node) {
        token.tagType(Token.Type.FAULT);
        ProcessInstanceProps origProps = procInst.getOriginalProcessInstanceProps();
        XQAddress faultAddress = null;
        if (origProps != null && (faultAddress = origProps.getUserDefinedFaultAddress()) == null) {
            faultAddress = origProps.getFaultAddress();
        }
        if (faultAddress == null) {
            throw new ItineraryException("The original process context properties not found in Rethrow step " + node.getDisplayName(), token);
        }
        mex.setDestinationAddress(faultAddress);
    }

    @Override
    public void offerOutgoing(Token token) {
        this.deactivate(token);
        RethrowNode.rethrow(token);
    }

    private void overrideRMEAttributes(EsbMessageExchange mex, RMEMessage rmeMsg) {
        String errorCode = FaultNode.calculateErrorParam(mex.getInputMessage(), this.m_stepParams, "errorCode", null);
        String errorMsg = FaultNode.calculateErrorParam(mex.getInputMessage(), this.m_stepParams, "errorMessage", null);
        if (errorCode != null) {
            rmeMsg.setRejectedCode(errorCode);
        }
        if (errorMsg != null) {
            rmeMsg.setRejectedDetails(errorMsg);
        }
    }

    public static void rethrow(Token token) {
        FaultProcessInstance procInst = (FaultProcessInstance)token.getProcessInstance();
        RMEMessage rmeMsg = ((EsbMessageExchange)token.getData()).getRMEMessage();
        if (rmeMsg != null) {
            procInst.setOriginalRMEMsg(rmeMsg);
        }
        XQProcessInstance origProcInst = procInst.getOriginalProcessInstance();
        ProcessInstanceProps origProcInstProps = procInst.getOriginalProcessInstanceProps();
        boolean isFHTargetProcess = origProcInstProps.isFaultHandlerTargetProcessNode();
        origProcInstProps.setInflightProperties(procInst.getProcessInstanceProperties().getInflightProps());
        procInst.changeProcessState(token, ProcessState.CLOSED);
        token.setProcessInstance(origProcInst);
        token.setProperty("IsRethrown", "true");
        ItineraryEngine.setRmeOrFaultFromFH(procInst, origProcInst, token);
        if (isFHTargetProcess) {
            ESBProcess process = (ESBProcess)origProcInst.getProcessDefinition();
            process.handleOutOfBandToken(token);
        } else {
            ActivityNode activeNode = origProcInst.getActiveEsbNode(token);
            ((DefaultActivityNode)activeNode).handleOutOfBandToken(token);
        }
    }
}

