/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.scriptengine.impl;

import com.sonicsw.esb.run.ExporterFactory;
import com.sonicsw.esb.run.handlers.scriptengine.IVariableValueReference;
import com.sonicsw.esb.run.handlers.scriptengine.impl.IExportable;
import com.sonicsw.esb.run.handlers.scriptengine.impl.IRemoteVariableValue;
import com.sonicsw.xqimpl.script.IVariableValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import net.jini.export.Exporter;

public class VariableValueReferenceImpl
implements IExportable,
IVariableValueReference,
Serializable {
    private static final long serialVersionUID = 256802125008660643L;
    private transient IVariableValue m_variableValue;
    private transient IRemoteVariableValue m_unexportedRemoteVariableValue;
    private IRemoteVariableValue m_remoteVariableValue;
    private String m_displayType;
    private String m_variableName;
    private boolean m_isByteArray;
    private boolean m_isXML;
    private transient Exporter m_exporter;
    private transient ExporterFactory m_factory;

    public VariableValueReferenceImpl(IVariableValue variableValue, ExporterFactory factory) throws ExportException, ScriptEngineException {
        this.m_variableValue = variableValue;
        this.m_factory = factory;
        this.m_displayType = variableValue.getDisplayType();
        this.m_variableName = variableValue.getVariableName();
        this.m_isByteArray = variableValue.isByteArray();
        this.m_isXML = variableValue.isXML();
    }

    @Override
    public void export() throws ExportException {
        this.m_exporter = this.m_factory.createExporter();
        this.m_unexportedRemoteVariableValue = new RemoteVariableValueWrapper(this.m_variableValue);
        this.m_remoteVariableValue = (IRemoteVariableValue)this.m_exporter.export((Remote)this.m_unexportedRemoteVariableValue);
    }

    @Override
    public void unexport() {
        this.m_exporter.unexport(false);
    }

    @Override
    public byte[] getAsByteArray() throws RemoteException {
        try {
            return this.m_remoteVariableValue.getAsByteArray();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getAsString() throws RemoteException {
        try {
            return this.m_remoteVariableValue.getAsString();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getAsStringIncludeXMLHeader() throws RemoteException {
        try {
            return this.m_remoteVariableValue.getAsStringIncludeXMLHeader();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getDisplayType() {
        return this.m_displayType;
    }

    @Override
    public String getVariableName() {
        return this.m_variableName;
    }

    @Override
    public boolean isByteArray() {
        return this.m_isByteArray;
    }

    @Override
    public boolean isXML() {
        return this.m_isXML;
    }

    class RemoteVariableValueWrapper
    implements IRemoteVariableValue {
        private IVariableValue m_value;

        RemoteVariableValueWrapper(IVariableValue value) {
            this.m_value = value;
        }

        @Override
        public byte[] getAsByteArray() throws RemoteException {
            try {
                return this.m_value.getAsByteArray();
            }
            catch (ScriptEngineException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }

        @Override
        public String getAsString() throws RemoteException {
            try {
                return this.m_value.getAsString();
            }
            catch (ScriptEngineException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }

        @Override
        public String getAsStringIncludeXMLHeader() throws RemoteException {
            try {
                return this.m_value.getAsStringIncludeXMLHeader();
            }
            catch (ScriptEngineException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }
    }
}

