/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQItineraryConfig;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class XQProcessAddressImpl
extends XQAddressImpl
implements XQProcessAddress {
    private static final long serialVersionUID = 8755180815791428763L;
    public XQItineraryConfig m_stepItinerary;
    public XQProcessConfig m_process;
    public XQTrackingDetailsConfig m_trackingDetails;
    public Set<XQAddress> m_exitEndpoints;
    private Properties m_inflightProps;
    private boolean m_isSingleUseAddress = false;
    private boolean m_continueAsDynamicProcess = false;

    public XQProcessAddressImpl(String name, XQProcessConfig process) {
        super(name, 2, (XQConfiguration)process);
        if (process != null) {
            this.m_process = (XQProcessConfig)((XQProcessConfig)this.m_config).clone();
            this.m_trackingDetails = this.m_process.getTrackingDetails();
            this.m_exitEndpoints = this.m_process.getExitEndpoints();
        } else {
            XQConfigManager mgr = XQConfigManager.getInstance(null);
            this.m_process = new XQProcessConfig(mgr);
            this.m_config = this.m_process;
            this.m_trackingDetails = new XQTrackingDetailsConfig();
            this.m_exitEndpoints = new HashSet<XQAddress>();
        }
    }

    public XQProcessAddressImpl(String name, String step, XQProcessConfig process) throws XQAddressNotFoundException {
        this(name, process);
        this.setStepNameHelper(step);
    }

    private void setStepNameHelper(String step) throws XQAddressNotFoundException {
        this.setStepName(step);
    }

    protected XQProcessAddressImpl(String name) {
        super(name, 2, null);
        XQConfigManager mgr = XQConfigManager.getInstance(null);
        this.m_process = new XQProcessConfig(mgr);
        this.m_config = this.m_process;
    }

    public void setSingleUseAddress(boolean singleUse) {
        this.m_isSingleUseAddress = singleUse;
    }

    public XQProcessConfig getWritableProcessConfig() {
        if (this.m_isSingleUseAddress) {
            return this.m_process;
        }
        return (XQProcessConfig)this.m_process.clone();
    }

    public void setStepName(String stepName) throws XQAddressNotFoundException {
        try {
            this.checkAndSetStepValue(stepName);
        }
        catch (IllegalArgumentException e) {
            throw new XQAddressNotFoundException(e.getMessage(), (Exception)e);
        }
    }

    private void checkAndSetStepValue(String step) {
        if (step != null) {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("XQAddress: illegal address - only process address can include a step");
            }
            StringTokenizer tokenizer = new StringTokenizer(step, ":", true);
            boolean expectStep = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (":".equals(token)) {
                    this.checkIllegalAddress(expectStep, step);
                    expectStep = true;
                    continue;
                }
                if (XQProcessAddressImpl.isLegalStepName((String)token)) {
                    expectStep = false;
                    continue;
                }
                throw new IllegalArgumentException("XQAddress: illegal address - step component is reserved name: '" + step + "'");
            }
            this.checkIllegalAddress(expectStep, step);
        }
        this.setStepNameInternal(step);
    }

    private void checkIllegalAddress(boolean expectStep, String step) {
        if (expectStep) {
            throw new IllegalArgumentException("XQAddress: illegal address - step component is empty: '" + step + "'");
        }
    }

    public void setQualityOfService(XQQualityofService qos) {
    }

    public XQQualityofService getQualityofService() {
        return null;
    }

    public String getTrackingID() {
        return this.m_trackingDetails == null ? null : this.m_trackingDetails.getTrackingId();
    }

    public void setTrackingID(String trackingID) {
        this.initTrackingIfNecessary();
        this.m_trackingDetails.setTrackingId(trackingID);
    }

    protected void setTrackingDetails(XQTrackingDetailsConfig config) {
        this.m_trackingDetails = config;
        this.m_process.setTrackingDetails(this.m_trackingDetails);
    }

    public Iterator<XQAddress> getExitEndpoints() {
        if (this.m_exitEndpoints == null) {
            return null;
        }
        return this.m_exitEndpoints.iterator();
    }

    public void addExitEndpoint(XQAddress address) {
        this.initExitsIfNecessary();
        this.m_exitEndpoints.add(address);
    }

    public void removeExitEndpoint(XQAddress address) {
        this.initExitsIfNecessary();
        this.m_exitEndpoints.remove(address);
    }

    public void removeAllExitEndpoints() {
        this.initExitsIfNecessary();
        this.m_exitEndpoints.clear();
    }

    public long getTTL() {
        return this.m_process.getTimeToLive();
    }

    public void setTTL(long ttl) {
        this.m_process.setTimeToLive(ttl);
    }

    public int getTrackingLevel() {
        return this.m_trackingDetails == null ? 0 : this.m_trackingDetails.getTrackingLevel();
    }

    public void setTrackingLevel(int trackingLevel) {
        this.initTrackingIfNecessary();
        this.m_trackingDetails.setTrackingLevel(trackingLevel);
    }

    public XQAddress getEventAddress() {
        return this.m_trackingDetails == null ? null : this.m_trackingDetails.getEventEndpoint();
    }

    public void setEventAddress(XQAddress eventEndpoint) {
        this.initTrackingIfNecessary();
        this.m_trackingDetails.setEventEndpoint(eventEndpoint);
    }

    public XQAddress getRMEAddress() {
        return this.m_process.getRejectedMessageEndpoint();
    }

    public void setRMEAddress(XQAddress rejectedMessageEndpoint) {
        this.m_process.setRejectedMessageEndpoint(rejectedMessageEndpoint);
    }

    public XQAddress getFaultAddress() {
        return this.m_process.getFaultEndpoint();
    }

    public void setFaultAddress(XQAddress faultEndpoint) {
        this.m_process.setFaultEndpoint(faultEndpoint);
    }

    public void setInflightProperties(Properties params) {
        this.m_inflightProps = params;
    }

    public Properties getInflightProperties() {
        return this.m_inflightProps;
    }

    public XQProcessConfig getProcess() {
        return this.m_process;
    }

    public static boolean isStepAddress(XQAddress address) {
        if (!(address instanceof XQProcessAddress)) {
            return false;
        }
        String step = ((XQProcessAddress)address).getStepName();
        return step != null && step.trim().length() != 0;
    }

    private void initExitsIfNecessary() {
        if (this.m_exitEndpoints != null) {
            return;
        }
        this.m_exitEndpoints = new HashSet<XQAddress>();
        this.m_process.setExitEndpoints(this.m_exitEndpoints);
    }

    private void initTrackingIfNecessary() {
        if (this.m_trackingDetails != null) {
            return;
        }
        this.m_trackingDetails = new XQTrackingDetailsConfig();
        this.m_process.setTrackingDetails(this.m_trackingDetails);
    }

    public static XQProcessAddress getProcessAddress(XQAddress address) throws XQAddressNotFoundException {
        if (address.getType() != 2) {
            throw new IllegalArgumentException("Not a process address");
        }
        if (address instanceof XQProcessAddress) {
            return (XQProcessAddress)address;
        }
        XQAddressFactoryImpl addressFactory = new XQAddressFactoryImpl(null, -1);
        XQProcessAddress processAddress = addressFactory.createSingleUseProcessAddress(address.getName());
        return processAddress;
    }

    public void overrideFromProcessContext(XQProcessContext pctx) {
        if (pctx != null) {
            XQAddress rejectAddress;
            XQAddress faultAddress = pctx.getFaultAddress();
            if (faultAddress == null || faultAddress.getType() != 3) {
                this.setFaultAddress(faultAddress);
            }
            if ((rejectAddress = pctx.getRMEAddress()) == null || rejectAddress.getType() != 3) {
                this.setRMEAddress(rejectAddress);
            }
            this.setQualityOfService(pctx.getQualityofService());
            this.setTTL(pctx.getTTL());
        }
    }

    public void continueAsDynamicProcess(boolean enableDynamic) {
        this.m_continueAsDynamicProcess = enableDynamic;
    }

    public boolean isContinueAsDynamicProcess() {
        return this.m_continueAsDynamicProcess;
    }
}

