/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.Expression;
import modelobjects.template.StartForeachFragment;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.TemplateProcessor;

class StartForeachTagParser
extends TagParser {
    protected static final String tagStart = "<FOREACH";
    protected static final int tagStartLength = "<FOREACH".length();
    private transient String varName;
    private transient String varType;
    private transient String exprString;
    private transient Expression expression;

    StartForeachTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        int sourceLen;
        char[] source = parser.getTemplateSource();
        if (!this.tagNameMatches(source, startPos, sourceLen = source.length, "FOREACH", "foreach")) {
            return null;
        }
        int endPos = StartForeachTagParser.tagEndPos(startPos + tagStartLength, source, source.length);
        this.collectTagInfo(parser, source, startPos, endPos);
        return new StartForeachFragment(startPos, endPos, this.varName, this.varType, this.exprString, this.expression);
    }

    private void collectTagInfo(TemplateParser parser, char[] source, int startPos, int endPos) {
        this.varName = null;
        this.varType = null;
        this.exprString = null;
        this.expression = null;
        String attributesString = new String(source, startPos + tagStartLength, endPos - startPos - tagStartLength);
        TagParser.TagAttribute[] attributes = this.collectAttributes(attributesString, source, startPos);
        int n = attributes.length;
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i].getAttrName();
            String attrValue = attributes[i].getAttrValue();
            if ("type".equalsIgnoreCase(attrName)) {
                this.varType = attrValue;
                continue;
            }
            if (!"".equals(attrName)) {
                this.varName = attrName;
                this.exprString = attrValue.equals(parser.getTopLevelId()) ? TemplateProcessor.TOP_LEVEL_OBJ_ID : attrValue;
                continue;
            }
            System.err.println("Unrecognized <FOREACH> tag attibute: " + attrName + " on line " + TemplateParser.lineNumber(source, startPos));
        }
        if (this.exprString == null) {
            System.err.println("No element variable defined in <FOREACH> tag at " + TemplateParser.lineNumber(source, startPos));
            this.varName = "<no-name>";
            this.exprString = "\"???\"";
        } else {
            try {
                this.expression = parser.getExpressionParser().parse(this.exprString);
            }
            catch (Exception e) {
                System.err.println("Syntax error in <FOREACH> expression: '" + this.exprString + "' on line " + TemplateParser.lineNumber(source, startPos));
            }
        }
        if (this.expression == null) {
            this.expression = parser.getExpressionParser().parse("\"???\"");
        }
    }
}

