/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class RestrictedConnection
implements Connection {
    public static final String OPERATION_NOT_ALLOWED = "Operation not allowed";
    private Connection m_delegate = null;

    public RestrictedConnection(Connection delegate) {
        this.m_delegate = delegate;
    }

    public void close() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException(OPERATION_NOT_ALLOWED);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException(OPERATION_NOT_ALLOWED);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.m_delegate.createSession(transacted, acknowledgeMode);
    }

    public Session createSession(int sessionMode) throws JMSException {
        throw new UnsupportedOperationException(OPERATION_NOT_ALLOWED);
    }

    public Session createSession() throws JMSException {
        throw new UnsupportedOperationException(OPERATION_NOT_ALLOWED);
    }

    public String getClientID() throws JMSException {
        return this.m_delegate.getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.m_delegate.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.m_delegate.getMetaData();
    }

    public void setClientID(String clientID) throws JMSException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (listener == null) {
            return;
        }
        RestrictedConnection restrictedConnection = this;
        synchronized (restrictedConnection) {
            ExceptionListener existing = this.m_delegate.getExceptionListener();
            if (existing != null) {
                if (existing instanceof ChainedExceptionListener) {
                    ChainedExceptionListener chain = (ChainedExceptionListener)existing;
                    chain.add(listener);
                } else {
                    ChainedExceptionListener chain = new ChainedExceptionListener(existing);
                    chain.add(existing);
                    chain.add(listener);
                    this.m_delegate.setExceptionListener((ExceptionListener)chain);
                }
            } else {
                ChainedExceptionListener chain = new ChainedExceptionListener(null);
                chain.add(listener);
                this.m_delegate.setExceptionListener((ExceptionListener)chain);
            }
        }
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
        throw new UnsupportedOperationException();
    }

    static class ChainedExceptionListener
    implements ExceptionListener {
        protected List<ExceptionListener> m_l = Collections.synchronizedList(new ArrayList(2));
        protected ExceptionListener m_systemListener = null;

        ChainedExceptionListener(ExceptionListener systemListener) {
            this.m_systemListener = systemListener;
        }

        public void add(ExceptionListener el) {
            this.m_l.remove(el);
            this.m_l.add(el);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException arg0) {
            List<ExceptionListener> list = this.m_l;
            synchronized (list) {
                for (ExceptionListener el : this.m_l) {
                    if (el == this.m_systemListener) {
                        el.onException(arg0);
                        continue;
                    }
                    try {
                        el.onException(arg0);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

