/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.soapunwrap;

import com.sonicsw.xq.XQDisableLookingGlass;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.invkimpl.WSESBInvkException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.HRefUtils;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.SoapBodyFactory;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.RawSoapWSInvocationException;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.wsdl.TypeHelper;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.soapunwrap.OperationDetails;
import com.sonicsw.xqimpl.service.soapunwrap.WSDLContext;
import com.sonicsw.xqimpl.service.wsinvk.WSExecutionFaultException;
import com.sonicsw.xqimpl.service.wsinvk.WSFaultPrescriptionApplicator;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.wsif.util.WSIFUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SOAPUnwrapService
implements XQService,
XQDisableLookingGlass {
    private static XQLog m_xqLog = XQLogImpl.getCategoryLog((int)32);
    private static HashMap<String, Definition> s_wsdlCache = new HashMap();
    private static HashMap<String, TypeHelper> s_typesCache = new HashMap();

    public void init(XQInitContext initialContext) throws XQServiceException {
    }

    public void service(XQServiceContext ctx) throws XQServiceException {
        if (ctx == null) {
            throw new XQServiceException("Service Context cannot be null.");
        }
        XQParameters params = ctx.getParameters();
        XQProcessContext pctx = ctx.getProcessContext();
        WSDLContext wsdl = null;
        TypeHelper types = null;
        String wurl = null;
        XQConfigManager configManager = XQConfigManager.getInstance(null);
        try {
            String sName;
            XQServiceConfig scfg;
            if (pctx != null) {
                XQProcessConfig pcfg = configManager.lookupProcessConfig(pctx.getName());
                wurl = pcfg.getWSDLUrl();
            }
            if (wurl == null && (wurl = (scfg = configManager.lookupServiceConfig(sName = params.getParameter("SonicXQ.ServiceName", 1))).getWSDLUrl()) == null) {
                throw new XQServiceException("SOAPUnwrapService requires a wsdl");
            }
            wsdl = this.determineWSDL(wurl);
            types = this.getTypeHelper(wurl, wsdl.getDefinition());
        }
        catch (Exception ge) {
            throw new XQServiceException((Throwable)ge);
        }
        XQEnvelope env = null;
        OperationDetails op = null;
        while (ctx.hasNextIncoming()) {
            env = ctx.getNextIncoming();
            XQMessage message = env.getMessage();
            Iterator addressList = env.getAddresses();
            if (!addressList.hasNext()) continue;
            try {
                if (this.isSOAPMessage(message)) {
                    Object contentObj = message.getPart(0).getContent();
                    String content = null;
                    content = contentObj instanceof byte[] ? Util.createStringFromByteArray((byte[])contentObj, null) : (String)contentObj;
                    SOAPEnvelope requestEnvelope = SoapBodyFactory.createSOAPEnvelope(content);
                    AddressingHeaders ah = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)requestEnvelope);
                    op = this.resolveOperation(message, ah, wsdl);
                    if (op == null) {
                        throw new Exception("Cannot identify the WSDL operation.");
                    }
                    this.soapUnwrap(params, op, message, requestEnvelope, ah, types);
                }
                ctx.addOutgoing(env);
            }
            catch (Exception e) {
                try {
                    GeneralWSInvocationException gie = new GeneralWSInvocationException(e.getMessage(), null, e);
                    RawSoapWSInvocationException rsie = new RawSoapWSInvocationException(gie);
                    boolean faultAsSOAP = params.getBooleanParameter("com_sonicsw_xqimpl_service_soapunwrap_SOAPUnwrapConstants_FAULT_AS_SOAP", 1);
                    int faultMode = params.getIntParameter("com_sonicsw_xqimpl_service_soapunwrap_SOAPUnwrapConstants_FAULT_MSG_MODE", 1);
                    if (faultAsSOAP) {
                        WSExecutionFaultException wsfeSOAP = new WSExecutionFaultException(new WSESBInvkException(rsie), faultMode);
                        WSFaultPrescriptionApplicator.applyFaultHandlingPrescription(ctx, message, wsfeSOAP, "SOAPUnwrap");
                        continue;
                    }
                    WSExecutionFaultException wsfe = new WSExecutionFaultException(new WSESBInvkException(gie), faultMode);
                    WSFaultPrescriptionApplicator.applyFaultHandlingPrescription(ctx, message, wsfe, "SOAPUnwrap");
                }
                catch (Exception e2) {
                    throw new XQServiceException((Throwable)e);
                }
            }
        }
    }

    private OperationDetails resolveOperation(XQMessage message, AddressingHeaders ah, WSDLContext wsdl) throws XQMessageException {
        OperationDetails operation = null;
        String soapActionURI = message.getStringHeader("SOAPAction");
        String wsaActionURI = this.getWSAAction(ah);
        operation = wsdl.resolveOperation(wsaActionURI, soapActionURI, null);
        return operation;
    }

    private String getWSAAction(AddressingHeaders ah) {
        String wsaActionURI = null;
        Action action = ah.getAction();
        if (action != null) {
            wsaActionURI = action.toString();
        }
        return wsaActionURI;
    }

    private XQMessage soapUnwrap(XQParameters parms, OperationDetails op, XQMessage msg, SOAPEnvelope requestEnvelope, AddressingHeaders ah, TypeHelper types) throws Exception {
        boolean consumeSOAP = parms.getBooleanParameter("com_sonicsw_xqimpl_service_soapunwrap_SOAPUnwrapConstants_CONSUME_SOAP", 1);
        SOAPEnvelope responseEnvelope = HRefUtils.flattenResponse(requestEnvelope);
        boolean isRPC = op.getSOAPOperation().getStyle().equalsIgnoreCase("rpc");
        if (isRPC) {
            this.setRPCParts(responseEnvelope, msg, op, consumeSOAP, types);
        } else {
            this.setDOCLitPart(responseEnvelope, msg, op, consumeSOAP);
        }
        String opName = op.getOperation().getName();
        String ptLocalName = op.getBinding().getPortType().getQName().getLocalPart();
        msg.setStringHeader("X-WS-Operation", opName);
        msg.setStringHeader("X-WS-PortType", ptLocalName);
        String wsaAction = this.getWSAAction(ah);
        if (wsaAction != null) {
            String actionProp = new QName(AddressingUtils.getDefaultNS(), "Action").toString();
            msg.setStringHeader(actionProp, wsaAction);
        }
        return msg;
    }

    private boolean isSOAPMessage(XQMessage message) {
        try {
            XQPart part;
            if (message.getPartCount() > 0 && (part = message.getPart(0)).getContentType() != null) {
                return message.getHeaderValue("SOAPAction") != null;
            }
        }
        catch (XQMessageException excp) {
            return false;
        }
        return false;
    }

    private WSDLContext determineWSDL(String wsdl) throws Exception {
        Definition wdef = this.getWSDLWithClassLoader(wsdl);
        return new WSDLContext(wdef);
    }

    public void destroy() {
    }

    private void setDOCLitPart(SOAPEnvelope env, XQMessage msg, OperationDetails fop, boolean consumeSOAP) throws Exception {
        Vector v = env.getBodyElements();
        Map parts = fop.getOperation().getInput().getMessage().getParts();
        if (v.size() != 1) {
            String e = "Output Doc/Literal SOAP Body has " + v.size() + " parts.";
            m_xqLog.logInformation(e);
            throw new Exception(e);
        }
        if (parts.size() != 1) {
            String e = "Output Doc/Literal Definition has " + parts.size() + " parts.";
            m_xqLog.logInformation(e);
            throw new Exception(e);
        }
        Object body = v.elementAt(0);
        Part part = (Part)parts.values().iterator().next();
        if (body instanceof SOAPBodyElement) {
            SOAPBodyElement respEl = (SOAPBodyElement)body;
            String partName = part.getName();
            XQPart newPart = msg.createPart();
            newPart.setContent((Object)respEl.getAsString(), "text/xml");
            newPart.setContentId(partName);
            if (consumeSOAP) {
                msg.removeAllParts();
            }
            msg.addPart(newPart);
        }
    }

    private void setRPCParts(SOAPEnvelope env, XQMessage msg, OperationDetails fop, boolean consumeSOAP, TypeHelper types) throws Exception {
        Vector v = env.getBodyElements();
        Vector<XQPart> outputs = new Vector<XQPart>();
        List parts = fop.getOperation().getInput().getMessage().getOrderedParts(null);
        if (v.size() != 1) {
            String e = "RPC SOAP Body has " + v.size() + " top-level elements(expect 1).";
            m_xqLog.logInformation(e);
            throw new Exception(e);
        }
        Object body = v.elementAt(0);
        SOAPBodyElement respElem = (SOAPBodyElement)body;
        Node value = null;
        SOAPBodyElement topLevel = respElem;
        NodeList children = topLevel.getChildNodes();
        for (Part p : parts) {
            for (int z = 0; z < children.getLength(); ++z) {
                Node child = children.item(z);
                String elementName = child.getLocalName();
                if (elementName == null) {
                    elementName = child.getNodeName();
                }
                if (!elementName.equals(p.getName())) continue;
                value = p.getElementName() != null ? child.getFirstChild() : (types.isSimpleType(p.getTypeName()) ? child.getFirstChild() : child);
                String partName = p.getName();
                XQPart newPart = msg.createPart();
                if (value == null) {
                    newPart.setContent((Object)"", "text/plain");
                } else if (value.getNodeType() == 3) {
                    Text text = (Text)value;
                    newPart.setContent((Object)text.getData(), "text/plain");
                } else if (value.getNodeType() == 1) {
                    Element element = (Element)value;
                    newPart.setContent((Object)Util.getElementAsString(element, false), "text/xml");
                }
                newPart.setContentId(partName);
                outputs.add(newPart);
            }
        }
        if (consumeSOAP) {
            msg.removeAllParts();
        }
        for (int i = 0; i < outputs.size(); ++i) {
            msg.addPart((XQPart)outputs.elementAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getWSDLWithClassLoader(String URL2) throws WSDLException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (XQContainer.isCacheEnabled()) {
            Definition wsdl = null;
            HashMap<String, Definition> hashMap = s_wsdlCache;
            synchronized (hashMap) {
                wsdl = s_wsdlCache.get(URL2);
                if (wsdl == null) {
                    wsdl = WSIFUtils.readWSDL(null, (String)URL2, (ClassLoader)cl);
                    s_wsdlCache.put(URL2, wsdl);
                }
            }
            return wsdl;
        }
        return WSIFUtils.readWSDL(null, (String)URL2, (ClassLoader)cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeHelper getTypeHelper(String URL2, Definition def) throws Exception {
        TypeHelper typeHelper = null;
        if (XQContainer.isCacheEnabled()) {
            HashMap<String, TypeHelper> hashMap = s_typesCache;
            synchronized (hashMap) {
                typeHelper = s_typesCache.get(URL2);
                if (typeHelper == null) {
                    typeHelper = new TypeHelper(def);
                    typeHelper.initializeFromURL(URL2);
                    s_typesCache.put(URL2, typeHelper);
                }
            }
            return typeHelper;
        }
        typeHelper = new TypeHelper(def);
        typeHelper.initializeFromURL(URL2);
        return typeHelper;
    }
}

