/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms.spi;

import com.sonicsw.xq.connector.jms.JMSBreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSEndpointContainer;
import com.sonicsw.xq.connector.jms.NoResolvedUrlException;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.util.StringUtil;
import java.util.Map;
import javax.jms.JMSException;
import progress.message.jclient.ConnectionFactory;

public class SonicConnectionFactory {
    private static final String XQ_CONNECTID_PREFIX = "SonicESB/esb/";

    private SonicConnectionFactory() {
    }

    public static javax.jms.ConnectionFactory create(Map<String, Object> config, String connectionNameOverride, String connectionConfigName, IXQConfigManager configManager, boolean runOutsideContainer) throws XQConfigurationException, JMSException, NoResolvedUrlException {
        String jndi = (String)config.get("jndi");
        ConnectionFactory factory = null != jndi && !"".equals(jndi) ? SonicConnectionFactory.createFromJNDI(configManager, jndi) : SonicConnectionFactory.createFromESBConfiguration(configManager, config, connectionConfigName, runOutsideContainer);
        SonicConnectionFactory.updateConnectID(factory, config, connectionNameOverride);
        return factory;
    }

    private static ConnectionFactory createFromESBConfiguration(IXQConfigManager configManager, Map<String, Object> config, String connectionCfgName, boolean runOutsideContainer) throws JMSException, XQConfigurationException, NoResolvedUrlException {
        String urls = null;
        if (runOutsideContainer) {
            urls = (String)config.get("url");
        } else {
            urls = configManager.getResolvedConnectionURLs(connectionCfgName);
            if (urls == null || "".equals(urls)) {
                urls = (String)config.get("url");
            }
        }
        Boolean faultTolerant = (Boolean)config.get("faultTolerant");
        Boolean loadBalanced = (Boolean)config.get("loadBalanced");
        String loadBalancingClientData = (String)config.get("loadBalancingClientData");
        Integer initialConnectTimeout = (Integer)config.get("initialConnectTimeout");
        Integer faultTolerantReconnectTimeout = (Integer)config.get("faultTolerantReconnectTimeout");
        Integer monitorInterval = (Integer)config.get("monitorInterval");
        Long pingInterval = (Long)config.get("pingInterval");
        Integer socketConnectTimeout = (Integer)config.get("socketConnectTimeout");
        String loginSPIClassname = (String)config.get("loginSPIClass");
        Boolean enableCompression = (Boolean)config.get("enableCompression");
        String compressionFactory = (String)config.get("compressionFactory");
        Integer flowToDisk4con = (Integer)config.get("flowToDisk");
        ConnectionFactory cnxnFactory = new ConnectionFactory();
        cnxnFactory.setConnectionURLs(urls);
        cnxnFactory.setPingIntervalLong(pingInterval);
        JMSBreakPointHelper.addBreakPoint("pingInterval", "ping interval", cnxnFactory.getPingIntervalLong());
        cnxnFactory.setSelectorAtBroker(Boolean.TRUE);
        cnxnFactory.setMonitorInterval(monitorInterval);
        JMSBreakPointHelper.addBreakPoint("monitorInterval", "monitor interval", cnxnFactory.getMonitorInterval());
        if (faultTolerant.booleanValue()) {
            cnxnFactory.setFaultTolerant(faultTolerant);
            cnxnFactory.setInitialConnectTimeout(initialConnectTimeout);
            cnxnFactory.setFaultTolerantReconnectTimeout(faultTolerantReconnectTimeout);
        }
        JMSBreakPointHelper.addBreakPoint("enableFT", "Enable FT", cnxnFactory.getFaultTolerant());
        JMSBreakPointHelper.addBreakPoint("FTInitialConnectionTimeout", "FT Initial Connection Timeout", cnxnFactory.getInitialConnectTimeout());
        JMSBreakPointHelper.addBreakPoint("FTReconnectTimeout", "FT Reconnect Timeout", cnxnFactory.getFaultTolerantReconnectTimeout());
        cnxnFactory.setLoadBalancingBoolean(loadBalanced);
        JMSBreakPointHelper.addBreakPoint("loadBalance", "Load Balance", cnxnFactory.getLoadBalancingBoolean());
        if (loadBalancingClientData != null) {
            cnxnFactory.setLoadBalancingClientData(loadBalancingClientData);
        }
        if (flowToDisk4con != null) {
            cnxnFactory.setFlowToDisk(flowToDisk4con);
        }
        JMSBreakPointHelper.addBreakPoint("flowToDisk4con", SonicConnectionFactory.class.getName() + ".create", cnxnFactory.getFlowToDisk());
        if (loginSPIClassname != null) {
            cnxnFactory.setLoginSPI(loginSPIClassname);
        }
        if (Boolean.TRUE.equals(enableCompression)) {
            cnxnFactory.setEnableCompressionBoolean(enableCompression);
            if (null != compressionFactory) {
                cnxnFactory.setCompressionFactory(compressionFactory);
                JMSBreakPointHelper.addBreakPoint("compressionFactory", "Custom Compression Factory", cnxnFactory.getCompressionFactory());
            }
        }
        JMSBreakPointHelper.addBreakPoint("enableCompression", "enable compression", cnxnFactory.getEnableCompressionBoolean());
        cnxnFactory.setSocketConnectTimeout(socketConnectTimeout);
        JMSBreakPointHelper.addBreakPoint("socketConnectTimeout", "socket connect timeout", cnxnFactory.getSocketConnectTimeout());
        Long clientTransactionBufferSize = (Long)config.get("clientTransactionBufferSize");
        if (null != clientTransactionBufferSize) {
            cnxnFactory.setClientTransactionBufferSize(clientTransactionBufferSize);
        }
        JMSBreakPointHelper.addBreakPoint("clientTransactionBufferSize", "Client Transaction Buffer Size", cnxnFactory.getClientTransactionBufferSize());
        Integer defaultTxnBatchSizeInteger = (Integer)config.get("defaultTxnBatchSize");
        if (null != defaultTxnBatchSizeInteger) {
            cnxnFactory.setDefaultTxnBatchSizeInteger(defaultTxnBatchSizeInteger);
        }
        JMSBreakPointHelper.addBreakPoint("defaultTxnBatchSize", "Default Transaction Batch Size", cnxnFactory.getDefaultTxnBatchSize());
        cnxnFactory.setPrefetchCount(1);
        cnxnFactory.setPrefetchThreshold(0);
        return cnxnFactory;
    }

    private static ConnectionFactory createFromJNDI(IXQConfigManager configManager, String jndi) throws XQConfigurationException {
        Object jndiEntry = configManager.lookupJNDIEntry(jndi);
        if (!(jndiEntry instanceof ConnectionFactory)) {
            throw new IllegalArgumentException("JNDI entry " + jndi + " is not a progress.message.jclient.ConnectionFactory instance.");
        }
        ConnectionFactory cnxnFactory = (ConnectionFactory)jndiEntry;
        return cnxnFactory;
    }

    private static void updateConnectID(ConnectionFactory cnxnFactory, Map<String, Object> config, String connectionNameOverride) {
        String connectID = (String)config.get("connectionID");
        if (connectID == null || connectID.trim().length() == 0) {
            connectID = null;
            if (!JMSEndpointContainer.getDisableConnectIDs()) {
                String domainName = JMSEndpointContainer.getDomainName();
                String mfContainerName = JMSEndpointContainer.getMFContainerName();
                String mfFailoverIdentity = JMSEndpointContainer.getMFFailoverIdentity();
                String mfComponentName = JMSEndpointContainer.getMFComponentName();
                String xqConnectionName = connectionNameOverride == null ? (String)config.get("name") : connectionNameOverride;
                connectID = SonicConnectionFactory.retrieveConnectId(connectID, domainName, mfComponentName, mfContainerName, mfFailoverIdentity, xqConnectionName);
            }
        }
        if (connectID != null) {
            cnxnFactory.setConnectID(connectID);
        }
    }

    private static String retrieveConnectId(String connectIDParam, String domainName, String mfComponentName, String mfContainerNameParam, String mfFailoverIdentity, String xqConnectionName) {
        String mfContainerName = mfContainerNameParam;
        String connectID = connectIDParam;
        if (domainName != null && mfContainerName != null && mfComponentName != null) {
            if (null != mfFailoverIdentity) {
                mfContainerName = mfFailoverIdentity;
            }
            connectID = XQ_CONNECTID_PREFIX + domainName + "/" + mfContainerName + "/" + mfComponentName + "/" + xqConnectionName;
            connectID = SonicConnectionFactory.legitimateConnectID(connectID);
        }
        return connectID;
    }

    private static String legitimateConnectID(String s) {
        String result = s;
        if (s != null) {
            result = StringUtil.replaceAll((String)result, (String)".", (String)"__");
            result = StringUtil.replaceAll((String)result, (String)"#", (String)"::");
            result = StringUtil.replaceAll((String)result, (String)"$", (String)"!!");
            result = StringUtil.replaceAll((String)result, (String)"*", (String)"@@");
        }
        return result;
    }
}

