/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.container;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.container.ICorrelatedListener;
import com.sonicsw.xqimpl.container.ICorrelatedTimedListener;
import com.sonicsw.xqimpl.container.ICorrelationService;
import com.sonicsw.xqimpl.container.ICorrelationTimeoutMgmt;
import com.sonicsw.xqimpl.container.IRegistration;
import com.sonicsw.xqimpl.container.IRegistrationSPI;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Coordinator {
    private static Coordinator ref = new Coordinator();
    private ICorrelationService m_listener;
    private List m_EPRegistrations = new ArrayList();
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);

    private Coordinator() {
    }

    public static synchronized Coordinator getInstance() {
        return ref;
    }

    public synchronized void registerListener(ICorrelationService listener) throws XQEndpointCreationException {
        if (this.m_listener != null) {
            throw new IllegalArgumentException("Only one listener supported at this time");
        }
        this.m_listener = listener;
        for (IRegistrationSPI reg : this.m_EPRegistrations) {
            listener.registerEndpoint(reg);
        }
    }

    public void unRegisterListener(ICorrelationService listener) {
        if (!this.m_listener.equals(listener)) {
            throw new IllegalArgumentException("registering a listner which is not the current one.");
        }
        this.m_listener = null;
    }

    public synchronized IRegistration registerTmpDestination(XQEndpointConfig config) throws XQServiceException, XQEndpointCreationException {
        ICorrelationService.RegisteredEndpoint regEndpoint = new ICorrelationService.RegisteredEndpoint(config);
        return this.registerTmpDestination(regEndpoint);
    }

    public synchronized IRegistration registerTmpDestination(ICorrelationService.RegisteredEndpoint regEndpoint) throws XQEndpointCreationException {
        Registration reg = new Registration(regEndpoint);
        if (this.m_listener != null) {
            this.m_listener.registerEndpoint(reg);
        } else {
            this.m_EPRegistrations.add(reg);
        }
        return reg;
    }

    protected static class Registration
    implements IRegistrationSPI,
    ICorrelationTimeoutMgmt {
        private final ICorrelationService.RegisteredEndpoint regEndpoint;
        private Map listenerForCorrelation = Collections.synchronizedMap(new HashMap());
        protected static volatile Timer timeoutTimer = null;

        public Registration(ICorrelationService.RegisteredEndpoint regEndpoint) {
            this.regEndpoint = regEndpoint;
        }

        @Override
        public void registerMessageHandler(Object jmsCorrID, ICorrelatedListener listener) {
            if (this.listenerForCorrelation.containsKey(jmsCorrID)) {
                throw new IllegalArgumentException("Duplicate value for correation id:" + jmsCorrID);
            }
            ListenerInfo info = null;
            info = listener instanceof ICorrelatedTimedListener ? this.addTimedListener(this, jmsCorrID, (ICorrelatedTimedListener)listener) : new ListenerInfo(listener, null);
            this.listenerForCorrelation.put(jmsCorrID, info);
        }

        @Override
        public void unRegisterMessageHandler(Object jmsCorrID) {
            Object old = this.listenerForCorrelation.remove(jmsCorrID);
            if (old == null) {
                s_log.logWarning("No listener registered for id:" + jmsCorrID);
                return;
            }
            ListenerInfo info = (ListenerInfo)old;
            if (info.timeout != null) {
                info.timeout.cancel();
            }
        }

        @Override
        public ICorrelationService.RegisteredEndpoint getEndpoint() {
            return this.regEndpoint;
        }

        @Override
        public ICorrelatedListener getListenerForCorrId(Object corrId) {
            ListenerInfo info = (ListenerInfo)this.listenerForCorrelation.get(corrId);
            if (info == null) {
                return null;
            }
            return info.listener;
        }

        @Override
        public ICorrelationTimeoutMgmt getTimeoutManager() {
            return this;
        }

        @Override
        public void destroy() {
            if (timeoutTimer != null) {
                timeoutTimer.cancel();
                timeoutTimer.purge();
                timeoutTimer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Timer getTimeoutTimer() {
            Class<Coordinator> clazz = Coordinator.class;
            synchronized (Coordinator.class) {
                if (timeoutTimer == null) {
                    timeoutTimer = new Timer(true);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return timeoutTimer;
            }
        }

        @Override
        public boolean cancelTimeout(IRegistration registration, Object corrId) {
            if (!this.equals(registration)) {
                throw new IllegalArgumentException("canceling timeout on wrong registration");
            }
            ListenerInfo info = (ListenerInfo)this.listenerForCorrelation.get(corrId);
            if (info == null) {
                return false;
            }
            if (info.timeout == null) {
                throw new IllegalArgumentException("Attempt to cancle timeout which never existed");
            }
            boolean result = info.timeout.cancel();
            return result;
        }

        @Override
        public boolean resetTimeout(IRegistration registration, Object corrId, long newTimeout) {
            if (!this.equals(registration)) {
                throw new IllegalArgumentException("reseting timeout on wrong registration");
            }
            ListenerInfo info = (ListenerInfo)this.listenerForCorrelation.get(corrId);
            if (info == null || info.timeout == null) {
                throw new IllegalArgumentException("Attempt to reset invalid timeout");
            }
            boolean ret = false;
            RegistrationTimeout task = info.timeout;
            if (!task.hasRun) {
                ret = !task.cancel();
                this.getTimeoutTimer().schedule((TimerTask)task, newTimeout);
            }
            return ret;
        }

        ListenerInfo addTimedListener(IRegistration registration, Object jmsCorrID, ICorrelatedTimedListener listener) {
            long delay = listener.getTimeout();
            RegistrationTimeout task = null;
            if (delay > 0L) {
                task = new RegistrationTimeout(this, jmsCorrID, listener);
            }
            ListenerInfo info = new ListenerInfo(listener, task);
            if (task != null) {
                this.getTimeoutTimer().schedule((TimerTask)task, delay);
            }
            return info;
        }
    }

    static class RegistrationTimeout
    extends TimerTask {
        private final Registration registration;
        private final Object jmsCorrID;
        private final ICorrelatedTimedListener listener;
        private boolean hasRun = false;

        public RegistrationTimeout(Registration registration, Object jmsCorrID, ICorrelatedTimedListener listener) {
            this.registration = registration;
            this.jmsCorrID = jmsCorrID;
            this.listener = listener;
        }

        @Override
        public void run() {
            this.hasRun = true;
            this.listener.onTimeout(this.registration, this.jmsCorrID);
        }
    }

    static class ListenerInfo {
        protected ICorrelatedListener listener;
        protected RegistrationTimeout timeout;

        public ListenerInfo(ICorrelatedListener listener, RegistrationTimeout task) {
            this.listener = listener;
            this.timeout = task;
        }
    }
}

