/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.adapter.XQResourceAdapter;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCA1_0Connection;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAInterimDeploymentDescriptor;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAInterimEndpoint;
import java.net.URLClassLoader;
import javax.resource.spi.ConnectionManager;

public class JCAInterimConnection
extends JCA1_0Connection {
    private XQResourceAdapter m_resourceAdapter;
    private boolean m_hasManagedConnectionFactory;
    private boolean m_hasResourceAdapter;

    public JCAInterimConnection(URLClassLoader parentClassLoader, XQConnectionConfig config, XQConnectionTypeConfig typeConfig, XQLog log, JCAConnectionManager connectionManager, XQMessageFactory messageFactory) throws XQEndpointCreationException {
        super(parentClassLoader, config, typeConfig, log, connectionManager, new JCAInterimDeploymentDescriptor(), messageFactory);
        this.initializeResourceAdapter();
    }

    @Override
    public Endpoint createEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig) throws XQEndpointCreationException {
        return new JCAInterimEndpoint(config, typeConfig, this.m_log, this, this.m_messageFactory, this.m_connectionManager);
    }

    public XQResourceAdapter getResourceAdapter() {
        return this.m_resourceAdapter;
    }

    protected final void initializeResourceAdapter() throws XQEndpointCreationException {
        if (this.m_hasResourceAdapter) {
            JCAInterimDeploymentDescriptor dd = (JCAInterimDeploymentDescriptor)this.m_deploymentDescriptor;
            this.m_resourceAdapter = (XQResourceAdapter)this.createBean(dd.getResourceAdapterClassname(), dd.getResourceAdapterProperties(), XQResourceAdapter.class);
            this.m_resourceAdapter.start();
        }
    }

    @Override
    protected void initializeManagedConnectionFactory() throws XQEndpointCreationException {
        if (this.m_hasManagedConnectionFactory) {
            super.initializeManagedConnectionFactory();
        }
    }

    @Override
    protected void initializeConnectionFactory(ConnectionManager manager) throws XQEndpointCreationException {
        if (this.m_hasManagedConnectionFactory) {
            super.initializeConnectionFactory(manager);
        }
    }

    @Override
    protected void checkDeploymentDescriptor() throws XQEndpointCreationException {
        block2: {
            JCAInterimDeploymentDescriptor dd = (JCAInterimDeploymentDescriptor)this.m_deploymentDescriptor;
            String resourceAdapterClass = dd.getResourceAdapterClassname();
            this.m_hasResourceAdapter = resourceAdapterClass != null && !"".equals(resourceAdapterClass.trim());
            try {
                super.checkDeploymentDescriptor();
                this.m_hasManagedConnectionFactory = true;
            }
            catch (XQEndpointCreationException e) {
                if (this.m_hasResourceAdapter) break block2;
                throw new XQEndpointCreationException("Can't access / read / parse the specified Deployment Descriptor.  This may be because the deployment descriptor is malformed or that it is not at the location specified in the ConnectionType.");
            }
        }
    }

    public boolean hasResourceAdapter() {
        return this.m_hasResourceAdapter;
    }
}

