/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.soapunwrap;

import com.sonicsw.xqimpl.service.soapunwrap.OperationDetails;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.message.addressing.util.AddressingUtils;

public class WSDLContext {
    private Definition m_def = null;

    public Definition getDefinition() {
        return this.m_def;
    }

    public void setDefinition(Definition def) {
        this.m_def = def;
    }

    public WSDLContext(Definition def) {
        this.m_def = def;
    }

    public OperationDetails resolveOperation(String wsaActionURI, String soapActionURI, SOAPMessage soapm) {
        Map bindings = this.m_def.getBindings();
        if (bindings.size() == 0) {
            return null;
        }
        for (Binding binding : bindings.values()) {
            OperationDetails det = null;
            det = this.dispatchAction(binding, wsaActionURI, soapActionURI);
            if (det == null) continue;
            return det;
        }
        return null;
    }

    private OperationDetails dispatchAction(Binding binding, String wsaActionURI, String soapActionURI) {
        Iterator ops = binding.getBindingOperations().iterator();
        Iterator bindingExtElements = binding.getExtensibilityElements().iterator();
        SOAPBinding soapBinding = null;
        while (bindingExtElements.hasNext()) {
            ExtensibilityElement extEl = (ExtensibilityElement)bindingExtElements.next();
            if (!(extEl instanceof SOAPBinding)) continue;
            soapBinding = (SOAPBinding)extEl;
            break;
        }
        while (ops.hasNext()) {
            BindingOperation bindingOp = (BindingOperation)ops.next();
            SOAPOperation soapOperation = WSDLContext.getSOAPOperation(bindingOp);
            if (soapOperation == null) continue;
            if (soapOperation.getStyle() == null) {
                soapOperation.setStyle(soapBinding.getStyle());
            }
            if (!this.dispatchAction(wsaActionURI, soapActionURI, binding, bindingOp, soapOperation)) continue;
            return new OperationDetails(soapOperation, bindingOp, binding);
        }
        return null;
    }

    private boolean dispatchAction(String wsaActionURIParam, String soapActionURIParam, Binding binding, BindingOperation bindingOp, SOAPOperation soapOp) {
        String wsaActionURI = wsaActionURIParam;
        String soapActionURI = soapActionURIParam;
        Operation abstractOp = bindingOp.getOperation();
        String wsdlSoapActionURI = this.normalize(soapOp.getSoapActionURI());
        String wsdlInputWSAOp = this.normalize(AddressingUtils.getInputAction((QName)binding.getPortType().getQName(), (Operation)abstractOp));
        soapActionURI = this.normalize(soapActionURI);
        MatchResult result = this.actionMatch(wsaActionURI = this.normalize(wsaActionURI), wsdlInputWSAOp, soapActionURI, wsdlSoapActionURI);
        return result.getResult() == 0;
    }

    private static SOAPOperation getSOAPOperation(BindingOperation bindingOp) {
        SOAPOperation soapBindingOp = null;
        for (ExtensibilityElement extEl : bindingOp.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPOperation)) continue;
            soapBindingOp = (SOAPOperation)extEl;
            break;
        }
        return soapBindingOp;
    }

    private MatchResult actionMatch(String wsaAction, String wsdlWSAAction, String soapAction, String wsdlSoapAction) {
        boolean soapActionSet = false;
        boolean wsaActionSet = false;
        boolean wsdlSoapActionSet = false;
        if (soapAction.length() > 0) {
            soapActionSet = true;
        }
        if (wsaAction.length() > 0) {
            wsaActionSet = true;
        }
        if (wsdlSoapAction.length() > 0) {
            wsdlSoapActionSet = true;
        }
        if (wsdlSoapActionSet && soapActionSet || wsaActionSet) {
            if (wsaActionSet) {
                if (wsaAction.equals(wsdlWSAAction)) {
                    return new MatchResult(0);
                }
                if (wsdlSoapActionSet) {
                    if (wsdlSoapAction.equals(wsaAction) || soapActionSet && wsdlSoapAction.equals(soapAction)) {
                        return new MatchResult(0);
                    }
                    return new MatchResult(1);
                }
                return new MatchResult(1);
            }
            if (wsdlSoapAction.equals(soapAction)) {
                return new MatchResult(0);
            }
            return new MatchResult(1);
        }
        return new MatchResult(2);
    }

    private String normalize(String stringParam) {
        String string = stringParam;
        if (string == null) {
            string = "";
        } else if (string.length() > 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private class MatchResult {
        static final short MATCH = 0;
        static final short DONT_MATCH = 1;
        static final short NOT_APPLICABLE = 2;
        private short m_result = (short)2;

        MatchResult(short result) {
            this.m_result = result;
        }

        short getResult() {
            return this.m_result;
        }
    }
}

