/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.engine.ProcessChangeEventManager;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import java.util.HashSet;
import java.util.Iterator;

public class OldTerminateStepNode
extends EsbStepNode
implements FlowTerminationNode {
    private static final String PARAM_SINK_MSG = "MessageSink";
    public static final String PROCESS_TERMINATED = "ProcessTerminated";
    public static final String PROCESS_EXITED = "ProcessExited";
    private boolean m_isMessageSink = true;

    public OldTerminateStepNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.m_id = id;
        super.setDisplayName(stepName);
    }

    @Override
    public void setXQParameters(XQParameters params) {
        super.setXQParameters(params);
        try {
            if (this.m_stepParams.getParameter(PARAM_SINK_MSG, 1) != null) {
                this.m_isMessageSink = this.m_stepParams.getBooleanParameter(PARAM_SINK_MSG, 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Token execute(Token token) {
        boolean result;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (XQContainer.isTestContainer() && !mex.isExchangeImmediate() && (result = RunDebugUtil.execute(mex, token, this))) {
            XQMessageInternal msgInternal = (XQMessageInternal)((EsbMessageExchange)token.getData()).getInputMessage();
            return (Token)msgInternal.getSidebandProperty("TOKEN");
        }
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        OldTerminateStepNode.ensureBackwardCompatibility(token, procInst, this.m_displayName);
        if (this.m_isMessageSink) {
            return this.messageSink(token, mex, procInst);
        }
        return this.handleExits(token, mex, procInst);
    }

    private Token messageSink(Token token, EsbMessageExchange mex, XQProcessInstance procInst) {
        XQMessage msg = mex.getInputMessage();
        String messageId = "[Cannot retreive message ID]";
        try {
            messageId = (String)msg.getHeaderValue("JMSMessageID");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (s_debugLogEnabled) {
            s_log.logDebug("Acting as a message sink for message: " + messageId);
        }
        Token result = null;
        try {
            if (XQContainer.isTestContainer() && msg.getReplyTo() != null) {
                msg.removeAllParts();
                msg.addPart(msg.createPart((Object)"Process terminated successfully ... ", "text/plain"));
                result = token;
                mex.setDestinationAddress(XQAddressFactoryImpl.getReplyToStatic());
                ItineraryEndNode.dispatchMessageToExitorRME(token, procInst);
            } else {
                mex.setInputMessage(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ProcessChangeEventManager processChangeMgr = XQContainer.getProcessEngine().getProcessChangeEventManager();
        processChangeMgr.activityClosed(token, this);
        OldTerminateStepNode.sendServiceExitTrackingMessage(mex, procInst);
        procInst.changeProcessState(token, ProcessState.TERMINATED);
        return result;
    }

    private Token handleExits(Token token, EsbMessageExchange mex, XQProcessInstance procInst) {
        if (this.m_messageMapper != null) {
            DefaultMessageMapper.mapInputMessage(this.m_messageMapper, mex);
        }
        Token resultToken = this.getResultToken(mex, procInst, token);
        return this.getResultToken(mex, resultToken, token);
    }

    private Token getResultToken(EsbMessageExchange mex, XQProcessInstance procInst, Token token) {
        HashSet<XQAddress> exitAddresses = new HashSet<XQAddress>();
        procInst.populateExitEndpoints(exitAddresses, token);
        Token resultToken = null;
        if (exitAddresses.isEmpty()) {
            OldTerminateStepNode.sendServiceExitTrackingMessage(mex, procInst);
        } else if (exitAddresses.size() == 1) {
            mex.setDestinationAddress((XQAddress)exitAddresses.iterator().next());
            OldTerminateStepNode.sendServiceExitTrackingMessage(mex, procInst);
            resultToken = token;
        } else {
            CompositeToken cToken;
            resultToken = cToken = CompositeToken.createCompositeToken(this, token, mex, exitAddresses);
            Iterator<Token> iter = cToken.getTokens().iterator();
            while (iter.hasNext()) {
                OldTerminateStepNode.sendServiceExitTrackingMessage((EsbMessageExchange)iter.next().getData(), procInst);
            }
        }
        return resultToken;
    }

    private Token getResultToken(EsbMessageExchange mex, Token resultToken, Token token) {
        if (token != null) {
            try {
                ItineraryEndNode.dispatchMessage(token);
            }
            catch (Throwable e) {
                EsbStepNode.handleException(e, this, token, mex);
            }
        }
        return resultToken;
    }

    private static void sendServiceExitTrackingMessage(EsbMessageExchange mex, XQProcessInstance procInst) {
        if (procInst.getprocessTracker() != null) {
            procInst.getprocessTracker().sendTrackingMessage("SERVICE_EXIT", mex.getInputMessage(), mex.getDestinationAddress(), mex, 2);
        }
    }

    private static void ensureBackwardCompatibility(Token token, XQProcessInstance procInst, String name) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        mex.getXQParameters().setParameter("SonicXQ.ProcessStep", 1, procInst.getCompleteStepName(name));
        mex.getXQParameters().setParameter("SonicXQ.ApplicationName", 1, "TerminateStepService");
        mex.getXQParameters().setParameter("SonicXQ.ServiceName", 1, "TerminateStepService");
    }

    @Override
    public void offerOutgoing(Token token) {
        this.deactivate(token);
        if (!this.m_isMessageSink) {
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            if (procInst.isSubProcess()) {
                ItineraryEndNode.sendToParentProcess(token, procInst);
            } else if (procInst instanceof FaultProcessInstance) {
                throw new ItineraryException("The old terminate step cannot be used in a fault handler", token);
            }
        }
    }

    @Override
    public boolean deactivate(Token token) {
        super.deactivate(token);
        if (!this.m_isMessageSink) {
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            procInst.changeProcessState(token, ProcessState.CLOSED);
        }
        return true;
    }

    public static boolean isTerminateStepService(XQAbstractAddressImpl endpointRef) {
        return endpointRef.getType() == 1 && endpointRef.getName().equals("TerminateStepService");
    }
}

