/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.impl;

import com.sonicsw.esb.jeri.jms.JMSPreferredSessionTracker;
import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.event.Event;
import com.sonicsw.esb.run.event.EventQueue;
import com.sonicsw.esb.run.event.impl.TestExceptionEvent;
import com.sonicsw.esb.run.impl.AnyLocation;
import com.sonicsw.esb.run.impl.LocationContext;
import com.sonicsw.esb.run.impl.RunContext;
import com.sonicsw.esb.run.impl.RunStartLocation;
import com.sonicsw.esb.run.impl.util.PreferredExporterFactory;
import com.sonicsw.esb.run.impl.util.RunUtils;
import com.sonicsw.esb.run.impl.util.XQUtils;
import com.sonicsw.esb.run.request.EventRequest;
import com.sonicsw.esb.run.request.SendRunMessageRequest;
import com.sonicsw.esb.run.request.impl.ReceiveFaultMessageRequest;
import com.sonicsw.esb.run.request.impl.ReceiveRMEMessageRequest;
import com.sonicsw.esb.run.request.impl.ReceiveResponseMessageRequest;
import com.sonicsw.esb.run.request.impl.SuspendRequest;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.connector.jms.XQJMSMessageMapper;
import com.sonicsw.xqimpl.config.XQParamsConfigHelper;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Run
implements com.sonicsw.esb.run.Run,
MessageListener {
    protected final Uuid m_runID;
    protected final LocationContext m_locationContext;
    protected boolean m_isSuspended = false;
    protected final Properties m_runServiceProperties = new Properties();
    protected com.sonicsw.esb.run.event.impl.EventQueue m_eventQueue = new com.sonicsw.esb.run.event.impl.EventQueue();
    protected ReceiveResponseMessageRequest m_receiveResponseMessageRequest = null;
    protected ReceiveFaultMessageRequest m_receiveFaultMessageRequest = null;
    protected ReceiveRMEMessageRequest m_receiveRMEMessageRequest = null;
    protected Connection m_jmsConnection = null;
    protected Session m_producerSession = null;
    protected Session m_consumerSession = null;
    protected MessageConsumer m_consumer = null;
    protected MessageProducer m_producer = null;
    protected Destination m_replyToDestination;
    protected RunProxy m_proxy = null;
    protected XQMessage m_testMessage = null;
    private RunProxy m_unExportedProxy = null;
    private Exporter m_proxyExporter = null;
    private RunContext m_runContext = null;
    private boolean m_isStarted = false;
    private boolean m_isClosed = false;
    private String m_serviceName = "dev.Run";

    public Run(Map env) throws RunException {
        this.m_runID = UuidFactory.generate();
        if (env.containsKey("RUNTIME_PARAMS")) {
            XQParameters params = (XQParameters)env.get("RUNTIME_PARAMS");
            Document doc = DOMUtils.createDocument();
            Element element = doc.createElement("run");
            doc.appendChild(element);
            XQParamsConfigHelper.writeToXML((Document)doc, (Element)element, (XQParameters)params);
            StringWriter writer = new StringWriter();
            DOMUtils.serializeNodeToWriter((Node)element, (Writer)writer);
            this.m_runServiceProperties.put("SERVICE_RUNTIME_PARAMS", writer.toString());
        }
        if (env.containsKey("RUN_SERVICE_NAME")) {
            this.m_serviceName = (String)env.get("RUN_SERVICE_NAME");
        }
        XQUtils.JMSInfo jmsInfo = XQUtils.retrieveJMSInfo(this.m_serviceName);
        try {
            this.m_jmsConnection = XQUtils.registerJMSPreferredSession(jmsInfo, this.getRunID());
            this.m_producerSession = this.m_jmsConnection.createSession(false, 1);
            this.m_consumerSession = this.m_jmsConnection.createSession(false, 1);
            this.m_replyToDestination = this.m_producerSession.createTemporaryQueue();
            Object targetDestination = null;
            targetDestination = "QUEUE".equals(jmsInfo.m_destinationType) ? this.m_producerSession.createQueue(jmsInfo.m_destinationName) : this.m_producerSession.createTopic(jmsInfo.m_destinationName);
            this.m_producer = this.m_producerSession.createProducer((Destination)targetDestination);
            this.m_consumer = this.m_consumerSession.createConsumer(this.m_replyToDestination);
            this.m_consumer.setMessageListener((MessageListener)this);
        }
        catch (Exception e) {
            throw new RunException("Failed to create Run", e);
        }
        this.m_locationContext = new LocationContext(new RunStartLocation(), this, new PreferredExporterFactory(JMSPreferredSessionTracker.getInstance(), this.m_runID.toString()), this.getRunContext());
    }

    @Override
    public void close() {
        try {
            if (this.m_isClosed) {
                return;
            }
            if (this.m_proxyExporter != null) {
                this.m_proxyExporter.unexport(true);
            }
            JMSPreferredSessionTracker.getInstance().removeInvocation(this.getRunID());
            this.m_consumer.setMessageListener(null);
            this.m_consumer.close();
            this.m_consumerSession.close();
            this.m_producer.close();
            this.m_producerSession.close();
            this.m_replyToDestination = null;
            this.m_jmsConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.m_isClosed = true;
        }
    }

    @Override
    public final String getRunID() {
        return this.m_runID.toString();
    }

    @Override
    public EventQueue getEventQueue() {
        return this.m_eventQueue;
    }

    @Override
    public synchronized boolean isSuspended() {
        return this.m_isSuspended;
    }

    @Override
    public synchronized void suspend() throws RunException {
        this.checkIfClosed();
        this.m_isSuspended = true;
    }

    @Override
    public synchronized void resume() throws RunException {
        this.checkIfClosed();
        this.m_isSuspended = false;
    }

    public RunProxy getRunProxy() throws RunException {
        if (this.m_proxy == null) {
            RunProxyImpl runProxy = new RunProxyImpl();
            this.exportRunProxy(runProxy);
        }
        return this.m_proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws RunException {
        try {
            this.checkIfClosed();
            Run run = this;
            synchronized (run) {
                if (this.m_isStarted) {
                    return;
                }
                this.m_isStarted = true;
            }
            RunContext runContext = this.getRunContext();
            runContext.process(this.m_locationContext);
        }
        catch (Exception e) {
            throw new RunException("Failed to start Run", e);
        }
    }

    public final RunContext getRunContext() throws RunException {
        if (this.m_runContext == null) {
            RunProxy runProxy = this.getRunProxy();
            this.m_runContext = this.newRunContext(runProxy);
        }
        return this.m_runContext;
    }

    public void processStartLocationRequest(EventRequest request) throws RunException {
        if (this.m_isStarted) {
            RunContext context = this.getRunContext();
            request.process(this.m_locationContext);
        }
    }

    public void onMessage(Message message) {
        try {
            XQMessage xqMessage = XQUtils.createXQMessageFromJMSMessage(message);
            if (RunUtils.isExitMessage(xqMessage) && this.m_receiveResponseMessageRequest != null) {
                RunUtils.removeRunInfo(xqMessage);
                this.m_receiveResponseMessageRequest.onMessage(xqMessage);
            } else if (RunUtils.isFaultMessage(xqMessage) && this.m_receiveFaultMessageRequest != null) {
                RunUtils.removeRunInfo(xqMessage);
                this.m_receiveFaultMessageRequest.onMessage(xqMessage);
            } else if (RunUtils.isRMEMessage(xqMessage) && this.m_receiveRMEMessageRequest != null) {
                RunUtils.removeRunInfo(xqMessage);
                this.m_receiveRMEMessageRequest.onMessage(xqMessage);
            } else if (this.m_receiveResponseMessageRequest != null) {
                RunUtils.removeRunInfo(xqMessage);
                this.m_receiveResponseMessageRequest.onMessage(xqMessage);
            }
        }
        catch (Exception e) {
            try {
                RunException te = new RunException("Run failed to receive message", e);
                TestExceptionEvent event = new TestExceptionEvent(te);
                this.sendEvent(event);
            }
            catch (RunException e1) {
                e.printStackTrace();
            }
        }
    }

    public void listenForResponseMessages(ReceiveResponseMessageRequest request) throws RunException {
        this.m_receiveResponseMessageRequest = request;
    }

    public void listenForFaultMessages(ReceiveFaultMessageRequest request) throws RunException {
        this.m_receiveFaultMessageRequest = request;
    }

    public void listenForRMEMessages(ReceiveRMEMessageRequest request) throws RunException {
        this.m_receiveRMEMessageRequest = request;
    }

    public void sendEvent(Event event) {
        this.m_eventQueue.send(event);
    }

    public XQMessage getTestMessage() {
        return this.m_testMessage;
    }

    public void setTestMessage(XQMessage testMessage) {
        this.m_testMessage = testMessage;
    }

    public void sendMsg(SendRunMessageRequest request) throws RunException {
        try {
            XQMessage xqMessage = this.getTestMessage();
            xqMessage = XQUtils.populateMessageWithRunServiceProps(xqMessage, this.getRunServiceProperties(), this.getRunType());
            xqMessage = RunUtils.populateMessageWithRun(xqMessage, this);
            Message jmsMsg = (Message)XQJMSMessageMapper.create().translateInput(xqMessage, null);
            jmsMsg.setJMSReplyTo(this.getReplyTo());
            this.m_producer.send(jmsMsg);
        }
        catch (Exception e) {
            throw new RunException("Failed to send Run Message", e);
        }
    }

    protected final Properties getRunServiceProperties() {
        return this.m_runServiceProperties;
    }

    protected final MessageProducer getProducer() {
        return this.m_producer;
    }

    protected final Destination getReplyTo() {
        return this.m_replyToDestination;
    }

    protected final RunContext newRunContext(RunProxy runProxy) throws RunException {
        return new RunContext(runProxy);
    }

    protected final void checkIfClosed() throws RunException {
        if (this.m_isClosed) {
            throw new RunException("Run is closed.");
        }
    }

    protected abstract String getRunType();

    protected RunProxy exportRunProxy(RunProxy runProxy) throws RunException {
        try {
            if (this.m_proxy != null) {
                this.m_proxyExporter.unexport(true);
            }
            try {
                this.m_proxyExporter = JMSPreferredSessionTracker.getInstance().getExporter(this.m_runID.toString());
            }
            catch (Exception e) {
                throw new RunException(e);
            }
            this.m_unExportedProxy = runProxy;
            this.m_proxy = (RunProxy)this.m_proxyExporter.export((Remote)runProxy);
            return this.m_proxy;
        }
        catch (Exception e) {
            throw new RunException("Failed to create proxy for Run object", e);
        }
    }

    public static interface RunProxy
    extends Remote {
        public String getRunID() throws RemoteException;

        public List getEventRequests(Location var1) throws RemoteException;

        public void send(Event var1) throws RemoteException;

        public void ping() throws RemoteException;

        public void close() throws RemoteException;
    }

    public class RunProxyImpl
    implements RunProxy {
        @Override
        public String getRunID() throws RemoteException {
            return Run.this.getRunID();
        }

        @Override
        public void ping() throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
            Run.this.close();
        }

        @Override
        public List getEventRequests(Location atLocation) throws RemoteException {
            List requests = Run.this.getEventRequestManager().getEventRequests(atLocation);
            if (Run.this.isSuspended() && !(atLocation instanceof RunStartLocation)) {
                RunProxy runProxy;
                try {
                    runProxy = Run.this.getRunProxy();
                }
                catch (RunException e) {
                    throw new RemoteException("Failed to create Run Proxy", e);
                }
                requests.add(0, new SuspendRequest(runProxy, new AnyLocation()));
            }
            return requests;
        }

        @Override
        public void send(Event event) throws RemoteException {
            Run.this.m_eventQueue.send(event);
        }
    }
}

