/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.connector.jms.ContentTypeJMSMapper;
import com.sonicsw.xq.connector.jms.ContentTypeJMSMapperConstants;
import com.sonicsw.xqimpl.util.URLUtil;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ContentTypeJMSMapperImpl
implements ContentTypeJMSMapper {
    private static String UNABLE_TO_LOAD_MAPPING_OVERRIDES_ERR_MSG = "Cannot load XQMessage Content-Type to JMS type mapping overrides.";
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)512);
    private Hashtable<String, String> m_mappings = null;
    private boolean m_hasMappings = false;

    ContentTypeJMSMapperImpl(String overridePropertiesFileURL) {
        if (overridePropertiesFileURL != null) {
            if (URLUtil.exists((String)overridePropertiesFileURL)) {
                Properties props = new Properties();
                this.m_mappings = new Hashtable();
                try {
                    props.load(URLUtil.getInputStream((URL)new URL(overridePropertiesFileURL)));
                    Enumeration<?> propNames = props.propertyNames();
                    s_log.logDebug("Processing XQMessage Content-Type to JMS type mapping overrides from properties file \"" + overridePropertiesFileURL + "\": ");
                    while (propNames.hasMoreElements()) {
                        String name = (String)propNames.nextElement();
                        String value = props.getProperty(name);
                        s_log.logDebug("name=" + name + " value=" + value);
                        if (this.getJMSMessageType(value) == ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN) {
                            s_log.logWarning("Ignoring unknown or unsupported JMS type in mapping: content-type pattern=\"" + name + "\" JMS type=\"" + value + "\"");
                            continue;
                        }
                        if (name.equals("*/*")) {
                            this.m_mappings.put(name, value);
                            continue;
                        }
                        int delimIndex = (name = name.toLowerCase()).indexOf("/*");
                        if (delimIndex > 0) {
                            name = name.substring(0, delimIndex + 1);
                        }
                        this.m_mappings.put(name, value);
                    }
                    if (props.size() > 0) {
                        this.m_hasMappings = true;
                    }
                }
                catch (MalformedURLException e) {
                    s_log.logWarning(UNABLE_TO_LOAD_MAPPING_OVERRIDES_ERR_MSG);
                    s_log.logWarning("Malformed URL: " + overridePropertiesFileURL);
                    s_log.logWarning((Throwable)e);
                }
                catch (IOException e) {
                    s_log.logWarning(UNABLE_TO_LOAD_MAPPING_OVERRIDES_ERR_MSG);
                    s_log.logWarning((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    s_log.logWarning(UNABLE_TO_LOAD_MAPPING_OVERRIDES_ERR_MSG);
                    s_log.logWarning((Throwable)e);
                }
            } else {
                s_log.logWarning(UNABLE_TO_LOAD_MAPPING_OVERRIDES_ERR_MSG);
                s_log.logWarning("File does not exist: " + overridePropertiesFileURL);
            }
        }
    }

    @Override
    public ContentTypeJMSMapperConstants.JMSMessageType getMatchedJMSMessageType(String contentTypeParam) {
        String defaultTypeString;
        String contentType = contentTypeParam;
        ContentTypeJMSMapperConstants.JMSMessageType defaultType = ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN;
        if (!this.hasMappings()) {
            return defaultType;
        }
        contentType = contentType.toLowerCase();
        if (this.m_mappings != null && (defaultTypeString = this.m_mappings.get("*/*")) != null) {
            defaultType = this.getJMSMessageType(defaultTypeString);
        }
        if (contentType == null) {
            return defaultType;
        }
        if (this.m_mappings != null) {
            ContentTypeJMSMapperConstants.JMSMessageType mappedJMSMessageType;
            int delimIndex;
            String mappedJMSMessageTypeString;
            String mappedContentType = contentType;
            int index = mappedContentType.indexOf(";");
            if (index > 0) {
                mappedContentType = mappedContentType.substring(0, index);
            }
            if ((mappedJMSMessageTypeString = this.m_mappings.get(mappedContentType)) == null && (delimIndex = mappedContentType.indexOf("/")) > 0) {
                mappedContentType = mappedContentType.substring(0, delimIndex + 1);
                mappedJMSMessageTypeString = this.m_mappings.get(mappedContentType);
            }
            if ((mappedJMSMessageType = this.getJMSMessageType(mappedJMSMessageTypeString)) != ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN) {
                return mappedJMSMessageType;
            }
        }
        return defaultType;
    }

    @Override
    public boolean hasMappings() {
        return this.m_hasMappings;
    }

    private ContentTypeJMSMapperConstants.JMSMessageType getJMSMessageType(String messageType) {
        if (messageType != null) {
            if (messageType.equals("TEXT")) {
                return ContentTypeJMSMapperConstants.JMSMessageType.TEXT;
            }
            if (messageType.equals("XML")) {
                return ContentTypeJMSMapperConstants.JMSMessageType.XML;
            }
            if (messageType.equals("MULTIPART")) {
                return ContentTypeJMSMapperConstants.JMSMessageType.MULTIPART;
            }
            if (messageType.equals("BYTES")) {
                return ContentTypeJMSMapperConstants.JMSMessageType.BYTES;
            }
        }
        return ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN;
    }

    @Override
    public Dictionary<String, String> getMappings() {
        return this.m_mappings;
    }
}

