/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.impl;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.RoutingExpressionConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingListConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingRuleConfiguration;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingContext;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingRule;
import com.sonicsw.xq.service.xcbr.routingRules.expressions.RoutingExpression;
import com.sonicsw.xq.service.xcbr.routingRules.expressions.RoutingExpressionFactory;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingList;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingListFactory;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLTagMarker;
import javax.xml.namespace.NamespaceContext;

public class RoutingRuleImpl
implements RoutingRule {
    private RoutingExpression expression_;
    private RoutingList destinations_;
    private String description_;
    private static final String ROOT_TAG = "RoutingRule";
    private static final String DESCRIPTION_TAG = "Description";

    public RoutingRuleImpl() throws RoutingRuleException {
    }

    public RoutingRuleImpl(RoutingRuleConfiguration argConfiguration) throws RoutingRuleException {
        this.setRoutingList(argConfiguration.getRoutingList());
        this.setDescription(argConfiguration.getDescription());
        this.setRoutingExpression(argConfiguration.getRoutingExpression());
    }

    @Override
    public void initializeXPath(NamespaceContext nc) throws RoutingRuleException {
        this.getRoutingExpression().initializeXPath(nc);
    }

    @Override
    public void toXML(XMLOutputStream argOutputStream) throws RoutingRuleException {
        try {
            XMLTagMarker marker = argOutputStream.getTagMarker();
            argOutputStream.startTag(ROOT_TAG);
            argOutputStream.closeTags(marker);
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    @Override
    public boolean route(InvocationContext argMessage, RoutingContext argContext) throws RoutingRuleException {
        boolean returnValue = false;
        returnValue = this.getRoutingExpression().route(argMessage, argContext);
        if (returnValue) {
            this.destinations_.route(argMessage, argContext);
        }
        return returnValue;
    }

    private RoutingExpression getRoutingExpression() throws RoutingRuleException {
        return this.expression_;
    }

    private void setDescription(String argDescription) throws RoutingRuleException {
        this.description_ = argDescription;
    }

    private void setRoutingList(RoutingListConfiguration argConfiguration) throws RoutingRuleException {
        this.destinations_ = RoutingListFactory.create(argConfiguration);
    }

    private void setRoutingExpression(RoutingExpressionConfiguration argConfiguration) throws RoutingRuleException {
        this.expression_ = RoutingExpressionFactory.create(argConfiguration);
    }
}

