/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.routingList.impl;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.BaseRoutingEndpointImpl;

public class ESBStepByPropertyNameImpl
extends BaseRoutingEndpointImpl {
    public ESBStepByPropertyNameImpl(String argName) throws RoutingRuleException {
        super(argName);
    }

    @Override
    public void route(InvocationContext argMessage) throws RoutingRuleException {
        super.route(argMessage);
        try {
            String stepName = argMessage.getMessagePropertyValue(this.getName());
            if (stepName == null) {
                throw new RoutingRuleException("Routing to an ESBStep must define a value in the message property " + this.getName());
            }
            if (stepName.length() == 0) {
                throw new RoutingRuleException("The routing step name specified by the property " + this.getName() + " must be a valid value");
            }
            XQProcessContext processContext = argMessage.getProcessContext();
            XQAddress outgoingAddress = processContext.getStepAddress(stepName);
            argMessage.addAddressToIncoming(outgoingAddress);
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    @Override
    public String getRoutingType() {
        return "ESBProcessStep";
    }
}

