/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.script.Command;
import com.sonicsw.xqimpl.script.DiscardParameterValue;
import com.sonicsw.xqimpl.script.ExtractedValue;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.Namespaces;
import com.sonicsw.xqimpl.script.ParameterValueFactory;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.script.Translation;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.Variable;
import com.sonicsw.xqimpl.script.VariableDirection;
import com.sonicsw.xqimpl.script.VariableValue;
import com.sonicsw.xqimpl.script.XFormUtil;
import com.sonicsw.xqimpl.util.xml.SaxonSerializationUtils;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterMap {
    private HashMap m_map = new HashMap();
    private XFormUtil m_xFormUtil = null;
    private List m_nameSpaceList;
    private ScriptObject m_script;

    public ParameterMap(Namespaces nameSpaceList, ScriptObject obj) throws ScriptEngineException {
        this.m_xFormUtil = new XFormUtil(nameSpaceList, true);
        this.m_nameSpaceList = nameSpaceList != null ? nameSpaceList.getNamespaceList() : null;
        this.m_script = obj;
    }

    public void add(String parameterName, VariableDirection direction, String parameterValue) {
        ParameterMapping map = new ParameterMapping();
        map.setParameterValue(parameterValue);
        this.putParameterMapping(parameterName, direction, map);
    }

    public void add(String parameterName, VariableDirection direction, String variableName, Translation translationType, String translationString) {
        ParameterMapping map = new ParameterMapping();
        map.setVariableName(variableName);
        map.setTranslation(translationType);
        map.setTranslationString(translationString);
        this.putParameterMapping(parameterName, direction, map);
    }

    public IParameterValue getParameterValue(String parameterName, String parameterType, VariableDirection direction, Command command) throws ScriptEngineException, XQMessageException {
        ParameterValueFactory factory = command.getScript().getScriptCommand().getParameterValueFactory();
        ParameterMapping mapping = this.getParameterMapping(parameterName, direction);
        if (mapping != null) {
            Object value = mapping.getParameterValue();
            if (value != null) {
                IParameterValue pvResult = factory.createParameterValue(parameterName, parameterType, value.toString());
                Util.addNamespacesToParameter(this.m_nameSpaceList, pvResult);
                return pvResult;
            }
            String variableName = mapping.getVariableName();
            if (variableName != null) {
                IParameterValue pvResult;
                ExtractedValue ev = command.getVariableValue(variableName);
                if (ev == null) {
                    return this.createDiscardValue(parameterName, parameterType);
                }
                Translation translationType = mapping.getTranslation();
                if (translationType != null) {
                    String source = null;
                    if (ev.getType().equals("application/octet-stream")) {
                        try {
                            source = Util.createStringFromByteArray((byte[])ev.getData(), this.m_script.getEncoding());
                        }
                        catch (IOException e) {
                            ScriptEngineException ex = new ScriptEngineException(e.getMessage(), null, 2);
                            throw ex;
                        }
                    } else {
                        source = (String)ev.getData();
                    }
                    String translationString = mapping.getTranslationString();
                    try {
                        if (translationType == Translation.XPATH) {
                            SequenceExtent xpathValue = this.m_xFormUtil.performXPath(source, translationString);
                            return this.createParameterValueFromXPathValue(parameterName, parameterType, xpathValue, factory);
                        }
                        if (translationType == Translation.XSLT) {
                            IParameterValue pv = factory.createParameterValue(parameterName, parameterType, this.m_xFormUtil.performXSLTfromURI(source, translationString));
                            Util.addNamespacesToParameter(this.m_nameSpaceList, pv);
                            return pv;
                        }
                    }
                    catch (Exception e) {
                        ScriptEngineException e2 = new ScriptEngineException("get-parameter-failure", new Object[]{parameterName, variableName, translationString, e.getClass().getName(), e.getMessage()}, 1);
                        throw e2;
                    }
                }
                if (ev.getType().equals("application/octet-stream")) {
                    pvResult = factory.createParameterValue(parameterName, parameterType, (byte[])ev.getData());
                    Util.addNamespacesToParameter(this.m_nameSpaceList, pvResult);
                    return pvResult;
                }
                pvResult = factory.createParameterValue(parameterName, parameterType, ev.getData().toString());
                Util.addNamespacesToParameter(this.m_nameSpaceList, pvResult);
                return pvResult;
            }
        } else {
            return this.createDiscardValue(parameterName, parameterType);
        }
        return null;
    }

    private IParameterValue createDiscardValue(String parameterName, String parameterType) {
        DiscardParameterValue discardValue = new DiscardParameterValue(parameterName);
        Util.addNamespacesToParameter(this.m_nameSpaceList, discardValue);
        discardValue.setBaseType(parameterType);
        return discardValue;
    }

    public boolean hasParameterMapping(String parameterName, VariableDirection direction) {
        ParameterMapping mapping = this.getParameterMapping(parameterName, direction);
        return mapping != null;
    }

    public VariableValue getVariableValue(IParameterValue value) throws ScriptEngineException {
        String paramName = value.getParamName();
        ParameterMapping mapping = this.getParameterMapping(paramName, VariableDirection.OUT);
        if (mapping == null) {
            return null;
        }
        String variableName = mapping.getVariableName();
        String translationString = mapping.getTranslationString();
        Translation translationType = mapping.getTranslation();
        VariableValue val = null;
        if (variableName != null && mapping != null && translationType != null) {
            try {
                if (translationType == Translation.XPATH) {
                    SequenceExtent xpathValue = this.m_xFormUtil.performXPath(value.getAsElement(), translationString);
                    val = this.createVariableValueFromXPathValue(variableName, value.getParamName(), xpathValue);
                } else if (translationType == Translation.XSLT) {
                    Variable v = (Variable)this.m_script.getVariableMap().get(variableName);
                    val = new VariableValue(variableName, this.m_xFormUtil.performXSLT(value.getAsElement(), translationString), v.isDocument());
                }
            }
            catch (ScriptEngineException e) {
                ScriptEngineException e2 = new ScriptEngineException("get-variable-failure", new Object[]{paramName, variableName, translationString, e.getClass().getName(), e.getMessage()}, 1);
                throw e2;
            }
        }
        if (val == null && variableName != null) {
            val = new VariableValue(variableName, value);
        }
        return val;
    }

    private VariableValue createVariableValueFromXPathValue(String variableName, String parameterName, SequenceExtent xpathValue) throws ScriptEngineException {
        try {
            int xpLen = xpathValue.getLength();
            if (xpLen != 1) {
                throw new ScriptEngineException("xform-xpath-invalid-number-of-results", new Object[]{new Integer(xpLen)}, 1);
            }
            Item item = xpathValue.itemAt(0);
            if (item instanceof NumericValue && ((NumericValue)item).isNaN()) {
                throw new ScriptEngineException("xpath-invalid-number-of-results", new Object[]{new Integer(xpathValue.getLength()), parameterName}, 1);
            }
            boolean isXML = false;
            String result = null;
            if (item instanceof NodeInfo) {
                StringWriter writer = new StringWriter();
                isXML = SaxonSerializationUtils.serializeNodeToWriter((NodeInfo)((NodeInfo)item), (Writer)writer, (int)2);
                result = writer.toString();
                return new VariableValue(variableName, result, isXML);
            }
            result = xpathValue.getStringValue();
            return new VariableValue(variableName, result, false);
        }
        catch (ScriptEngineException e) {
            throw e;
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    private IParameterValue createParameterValueFromXPathValue(String parameterName, String parameterType, SequenceExtent xpathValue, ParameterValueFactory factory) throws ScriptEngineException {
        try {
            int xpLen = xpathValue.getLength();
            if (xpLen != 1) {
                throw new ScriptEngineException("xform-xpath-invalid-number-of-results", new Object[]{new Integer(xpLen)}, 1);
            }
            Item item = xpathValue.itemAt(0);
            if (item instanceof NumericValue && ((NumericValue)item).isNaN()) {
                throw new ScriptEngineException("xpath-nan", 2);
            }
            if (item instanceof NodeInfo) {
                Node domNode = XMLUtils.getDOMNode((NodeInfo)((NodeInfo)item));
                short type = domNode.getNodeType();
                IParameterValue pvResult = null;
                switch (type) {
                    case 9: {
                        Document doc = (Document)domNode;
                        pvResult = factory.createParameterValue(parameterName, parameterType, doc.getDocumentElement());
                        break;
                    }
                    case 1: {
                        Element element = (Element)domNode;
                        pvResult = factory.createParameterValue(parameterName, parameterType, element);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: {
                        String result = item.getStringValue();
                        pvResult = factory.createParameterValue(parameterName, parameterType, result);
                        break;
                    }
                    default: {
                        String result = item.getStringValue();
                        pvResult = factory.createParameterValue(parameterName, parameterType, result);
                        break;
                    }
                }
                Util.addNamespacesToParameter(this.m_nameSpaceList, pvResult);
                return pvResult;
            }
            String result = item.getStringValue();
            IParameterValue pvResult = factory.createParameterValue(parameterName, parameterType, result);
            Util.addNamespacesToParameter(this.m_nameSpaceList, pvResult);
            return pvResult;
        }
        catch (ScriptEngineException e) {
            throw e;
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    void validateVariables(Map scriptVariables) throws ScriptEngineException {
        for (ParameterMapping parameterMapping : this.m_map.entrySet()) {
            Variable v;
            String variableName = parameterMapping.getVariableName();
            if (variableName == null || (v = (Variable)scriptVariables.get(parameterMapping.getVariableName())) != null) continue;
            throw new ScriptEngineException("variable-undefined", new Object[]{parameterMapping.getVariableName()}, 1);
        }
    }

    private ParameterMapping getParameterMapping(String parameterName, VariableDirection direction) {
        ParameterKey pk = new ParameterKey(parameterName, direction);
        return (ParameterMapping)this.m_map.get(pk);
    }

    private void putParameterMapping(String parameterName, VariableDirection direction, ParameterMapping mapping) {
        ParameterKey pk = new ParameterKey(parameterName, direction);
        this.m_map.put(pk, mapping);
    }

    public class ParameterMapping {
        private String m_variableName;
        private Object m_value;
        private Translation m_translation;
        private String m_translationString;

        public String getVariableName() {
            return this.m_variableName;
        }

        public void setVariableName(String variableName) {
            this.m_variableName = variableName;
        }

        public void setParameterValue(Object value) {
            this.m_value = value;
        }

        public Translation getTranslation() {
            return this.m_translation;
        }

        public void setTranslation(Translation translation) {
            this.m_translation = translation;
        }

        public String getTranslationString() {
            return this.m_translationString;
        }

        public void setTranslationString(String translationString) {
            this.m_translationString = translationString;
        }

        public Object getParameterValue() {
            return this.m_value;
        }
    }

    final class ParameterKey {
        private VariableDirection m_parameterMapDirection;
        private String m_parameterName;

        ParameterKey(String name, VariableDirection direction) {
            this.m_parameterMapDirection = direction;
            this.m_parameterName = name;
        }

        public int hashCode() {
            return this.m_parameterName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterKey) {
                ParameterKey pk = (ParameterKey)obj;
                if (this.m_parameterName.equals(pk.m_parameterName) && this.m_parameterMapDirection == pk.m_parameterMapDirection) {
                    return true;
                }
            }
            return false;
        }
    }
}

