/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.ExpressionType;
import com.sonicsw.esb.expression.def.el.ContainerPropertyExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.CustomExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.EsbdlExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.EsbpExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.MapCtxExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.PropsExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.RunActionExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.StrConcatExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.SystemPropertyExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.URLReaderExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.XQMsgExpressionDefProcessor;
import java.util.Arrays;

public class ELExpressionDefProcessFactory
implements ExpressionDefProcessorFactory {
    private static String[] s_expressionPrefixes = new String[]{"esbmsg", "esbpStepInMsg", "esbpStepOutMsg", "esbdl", "esbp", "mapctx"};
    private boolean m_enforceConformance;

    public ELExpressionDefProcessFactory() {
        this(true);
    }

    public ELExpressionDefProcessFactory(boolean boolVal) {
        this.m_enforceConformance = boolVal;
    }

    @Override
    public ExpressionDefProcessor getExpressionDefProcessor(String strExpression) {
        String trimmedStr;
        ExpressionDefProcessor exprProcessor = null;
        if (strExpression != null && (trimmedStr = strExpression.trim()).length() > 3 && trimmedStr.charAt(1) == '{' && trimmedStr.charAt(trimmedStr.length() - 1) == '}') {
            if (trimmedStr.charAt(0) == '$') {
                String scheme = null;
                String remaining = null;
                int dotIndex = trimmedStr.indexOf(46);
                int bracketIndex = trimmedStr.indexOf(91);
                if (dotIndex != -1 && (bracketIndex == -1 || dotIndex < bracketIndex)) {
                    scheme = trimmedStr.substring(2, dotIndex);
                    remaining = trimmedStr.substring(dotIndex + 1, trimmedStr.length() - 1);
                }
                if (scheme != null) {
                    if (XQMsgExpressionDefProcessor.matchesPrefix(scheme)) {
                        this.validateMultipleParts(dotIndex, strExpression);
                        exprProcessor = new XQMsgExpressionDefProcessor(scheme, remaining);
                    } else if ("esbdl".equals(scheme)) {
                        this.validateMultipleParts(dotIndex, strExpression);
                        exprProcessor = new EsbdlExpressionDefProcessor(remaining);
                    } else if ("esbp".equals(scheme)) {
                        this.validateMultipleParts(dotIndex, strExpression);
                        exprProcessor = new EsbpExpressionDefProcessor(remaining);
                    } else if ("mapctx".equals(scheme)) {
                        this.validateMultipleParts(dotIndex, strExpression);
                        exprProcessor = new MapCtxExpressionDefProcessor(remaining);
                    }
                }
                if (exprProcessor == null) {
                    if ((trimmedStr = trimmedStr.substring(2, trimmedStr.length() - 1)).startsWith("xq:getProperties")) {
                        exprProcessor = new PropsExpressionDefProcessor(trimmedStr);
                    } else if (trimmedStr.startsWith("xq:runAction")) {
                        exprProcessor = new RunActionExpressionDefProcessor(trimmedStr);
                    } else if (trimmedStr.startsWith("xq:readURL")) {
                        exprProcessor = new URLReaderExpressionDefProcessor(trimmedStr);
                    } else if (trimmedStr.startsWith("system")) {
                        exprProcessor = new SystemPropertyExpressionDefProcessor(trimmedStr);
                    } else if (trimmedStr.startsWith("container")) {
                        exprProcessor = new ContainerPropertyExpressionDefProcessor(trimmedStr);
                    } else if (trimmedStr.startsWith("xq:strConcat")) {
                        exprProcessor = new StrConcatExpressionDefProcessor(trimmedStr);
                    }
                }
            } else if (trimmedStr.charAt(0) == '#') {
                exprProcessor = new CustomExpressionDefProcessor(trimmedStr);
            }
        }
        if (exprProcessor == null && this.m_enforceConformance) {
            throw new ExpressionException("Invalid expression " + strExpression);
        }
        return exprProcessor;
    }

    private void validateMultipleParts(int dotIndex, String strExpression) {
        if (dotIndex == -1) {
            throw new ExpressionException("Invalid expression " + strExpression);
        }
    }

    @Override
    public ExpressionDefProcessor getExpressionDefProcessor(ExpressionDef expression) {
        if (expression.getType() == ExpressionType.XQMSG) {
            return new XQMsgExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.ESBDL) {
            return new EsbdlExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.ESBP) {
            return new EsbpExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.MAPCTX) {
            return new MapCtxExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.PROPS) {
            return new PropsExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.URL) {
            return new URLReaderExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.SYSTEM) {
            return new SystemPropertyExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.CONTAINER) {
            return new ContainerPropertyExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.RUNACTION) {
            return new RunActionExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.STRCONCAT) {
            return new StrConcatExpressionDefProcessor();
        }
        if (expression.getType() == ExpressionType.CUSTOM) {
            return new CustomExpressionDefProcessor();
        }
        return null;
    }

    @Override
    public boolean isValidExpression(String expression) {
        return expression != null && expression.trim().length() > 3 && (expression.charAt(0) == '$' || expression.charAt(0) == '#') && expression.charAt(1) == '{' && expression.charAt(expression.length() - 1) == '}';
    }

    public static boolean matchesSupportedExpressionPrefix(String scheme) {
        return Arrays.binarySearch(s_expressionPrefixes, scheme) >= 0;
    }

    public static boolean startWithSupportedExpressionPrefix(String scheme) {
        return scheme.startsWith("esbmsg") || scheme.startsWith("esbpStepInMsg") || scheme.startsWith("esbpStepOutMsg") || scheme.startsWith("esbdl") || scheme.startsWith("esbp") || scheme.startsWith("mapctx") || scheme.startsWith("container") || scheme.startsWith("system") || scheme.startsWith("xq:strConcat") || scheme.startsWith("xq:getProperties") || scheme.startsWith("xq:readURL") || scheme.startsWith("xq:runAction");
    }
}

