/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.ProcessTracker;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceGenerator;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.ProcessExitConnector;
import com.sonicsw.esb.itinerary.model.StepConnector;
import com.sonicsw.esb.process.engine.EngineException;
import com.sonicsw.esb.process.engine.Pid;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.engine.ProcessInstanceGenerator;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.FinalNode;
import com.sonicsw.esb.process.model.ForkNode;
import com.sonicsw.esb.process.model.InitialNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.MergeNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.Variable;
import com.sonicsw.esb.process.model.impl.DefaultActivityEdge;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class XQProcessInstance
implements ProcessInstance {
    protected Pid m_pid;
    protected XQProcessInstance m_parentInstance;
    private XQProcessConfig m_processConfig;
    private String[] m_activeNodes = new String[1];
    protected ProcessState m_processState = ProcessState.UNKNOWN;
    protected MainProcess m_process;
    private ProcessTracker m_tracker;
    private long m_timestamp;
    protected boolean m_isSubProcess;
    protected ProcessInstanceProps m_procInstProps;
    private List<XQPart> m_parentProcParts;
    private Set<XQAddress> m_nextAddresses;
    private FaultProcessInstance m_fhProcInst;
    private String m_previousActiveNode;
    private int m_trackingLevel = -1;
    protected ProcessInstanceGenerator m_instGenerator;
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    public static final String NEXT_ADDR_DYNAMIC = "NextAddrDynamic";

    protected XQProcessInstance() {
    }

    protected XQProcessInstance(XQProcessInstanceGenerator instGenerator, MainProcess process, XQProcessConfig procCfg, EsbMessageExchange mex) {
        this.init(instGenerator, process, procCfg, mex);
        mex.setRMEMessage(null);
    }

    protected final void init(ProcessInstanceGenerator instGenerator, MainProcess process, XQProcessConfig procCfg, EsbMessageExchange mex) {
        this.m_instGenerator = instGenerator;
        this.m_process = process;
        this.m_processConfig = procCfg;
        this.m_timestamp = System.currentTimeMillis();
        this.setActiveNode(this.m_process.getInitialNode(), null);
        this.m_pid = new Pid(process.getProcessName());
        this.m_procInstProps = new ProcessInstanceProps(this, mex);
        this.setProcessTracker(this.m_procInstProps.getTracker());
    }

    protected XQProcessInstance(ProcessInstanceGenerator instGenerator, ESBProcess process, XQProcessConfig procCfg, XQProcessInstance parentProcInst) {
        this.m_instGenerator = instGenerator;
        this.m_process = process;
        this.m_processConfig = procCfg;
        this.m_isSubProcess = true;
        this.setProcessTracker(parentProcInst.getprocessTracker());
        this.m_parentInstance = parentProcInst;
        this.m_procInstProps = this.m_parentInstance.getProcessInstanceProperties();
        this.m_procInstProps.pushParentStepName();
        this.setActiveNode(this.m_process.getInitialNode(), null);
        this.m_pid = new Pid(process.getProcessName());
        this.m_timestamp = parentProcInst.getTimestamp();
    }

    protected XQProcessInstance(ProcessInstanceGenerator instGen, List<XQPart> processParts, ProcessInstanceProps procInstProps, Token token, boolean insertFirstStep) throws Throwable {
        this.m_instGenerator = instGen;
        this.m_processState = ProcessState.OPEN;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        this.m_parentProcParts = processParts;
        this.m_procInstProps = procInstProps;
        mex.setRMEAddress(this.m_procInstProps.getRMEAddress());
        XQAbstractAddressImpl topmostStepEndpointRef = null;
        if (insertFirstStep) {
            topmostStepEndpointRef = new XQAbstractAddressImpl(mex.getDestinationAddress().toString());
        }
        this.m_process = ((XQProcessInstanceGenerator)instGen).getESBProcess(this, token, (XQAddress)topmostStepEndpointRef, this.m_parentProcParts, 0);
        this.m_isSubProcess = !this.m_parentProcParts.isEmpty();
        this.m_pid = new Pid(this.m_process.getProcessName());
        String activeStepName = this.m_procInstProps.getCurrentProcessStepName();
        ActivityNode activeNode = ((ESBProcess)this.m_process).getActivityNodeByName(activeStepName);
        if (activeNode == null) {
            throw new ItineraryException("Cannot find node `" + activeStepName + "` in process " + this.m_process.getDisplayName(), token);
        }
        this.setActiveNode(activeNode, null);
        if (this.m_procInstProps.getTrackingLevel() > 0) {
            this.setProcessTracker(new ProcessTracker(this.m_procInstProps));
        }
    }

    protected XQProcessInstance(ProcessInstanceGenerator instGen, XQProcessInstance childInstance, Token token, int index) {
        this.m_instGenerator = instGen;
        this.m_processState = ProcessState.OPEN;
        try {
            this.m_parentProcParts = childInstance.getParentProcessMetadataParts();
            this.m_procInstProps = childInstance.getProcessInstanceProperties();
            this.m_process = ((XQProcessInstanceGenerator)instGen).getProcessDefFromPart(this.m_parentProcParts, index, token, this, null);
            this.m_isSubProcess = !this.m_parentProcParts.isEmpty();
            this.m_pid = new Pid(this.m_process.getProcessName());
            ActivityNode activeNode = null;
            float pmv = this.m_processConfig.getProcessModelVersionAsFloat();
            activeNode = pmv >= 2.0f ? this.m_process.getInitialNode().getOutgoingEdges()[0].getDestination() : this.m_process.getInitialNode();
            this.setActiveNode(activeNode, null);
            this.setProcessTracker(childInstance.getprocessTracker());
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error creating process instance", null);
        }
    }

    public void overrideProcess(ESBProcess overrideProcess, XQProcessConfig procConfig, Token token) {
        try {
            this.m_process = overrideProcess;
            this.setProcessConfig(procConfig);
            this.m_procInstProps.overrideValues(this, (EsbMessageExchange)token.getData());
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error while trying to override current process instance", token);
        }
    }

    public ActivityNode unwind(Token token, int unWindCount) {
        XQProcessInstance procInst;
        ActivityNode activeParentNode = null;
        XQProcessInstance parentProcInst = procInst = (XQProcessInstance)token.getProcessInstance();
        ProcessInstanceProps procInstProps = procInst.getProcessInstanceProperties();
        for (int i = 0; i < unWindCount; ++i) {
            parentProcInst = procInst.getParentProcessInstance(token, true);
            if (parentProcInst == null) {
                throw new ItineraryException("Cannot find child process instance. Unwinding of the process instance failed.", token);
            }
            procInstProps.popParentStepName();
            activeParentNode = parentProcInst.getActiveEsbNode(token);
            if (activeParentNode == null) {
                throw new ItineraryException(null, "Cannot find active node in parent process to continue processing", token);
            }
            parentProcInst.setActiveNode(activeParentNode, token);
            procInst = parentProcInst;
        }
        token.setProcessInstance(procInst);
        return activeParentNode;
    }

    public void setParentProcessInstance(XQProcessInstance procInst) {
        this.m_isSubProcess = true;
        this.m_parentInstance = procInst;
    }

    @Override
    public Pid getPID() {
        return this.m_pid;
    }

    public void setProcessConfig(XQProcessConfig processConfig) {
        this.m_processConfig = processConfig;
    }

    public XQProcessConfig getProcessConfig() {
        return this.m_processConfig;
    }

    @Override
    public final void setActiveNode(ActivityNode node, Token token) {
        this.m_activeNodes[0] = node.getId();
        if (this.m_procInstProps != null && node instanceof EsbNode) {
            this.m_procInstProps.setStepName(node.getDisplayName(), this);
            this.m_procInstProps.setProcessName(node.getParentProcess().getProcessName());
        }
    }

    @Override
    public void removeActiveNode(ActivityNode node, Token token) {
        this.m_previousActiveNode = this.m_activeNodes[0];
        this.m_activeNodes[0] = null;
    }

    @Override
    public void changeProcessState(Token token, ProcessState newState) {
        if (this.m_processState != newState) {
            this.m_processState = newState;
            XQContainer.getProcessEngine().getProcessChangeEventManager().processStateChanged(token, newState);
        }
    }

    @Override
    public ProcessState getProcessState() {
        return this.m_processState;
    }

    public void persistVariable(Variable variable, String location) {
        throw new UnsupportedOperationException("No support for variables yet");
    }

    @Override
    public String[] getActiveNodes(Token token) {
        return this.m_activeNodes;
    }

    public ActivityNode getActiveEsbNode(Token token) {
        return this.m_activeNodes[0] == null ? null : this.m_process.getActivityNode(this.m_activeNodes[0]);
    }

    public ActivityNode getPreviousActiveEsbNode(Token token) {
        return this.m_previousActiveNode == null ? null : this.m_process.getActivityNode(this.m_previousActiveNode);
    }

    @Override
    public MainProcess getProcessDefinition() {
        return this.m_process;
    }

    public ProcessInstanceProps getProcessInstanceProperties() {
        return this.m_procInstProps;
    }

    public Set<XQAddress> getNextAddresses(Token token) {
        if (s_log.isDebugLoggingEnabled()) {
            s_log.logDebug("Returning next addresses " + this.m_nextAddresses);
        }
        return this.m_nextAddresses;
    }

    public void setNextAddresses(Set<XQAddress> nextAddresses) {
        this.m_nextAddresses = nextAddresses;
    }

    public Set<XQAddress> computeNextAddresses(ActivityNode currentNode, Set<XQAddress> nextAddresses, Token token) {
        this.getNextAddresses(currentNode, nextAddresses, token);
        this.m_nextAddresses = nextAddresses;
        return nextAddresses;
    }

    protected void getNextAddresses(ActivityNode activeNode, Set<XQAddress> nextAddresses, Token token) {
        ActivityNode nextNode = activeNode.getOutgoingEdges()[0].getDestination();
        if (nextNode instanceof FinalNode) {
            this.populateExitEndpoints(nextAddresses, token);
        } else if (nextNode instanceof EsbNode) {
            XQAddress nextEndpointRef = ((EsbNode)nextNode).getEndpointRef(null);
            nextAddresses.add(nextEndpointRef);
        } else if (nextNode instanceof ForkNode) {
            this.getFirstStepOfEachBranch(nextNode, nextAddresses, token);
        } else if (nextNode instanceof MergeNode) {
            this.getNextAddresses(nextNode, nextAddresses, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateExitEndpoints(Set<XQAddress> nextAddresses, Token token) {
        if (this.m_isSubProcess) {
            ActivityNode savedNode = this.getActiveEsbNode(token);
            try {
                XQProcessInstance parentProcInst = this.getParentProcessInstance(token, true);
                parentProcInst.computeNextAddresses(parentProcInst.getActiveEsbNode(token), nextAddresses, token);
            }
            finally {
                this.setActiveNode(savedNode, token);
            }
        } else {
            ProcessInstanceProps processProps = this.getProcessInstanceProperties();
            Set<XQAddress> exitAddresses = processProps.getExitAddresses();
            if (exitAddresses != null && !exitAddresses.isEmpty()) {
                nextAddresses.addAll(exitAddresses);
            }
        }
        token.setProperty(NEXT_ADDR_DYNAMIC, "isLastStep");
    }

    private void getFirstStepOfEachBranch(ActivityNode branchingNode, Set<XQAddress> branchAddresses, Token token) {
        ActivityEdge[] outEdges = branchingNode.getOutgoingEdges();
        for (int i = 0; i < outEdges.length; ++i) {
            ActivityNode branchNode = outEdges[i].getDestination();
            if (branchNode instanceof ItineraryEndNode) {
                this.populateExitEndpoints(branchAddresses, token);
                continue;
            }
            if (!(branchNode instanceof EsbNode)) continue;
            branchAddresses.add(((EsbNode)branchNode).getEndpointRef(null));
        }
    }

    @Override
    public ProcessInstance getParentProcessInstance(Token token) {
        return this.getParentProcessInstance(token, true);
    }

    public XQProcessInstance getParentProcessInstance(Token token, boolean create) {
        if (this.m_parentInstance == null && create && this.m_parentProcParts != null && !this.m_parentProcParts.isEmpty()) {
            this.m_parentInstance = this instanceof FaultProcessInstance ? new FaultProcessInstance(this.m_instGenerator, (FaultProcessInstance)this, token, 0) : new XQProcessInstance(this.m_instGenerator, this, token, 0);
        }
        return this.m_parentInstance;
    }

    @Override
    public XQProcessInstance clone() {
        XQProcessInstance newInstance = new XQProcessInstance();
        this.clone(newInstance);
        return newInstance;
    }

    protected void clone(XQProcessInstance newInstance) {
        try {
            newInstance.m_activeNodes = new String[this.m_activeNodes.length];
            newInstance.m_activeNodes[0] = this.m_activeNodes[0];
            newInstance.m_pid = this.m_pid;
            newInstance.m_processState = this.m_processState;
            newInstance.m_process = this.m_process;
            newInstance.m_tracker = this.m_tracker;
            newInstance.m_trackingLevel = this.m_trackingLevel;
            newInstance.m_timestamp = this.m_timestamp;
            newInstance.m_isSubProcess = this.m_isSubProcess;
            newInstance.m_processConfig = this.m_processConfig;
            newInstance.m_nextAddresses = this.m_nextAddresses;
            newInstance.m_instGenerator = this.m_instGenerator;
            newInstance.m_procInstProps = this.m_procInstProps.clone();
            if (this.m_parentProcParts != null && !this.m_parentProcParts.isEmpty()) {
                newInstance.m_parentProcParts = new ArrayList<XQPart>(this.m_parentProcParts);
            }
            if (this.m_parentInstance != null) {
                newInstance.m_parentInstance = this.m_parentInstance.clone();
            }
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error while cloning process instance", null);
        }
    }

    public String getCompleteStepName(String stepName) {
        if (this.m_isSubProcess) {
            return this.m_procInstProps.getParentStepsTrail() + ':' + stepName;
        }
        return stepName;
    }

    void insertNewNode(ESBProcess processDef, ActivityNode newStepNode) {
        processDef.addActivityNode(newStepNode);
        InitialNode initialNode = (InitialNode)processDef.getInitialNode();
        ActivityEdge firstEdge = initialNode.getOutgoingEdges()[0];
        ActivityNode node2 = firstEdge.getDestination();
        processDef.removeActivityEdge(firstEdge);
        firstEdge = new DefaultActivityEdge(initialNode, newStepNode);
        processDef.addActivityEdge(firstEdge);
        DefaultActivityEdge secondEdge = null;
        secondEdge = node2 instanceof ItineraryEndNode ? new ProcessExitConnector(newStepNode, (ItineraryEndNode)node2) : (node2 instanceof EsbNode ? new StepConnector(newStepNode, node2) : new DefaultActivityEdge(newStepNode, node2));
        processDef.addActivityEdge(secondEdge);
    }

    @Override
    public void deleteVariable(Variable variable) {
        throw new UnsupportedOperationException("No support for variables yet");
    }

    @Override
    public Variable getVariable(String scope, String name) {
        throw new UnsupportedOperationException("No support for variables yet");
    }

    @Override
    public void persistVariable(Variable variable) {
        throw new UnsupportedOperationException("No support for variables yet");
    }

    public final void setProcessTracker(ProcessTracker tracker) {
        this.m_tracker = tracker;
        if (this.m_tracker != null && this.m_tracker.isTracking()) {
            this.m_trackingLevel = this.m_tracker.getTrackingDetails().getTrackingLevel();
        }
    }

    public ProcessTracker getprocessTracker() {
        return this.m_tracker;
    }

    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public boolean isSubProcess() {
        return this.m_isSubProcess;
    }

    public void setProcessInstanceProperties(ProcessInstanceProps processProps) {
        this.m_procInstProps = processProps;
    }

    public void setProcess(ESBProcess currentProcess) {
        this.m_process = currentProcess;
    }

    public List<XQPart> getParentProcessMetadataParts() {
        return this.m_parentProcParts;
    }

    public void setPID(Pid pid) {
        this.m_pid = pid;
    }

    @Override
    public void serialize() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public FaultProcessInstance getFaultHandlerProcessInstance() {
        return this.m_fhProcInst;
    }

    public void setFaultHandlerProcessInstance(FaultProcessInstance fhProcInst) {
        this.m_fhProcInst = fhProcInst;
    }

    public boolean isFaultHandlingDisabled(FaultHandler fh, ExecutableNode node, Token token) {
        String completeStepName = this.getCompleteStepName(node.getDisplayName());
        ActivityNode fhNode = fh.getFaultHandlerActivityNode("*", token);
        String key = completeStepName + "." + fhNode.getDisplayName() + ".disable";
        String value = this.m_procInstProps.getAllProcessProps().getProperty(key);
        return Boolean.parseBoolean(value);
    }

    public void disableFaultHandling(MainProcess fhProcess, ActivityNode node, Token token) {
        String completeStepName = this.getCompleteStepName(node.getDisplayName());
        String key = completeStepName + "." + fhProcess.getDisplayName() + ".disable";
        this.m_procInstProps.getAllProcessProps().setProperty(key, "true");
    }

    public int getTrackingLevel() {
        return this.m_trackingLevel;
    }

    public void setProcessInstanceGenerator(ProcessInstanceGenerator generator) {
        this.m_instGenerator = generator;
    }

    @Override
    public ProcessInstanceGenerator getProcessInstanceGenerator() {
        return this.m_instGenerator;
    }
}

