/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.jeri.jms;

import com.sonicsw.esb.jeri.DebugDestination;
import com.sonicsw.esb.jeri.DebugEndpoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.Part;

public class JMSContainerServerEndpoint
implements ServerEndpoint {
    protected Session m_jmsSession = null;
    private String m_uuid;

    public JMSContainerServerEndpoint(Session jmsSession, String uuid) throws JMSException {
        this.m_jmsSession = jmsSession;
        if (this.m_jmsSession.getTransacted()) {
            throw new JMSException("Cannot create server on transacted Session");
        }
        this.m_uuid = uuid;
    }

    public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        return InvocationConstraints.EMPTY;
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        try {
            JMSListenEndpoint listenEndpoint = new JMSListenEndpoint();
            JMSListenHandle listenCookie = (JMSListenHandle)listenContext.addListenEndpoint((ServerEndpoint.ListenEndpoint)listenEndpoint);
            return new DebugEndpoint(new DebugDestination(listenCookie.getListenerDestination()), this.m_uuid, this.m_uuid);
        }
        catch (JMSException e) {
            throw new IOException(e.getMessage());
        }
    }

    private class JMSListenEndpoint
    implements ServerEndpoint.ListenEndpoint {
        JMSListenEndpoint() {
        }

        public void checkPermissions() {
        }

        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            try {
                return new JMSListenHandle(requestDispatcher);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private class JMSListenHandle
    implements ServerEndpoint.ListenHandle,
    ServerEndpoint.ListenCookie {
        Session m_session = null;
        Destination m_listenDestination = null;
        JMSMessageListener m_msgListener = null;
        MessageConsumer m_messageConsumer = null;

        public JMSListenHandle(RequestDispatcher requestDispatcher) throws JMSException {
            this.m_session = JMSContainerServerEndpoint.this.m_jmsSession;
            this.m_listenDestination = this.m_session.createTemporaryQueue();
            this.m_messageConsumer = this.m_session.createConsumer(this.m_listenDestination);
            this.m_msgListener = new JMSMessageListener(requestDispatcher, this.m_session);
            this.m_messageConsumer.setMessageListener((MessageListener)this.m_msgListener);
        }

        public Session getSession() {
            return this.m_session;
        }

        public Destination getListenerDestination() {
            return this.m_listenDestination;
        }

        public void close() {
            try {
                this.m_messageConsumer.close();
                if (this.m_listenDestination instanceof TemporaryQueue) {
                    ((TemporaryQueue)this.m_listenDestination).delete();
                } else if (this.m_listenDestination instanceof TemporaryTopic) {
                    ((TemporaryTopic)this.m_listenDestination).delete();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return this;
        }
    }

    private class JMSInboundRequest
    implements InboundRequest {
        private InputStream m_in;
        private ByteArrayOutputStream m_out = new ByteArrayOutputStream();

        JMSInboundRequest(InputStream stream) {
            this.m_in = stream;
        }

        public void checkPermissions() {
        }

        public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
            return InvocationConstraints.EMPTY;
        }

        public void populateContext(Collection context) {
        }

        public InputStream getRequestInputStream() {
            return this.m_in;
        }

        public OutputStream getResponseOutputStream() {
            return this.m_out;
        }

        public void abort() {
        }
    }

    private class JMSMessageListener
    implements MessageListener {
        private RequestDispatcher m_dispatcher;
        Session m_session = null;
        MessageProducer m_sender = null;

        JMSMessageListener(RequestDispatcher dispatcher, Session session) throws JMSException {
            this.m_dispatcher = dispatcher;
            this.m_session = session;
            this.m_sender = this.m_session.createProducer(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(final Message m) {
            try {
                m.acknowledge();
                if (m.propertyExists("SonicESB.PING_REQUEST_PROP")) {
                    Destination pingReply = m.getJMSReplyTo();
                    Message pingReplyMsg = this.m_session.createMessage();
                    try (MessageProducer producer = this.m_session.createProducer(pingReply);){
                        producer.send(pingReplyMsg);
                    }
                    return;
                }
                byte[] request = null;
                if (m instanceof BytesMessage) {
                    BytesMessage bm = (BytesMessage)m;
                    request = new byte[(int)bm.getBodyLength()];
                    bm.readBytes(request);
                } else if (m instanceof MultipartMessage) {
                    MultipartMessage mm = (MultipartMessage)m;
                    Part p = mm.getPart(0);
                    if (p != null) {
                        request = p.getContentBytes();
                    }
                } else {
                    return;
                }
                final JMSInboundRequest inRqst = new JMSInboundRequest(new ByteArrayInputStream(request));
                new Thread(){

                    @Override
                    public void run() {
                        JMSMessageListener.this.m_dispatcher.dispatch((InboundRequest)inRqst);
                        try {
                            Destination replyTo = m.getJMSReplyTo();
                            if (replyTo != null) {
                                ByteArrayOutputStream bos = (ByteArrayOutputStream)inRqst.getResponseOutputStream();
                                BytesMessage respMsg = JMSMessageListener.this.m_session.createBytesMessage();
                                respMsg.writeBytes(bos.toByteArray());
                                JMSMessageListener.this.m_sender.send(replyTo, (Message)respMsg);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

