/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.endpoint.container.EndpointContextContainer;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.service.MessageCouldNotBeRejected;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.HashMap;
import java.util.List;

public class RejectedMessageDispatcher {
    private static XQLog log = XQLogImpl.getCategoryLog((int)128);
    private final XQServiceMetrics m_metricsHelper;
    private final XQServiceMetrics.Statistic m_messagesRejectedStatistic;

    public RejectedMessageDispatcher(XQServiceMetrics metricsHelper) {
        this.m_metricsHelper = metricsHelper;
        this.m_messagesRejectedStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_REJECTED);
    }

    public RejectedMessageDispatcher() {
        this.m_metricsHelper = null;
        this.m_messagesRejectedStatistic = null;
    }

    public void sendRMEMessage(String sender, EsbMessageExchange mex) {
        block3: {
            if (mex.getRMEAddress() == null) {
                log.logWarning("No rejected message endpoint defined for: " + sender);
                return;
            }
            try {
                mex.setDestinationAddress(mex.getRMEAddress());
                RejectedMessageDispatcher.sendToRME(mex, sender, this.m_messagesRejectedStatistic);
            }
            catch (Throwable rmeExcp) {
                log.logInformation("Failed to send message to RME due to: ");
                log.logInformation(rmeExcp);
                if (mex.getQOS() != XQQualityofService.EXACTLY_ONCE && mex.getQOS() != XQQualityofService.AT_LEAST_ONCE && mex.getQOS() != XQQualityofService.AT_LEAST_ONCE_FAST) break block3;
                throw new MessageCouldNotBeRejected(rmeExcp, null, mex.getRMEAddress());
            }
        }
    }

    public void logRMEMessageErrorDebugInfo(String sender, String errorCode, Throwable cause) {
        log.logError(sender + " - " + errorCode + " error processing message: " + cause.getMessage());
        log.logDebug(cause);
    }

    public void handleRME(String sender, Throwable cause, XQMessage message, EsbMessageExchange mex, List mexList, String errorCode) {
        if (mexList != null) {
            this.logRMEMessageErrorDebugInfo(sender, errorCode, cause);
            RMEMessage rmeMsg = new RMEMessage(cause, mex.getRMEAddress(), mex.getMessageFactory(), message, mex.getXQParameters(), errorCode);
            EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
            newMex.setInputMessage(message);
            newMex.setRMEMessage(rmeMsg);
            mexList.add(newMex);
        } else {
            this.sendMessageToRME(cause, message, mex.getRMEAddress(), errorCode, mex.getXQParameters(), mex.getEndpointContext(), mex.getMessageFactory(), sender);
        }
    }

    public boolean sendMessageToRME(Throwable cause, XQMessage message, XQAddress rmeAddress, String errorCode, XQParameters params, EndpointContextContainer endpointContext, XQMessageFactory messageFactory, String sender) {
        return this.sendMessageToRME(cause, message, rmeAddress, errorCode, params, endpointContext.getQualityofService(), endpointContext.getEndpointRegistry(), messageFactory, sender);
    }

    public boolean sendMessageToRME(Throwable cause, XQMessage message, XQAddress rmeAddress, String errorCode, XQParameters params, XQQualityofService qos, IEndpointRegistry endpointRegistry, XQMessageFactory messageFactory, String sender) {
        this.logRMEMessageErrorDebugInfo(sender, errorCode, cause);
        if (rmeAddress == null) {
            log.logWarning("No rejected message endpoint defined for: " + sender);
            return false;
        }
        RMEMessage rmeMessage = null;
        try {
            rmeMessage = new RMEMessage(cause, rmeAddress, messageFactory, message, params, errorCode);
            XQMessage msg = rmeMessage.getMessage(true);
            RejectedMessageDispatcher.send(msg, rmeAddress, params, qos, endpointRegistry, messageFactory, sender, this.m_messagesRejectedStatistic);
            return true;
        }
        catch (Throwable rmeExcp) {
            log.logInformation("Failed to send message to RME due to: " + rmeExcp.getMessage());
            log.logInformation("Cause of rejected message: " + errorCode + " " + cause.getMessage());
            if (qos == XQQualityofService.EXACTLY_ONCE || qos == XQQualityofService.AT_LEAST_ONCE || qos == XQQualityofService.AT_LEAST_ONCE_FAST) {
                throw new MessageCouldNotBeRejected(rmeExcp, cause, rmeAddress, rmeMessage);
            }
            return false;
        }
    }

    public XQMessage createRMEMessage(Throwable cause, XQMessage message, XQAddress rmeAddress, String errorCode, XQParameters params, EndpointContextContainer endpointContext, XQMessageFactory messageFactory, String sender) {
        block3: {
            RMEMessage rmeMessage = null;
            try {
                if (rmeAddress != null) {
                    rmeMessage = new RMEMessage(cause, rmeAddress, messageFactory, message, params, errorCode);
                    XQMessage rmeXQMsg = rmeMessage.getMessage(true);
                    return rmeXQMsg;
                }
                log.logWarning("No rejected message endpoint defined for: " + sender);
            }
            catch (Throwable rmeExcp) {
                log.logInformation("Failed to create RME nessage due to: " + rmeExcp.getMessage());
                if (endpointContext.getQualityofService() != XQQualityofService.EXACTLY_ONCE && endpointContext.getQualityofService() != XQQualityofService.AT_LEAST_ONCE && endpointContext.getQualityofService() != XQQualityofService.AT_LEAST_ONCE_FAST) break block3;
                throw new MessageCouldNotBeRejected(rmeExcp, null, rmeAddress, rmeMessage);
            }
        }
        return null;
    }

    public static void send(XQMessage message, XQAddress rmeAddress, XQParameters environment, XQQualityofService qos, IEndpointRegistry er, XQMessageFactory messageFactory, String sender, XQServiceMetrics.Statistic rmeStat) throws Throwable {
        if (rmeAddress != null) {
            EsbMessageExchange mex = EsbMessageExchange.createImmediate(null, rmeAddress, messageFactory, message, environment, qos, true, er);
            mex.setRMEAddress(rmeAddress);
            RejectedMessageDispatcher.sendToRME(mex, sender, rmeStat);
        } else {
            log.logWarning("No rejected message endpoint defined");
        }
    }

    private static void sendToRME(EsbMessageExchange mex, String sender, XQServiceMetrics.Statistic rmeStat) throws Throwable {
        XQParameters environment = mex.getXQParameters();
        XQMessage message = mex.getInputMessage();
        if (environment != null) {
            environment = (XQParameters)environment.clone();
            environment.setParameter("SonicXQ.process.trackingLevel", 1, null);
        }
        if (!mex.isExchangeImmediate()) {
            throw new IllegalStateException("The message exchange object should be of type immediate");
        }
        if (XQContainer.isEnhancedStepReportingModeEnabled()) {
            RejectedMessageDispatcher.createActionalRejectSite(mex);
        } else {
            ((XQMessageInternal)message).addSidebandProperty("SonicESB.LG_REPORT_FAILURE", "Message rejected");
        }
        mex.setCommitFlag(true);
        MessageSendingHelper.sendToAddress(mex, sender);
        if (rmeStat != null) {
            rmeStat.increment();
        }
        if (XQQualityofService.EXACTLY_ONCE == mex.getQOS()) {
            log.logWarning("Message sent to RME outside ExO QoS of service. Message may be redelivered if the container fails immediately.");
        }
    }

    public static void sendMessageToGlobalRME(RMEMessage originalRME, XQAddress globalRMEAddress, String globalRMECode, String globalRMEDetails, String sender, XQQualityofService qos, IEndpointRegistry endpointRegistry) {
        if (originalRME == null) {
            log.logInformation("Failed to send message to Global RME as the original RME information is unavailable");
        } else {
            try {
                originalRME.setGlobalRMEDetails(globalRMECode, globalRMEDetails);
                originalRME.resetContents(globalRMEAddress);
                originalRME.send(sender, originalRME.getParams(), qos, endpointRegistry);
            }
            catch (Throwable rmeExcp) {
                log.logInformation("Failed to send message to Global RME due to: " + rmeExcp.getMessage());
            }
        }
    }

    public static void sendMessageToGlobalRME(Throwable cause, XQMessage message, XQAddress globalRME, String rmeErrorCode, String globalRmeErrorCode, String globalRmeErrorMsg, XQParameters params, XQQualityofService qos, IEndpointRegistry er, XQMessageFactory messageFactory, String sender) {
        try {
            RMEMessage rmeMessage = new RMEMessage(cause, globalRME, messageFactory, message, params, rmeErrorCode);
            rmeMessage.setGlobalRMEDetails(globalRmeErrorCode, globalRmeErrorMsg);
            rmeMessage.send(sender, params, qos, er);
        }
        catch (Throwable rmeExcp) {
            log.logInformation("Failed to send message to Global RME due to: " + rmeExcp.getMessage());
        }
    }

    private static void createActionalRejectSite(EsbMessageExchange mex) {
        XQMessage msg = mex.getInputMessage();
        XQMessageInternal msgInternal = (XQMessageInternal)msg;
        ESBVisitor visitor = msgInternal.getVisitor();
        String processName = null;
        if (visitor == null) {
            return;
        }
        XQParameters params = mex.getXQParameters();
        HashMap<String, Object> visitorParams = new HashMap<String, Object>();
        if (params != null) {
            processName = params.getParameter("SonicXQ.ProcessName", 1);
        }
        XQAddress address = mex.getDestinationAddress();
        visitorParams.put("ESBVisitor.PARAM_REJECT_ADDRESS", address);
        visitorParams.put("ESBVisitor.PARAM_SERVICE_NAME", "(TerminalRejectGroup)");
        visitorParams.put("ESBVisitor.PARAM_STEP_NAME", "(Reject)");
        visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName != null ? processName : "STANDALONE");
        visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", mex.getXQParameters());
        visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", mex.getInputMessage());
        visitor.sentToStep(visitorParams);
        visitor.receivedByStep(visitorParams);
        visitorParams.put("End SI", "true");
        visitor.receivedByStep(visitorParams);
    }
}

