/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.template.EndForeachFragment;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;

class EndForeachTagParser
extends TagParser {
    protected static final String tagStart = "</FOREACH";
    protected static final int tagStartLength = "</FOREACH".length();

    EndForeachTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        int sourceLen;
        char[] source = parser.getTemplateSource();
        if (!this.tagNameMatches(source, startPos, sourceLen = source.length, "/FOREACH", "/foreach")) {
            return null;
        }
        int endPos = EndForeachTagParser.tagEndPos(startPos + tagStartLength, source, source.length);
        this.collectTagInfo(source, startPos, endPos);
        return new EndForeachFragment(startPos, endPos);
    }

    private void collectTagInfo(char[] source, int startPos, int endPos) {
        String attributesString = new String(source, startPos + tagStartLength, endPos - startPos - tagStartLength);
        TagParser.TagAttribute[] attributes = this.collectAttributes(attributesString, source, startPos);
        int n = attributes.length;
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i].getAttrName();
            String attrValue = attributes[i].getAttrValue();
            System.err.println("Unrecognized </FOREACH> attibute: " + attrName + " on line " + TemplateParser.lineNumber(source, startPos));
        }
    }
}

