/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.client.impl.util;

import com.sonicsw.esb.mgmtapi.config.IConnectionConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Random;

public class Utils {
    private static long m_sequence = -1L;
    private static String m_prefix;

    public static String generateUniqueID() throws Exception {
        Random r = new Random();
        String randomNum = new Integer(r.nextInt()).toString();
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        byte[] result = sha.digest(randomNum.getBytes());
        return Utils.hexEncode(result);
    }

    private static String hexEncode(byte[] aInput) {
        StringBuffer result = new StringBuffer();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int idx = 0; idx < aInput.length; ++idx) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    public static synchronized String generateCorrelationID() {
        if (m_sequence == -1L) {
            byte[] rand = new byte[6];
            new Random().nextBytes(rand);
            String randStr = Utils.hexEncode(rand);
            try {
                m_prefix = InetAddress.getLocalHost().getHostName() + randStr;
            }
            catch (UnknownHostException e) {
                m_prefix = "localhost" + randStr;
            }
        }
        return m_prefix + Long.toHexString(++m_sequence);
    }

    public static XQEndpointConfig createTempEndpointConfig(XQEndpointConfig originalConfig, String epName, String destinationType) {
        XQEndpointConfig endpointConfig = (XQEndpointConfig)originalConfig.clone();
        endpointConfig.setName(epName);
        endpointConfig.setDestinationType(IEndpointConfig.EndpointDestinationType.fromString((String)destinationType));
        XQParametersImpl params = endpointConfig.getParameters();
        String originalEndpointDestinationType = params.getParameter("type", 1, "TOPIC");
        params.setParameter("destination", 1, epName);
        params.setParameter("type", 1, destinationType);
        params.removeParameter("messageSelector", 1);
        if (destinationType.equals("TOPIC")) {
            params.setParameter("sharedSubscriptions", 1, Boolean.FALSE.toString());
            if (params.containsParameter("durableSubscriberName", 1)) {
                params.setParameter("durableSubscriberName", 1, epName);
            }
        }
        if ("QUEUE".equals(originalEndpointDestinationType)) {
            params.setParameter("durableSubscriberName", 1, epName);
        }
        return endpointConfig;
    }

    public static XQEndpointConfig createTempEndpointConfig(XQConnectionConfig connectionConfig, String epName, String destinationType) {
        XQEndpointConfig endpointConfig = new XQEndpointConfig(null);
        endpointConfig.setEndpointType("JMSType");
        endpointConfig.setConnection(connectionConfig.getName());
        endpointConfig.setName(epName);
        endpointConfig.setDestinationType(IEndpointConfig.EndpointDestinationType.fromString((String)destinationType));
        endpointConfig.setConnectionConfig((IConnectionConfig)connectionConfig);
        XQParametersImpl params = new XQParametersImpl();
        endpointConfig.setParameters(params);
        params.setParameter("destination", 1, epName);
        params.setParameter("type", 1, destinationType);
        if (destinationType.equals("TOPIC")) {
            params.setParameter("sharedSubscriptions", 1, Boolean.FALSE.toString());
            if (Utils.isFaultTolerant(connectionConfig)) {
                params.setParameter("durableSubscriberName", 1, epName);
            }
        }
        return endpointConfig;
    }

    private static boolean isFaultTolerant(XQConnectionConfig connectionConfig) {
        Boolean faultTolerant = Boolean.FALSE;
        try {
            faultTolerant = Boolean.valueOf(connectionConfig.getParameters().getParameter("faultTolerant", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return faultTolerant;
    }

    public static boolean isFault(XQMessage msg) throws XQMessageException {
        if (msg.getPartCount() > 0 && msg.getPart(0).getContentId() != null && msg.getPart(0).getContentId() == "SonicESB.Fault") {
            return true;
        }
        return msg.containsHeader("SonicESB.Fault.Name");
    }
}

