/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.xqimpl.util.DOMUtils;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.misc.TypeConverterImpl;
import java.io.UnsupportedEncodingException;
import javax.el.ELException;
import org.w3c.dom.Element;

public class XMLParamTypeConverter
implements TypeConverter {
    public <T> T convert(Object value, Class<T> type) throws ELException {
        if (value instanceof Element) {
            return (T)this.coerceToType((Element)value, type);
        }
        return null;
    }

    private Object coerceToType(Element value, Class<?> type) {
        Object result = null;
        if (type.isInstance(value)) {
            result = value;
        }
        if (type == byte[].class) {
            result = this.coerceToByteArray(value);
        }
        if (type == String.class) {
            result = this.coerceToString(value);
        }
        if (result == null) {
            result = TypeConverterImpl.DEFAULT.convert((Object)value, type);
        }
        return result;
    }

    private String coerceToString(Element value) {
        return DOMUtils.getElementAsString((Element)value, (boolean)true);
    }

    private byte[] coerceToByteArray(Element element) {
        try {
            return DOMUtils.getContent((Element)element);
        }
        catch (UnsupportedEncodingException excp) {
            throw new ELException("Failed to convert Element to byte[]: ", (Throwable)excp);
        }
    }
}

