/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FaultNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.XQParametersImpl;

public final class RejectStepNode
extends EsbStepNode
implements FlowTerminationNode {
    private static XQMessageFactory m_factory = new XQMessageFactoryImpl();
    public static final String DEFAULT_RME_CODE = "REJECTED_BY_STEP";

    public RejectStepNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.setEndpointRef((XQAddress)new XQAbstractAddressImpl("InternalStep.Reject", 1, stepName));
    }

    @Override
    public Token execute(Token token) {
        XQAddress rmeAddress;
        boolean result;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (XQContainer.isTestContainer() && !mex.isExchangeImmediate() && (result = RunDebugUtil.execute(mex, token, this))) {
            XQMessageInternal msgInternal = (XQMessageInternal)((EsbMessageExchange)token.getData()).getInputMessage();
            return (Token)msgInternal.getSidebandProperty("TOKEN");
        }
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        boolean inFaultHandlerProcess = procInst instanceof FaultProcessInstance;
        token.tagType(Token.Type.RME);
        if (this.m_messageMapper != null) {
            mex.getXQParameters().setParent(this.m_stepParams);
            DefaultMessageMapper.mapInputMessage(this.m_messageMapper, mex);
        }
        if ((rmeAddress = procInst.getProcessInstanceProperties().getRMEAddress()) == null) {
            throw new RuntimeException("No RME addressd defined");
        }
        String rmeMessageContents = FaultNode.calculateErrorParam(mex.getInputMessage(), this.m_stepParams, "errorMessage", "Rejected by Step `" + this.toString() + "`");
        String rmeMessageCode = FaultNode.calculateErrorParam(mex.getInputMessage(), this.m_stepParams, "errorCode", DEFAULT_RME_CODE);
        this.populateXQParameters(mex);
        RMEMessage rmeMessage = null;
        try {
            rmeMessage = new RMEMessage(rmeMessageContents, rmeAddress, m_factory, mex.getInputMessage(), mex.getXQParameters(), rmeMessageCode);
            mex.setRMEMessage(rmeMessage);
        }
        catch (XQMessageException e) {
            throw new RuntimeException("Error creating RME message in throw step");
        }
        if (inFaultHandlerProcess) {
            token.unTagType(Token.Type.FAULT);
        }
        return token;
    }

    protected void populateXQParameters(EsbMessageExchange mex) {
        XQParametersImpl runtimeParams = (XQParametersImpl)mex.getXQParameters();
        runtimeParams.setParameter("SonicXQ.ContainerName", 1, XQContainer.getXQContainerName());
        runtimeParams.setParameter("SonicXQ.ApplicationName", 1, "InternalStep.Reject");
    }
}

