/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.client.ESBInteractorFactory;
import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import java.util.ArrayList;
import java.util.List;

public abstract class MessageHandler {
    protected XQParameters m_environment;
    protected XQEndpointManager m_endpointManager;
    protected XQMessageFactory m_messageFactory;
    protected EnvelopeFactory m_envelopeFactory;
    protected XQAccessorFactory m_accessorFactory;
    protected XQAddressFactory m_addressFactory;
    protected XQAddress m_rmeAddress;
    protected XQDispatch m_eventDispatcher;
    protected ESBInteractorFactory m_interactorFactory;
    protected XQLifeCycleManager m_lifeCycle;
    protected XQServiceMetrics m_metricsHelper;
    protected RejectedMessageDispatcher m_rejectedMessageDispatcher;

    protected MessageHandler() {
    }

    public void init(XQParameters environment, XQEndpointManager endpointManager, XQMessageFactory messageFactory, EnvelopeFactory envelopeFactory, XQAccessorFactory accessorFactory, XQAddressFactory addressFactory, XQAddress rmeAddress, XQDispatch dispatcher, XQLifeCycleManager lifeCycle, XQServiceMetrics metricsHelper, RejectedMessageDispatcher rejectedMessageDispatcher, ESBInteractorFactory interactorFactory) {
        this.m_environment = environment;
        this.m_endpointManager = endpointManager;
        this.m_messageFactory = messageFactory;
        this.m_envelopeFactory = envelopeFactory;
        this.m_accessorFactory = accessorFactory;
        this.m_addressFactory = addressFactory;
        this.m_rmeAddress = rmeAddress;
        this.m_eventDispatcher = dispatcher;
        this.m_lifeCycle = lifeCycle;
        this.m_metricsHelper = metricsHelper;
        this.m_rejectedMessageDispatcher = rejectedMessageDispatcher;
        this.m_interactorFactory = interactorFactory;
    }

    public abstract SendBox handleMessage(EsbMessageExchange var1) throws Throwable;

    public abstract SendBox handleMessageImmediate(EsbMessageExchange var1) throws Throwable;

    public XQAddress getRMEAddress() {
        return this.m_rmeAddress;
    }

    public XQAddress getFaultAddress() {
        return this.m_envelopeFactory == null ? null : this.m_envelopeFactory.getFaultAddress();
    }

    public static class SendBox {
        private List<XQEnvelope> m_outbox;
        private List<XQEnvelope> m_faultbox;
        private RMEMessage m_rmeMsg;

        protected SendBox(List<XQEnvelope> outbox, List<XQEnvelope> faultbox) {
            this.m_outbox = outbox;
            this.m_faultbox = faultbox;
        }

        void initializeOutFaultBoxIfNull() {
            if (this.m_outbox == null) {
                this.m_outbox = new ArrayList<XQEnvelope>();
            }
            if (this.m_faultbox == null) {
                this.m_faultbox = new ArrayList<XQEnvelope>();
            }
        }

        public List<XQEnvelope> getOutbox() {
            return this.m_outbox;
        }

        public List<XQEnvelope> getFaultbox() {
            return this.m_faultbox;
        }

        public void setRME(RMEMessage rmeMsg) {
            this.m_rmeMsg = rmeMsg;
        }

        public RMEMessage getRME() {
            return this.m_rmeMsg;
        }
    }
}

