/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Common;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.process.mapping.FaultMappingRule;
import com.sonicsw.esb.process.mapping.InputMappingRule;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingRule;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.mapping.OutputMappingRule;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageMapperSerializer {
    public static final String MSGMAPPER = "messageMapping";

    public static MessageMapper parse(Element msgMapElem) {
        DefaultMessageMapper msgMapper = new DefaultMessageMapper();
        Map nsMap = XMLUtils.getNamespaceDefinitions((Element)msgMapElem);
        msgMapper.setNamespaceMap(nsMap);
        NodeList nodes = msgMapElem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            Element elm = (Element)n;
            String elmName = elm.getLocalName();
            if ("property".equals(elmName)) {
                msgMapper.addProperty(elm.getAttribute("name"), elm.getAttribute("value"));
                continue;
            }
            if ("mapInput".equals(elmName)) {
                MessageMapperSerializer.parseRules(msgMapper, elm, 0);
                continue;
            }
            if ("mapOutput".equals(elmName)) {
                MessageMapperSerializer.parseRules(msgMapper, elm, 1);
                continue;
            }
            if (!"mapFault".equals(elmName)) continue;
            MessageMapperSerializer.parseRules(msgMapper, elm, 2);
        }
        return msgMapper;
    }

    private static void parseRules(DefaultMessageMapper msgMapper, Element mapInputElem, int type) {
        NodeList nodes = mapInputElem.getChildNodes();
        String name = mapInputElem.getAttribute("name");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            Element ruleElem = (Element)n;
            String target = ruleElem.getAttribute("target");
            String actionStr = ruleElem.getAttribute("action");
            MappingAction action = DefaultMessageMapper.stringToAction(actionStr);
            String source = ruleElem.getAttribute("source");
            String actionResource = ruleElem.getAttribute("use");
            MessageMapperSerializer.populateMapping(actionResource, type, name, msgMapper, source, target, action);
        }
    }

    public static void marshall(MessageMapper msgMapper, Writer writer) throws IOException {
        MessageMapperSerializer.marshall(msgMapper, writer, false);
    }

    public static void marshall(MessageMapper msgMapper, Writer writer, boolean includeNS) throws IOException {
        writer.write("<xq:messageMapping");
        if (includeNS) {
            writer.write(" xmlns:xq='http://www.sonicsw.com/sonicxq'");
        }
        Map<String, Namespace> nsMap = msgMapper.getNamespaceMap();
        XMLUtils.serializeNamespaceDefinitions(nsMap, (Writer)writer);
        writer.write(">");
        Properties props = msgMapper.getProperties();
        if (props != null && props.size() > 0) {
            for (Map.Entry propEntry : props.entrySet()) {
                writer.write("<xq:property name=\"" + propEntry.getKey() + "\" value=\"" + propEntry.getValue() + "\"/>");
            }
        }
        MessageMapperSerializer.marshallRules("xq:mapInput", null, msgMapper.getInputMappingRules(), writer);
        MessageMapperSerializer.marshallRules("xq:mapOutput", null, msgMapper.getOutputMappingRules(), writer);
        Map<String, MappingRuleList> faultRuleMap = msgMapper.getFaultMappingRules();
        if (faultRuleMap != null) {
            for (Map.Entry<String, MappingRuleList> entry : faultRuleMap.entrySet()) {
                MessageMapperSerializer.marshallRules("xq:mapFault", entry.getKey(), entry.getValue(), writer);
            }
        }
        Common.marshallCloseElement("xq:messageMapping", writer);
    }

    private static void marshallRules(String topElem, String key, MappingRuleList mappingRules, Writer writer) throws IOException {
        if (mappingRules != null) {
            writer.write('<' + topElem);
            if (key != null) {
                Common.marshallAttribute("name", key, writer);
            }
            writer.write(62);
            Iterator<MappingRule> iter = mappingRules.getMappingRules();
            while (iter.hasNext()) {
                MappingRule rule = iter.next();
                MessageMapperSerializer.marshallRule(rule, writer);
            }
            Common.marshallCloseElement(topElem, writer);
        }
    }

    private static void marshallRule(MappingRule rule, Writer writer) throws IOException {
        writer.write("<xq:rule source=\"" + StringEscapeUtils.escapeXml((String)rule.getSource()) + "\"");
        if (rule.getMappingAction() != null) {
            writer.write(" action=\"" + DefaultMessageMapper.actionToString(rule.getMappingAction()) + "\"");
        }
        if (rule.getMappingActionResource() != null && rule.getMappingActionResource().length > 0) {
            writer.write(" use=\"" + rule.getMappingActionResource()[0] + "\"");
        }
        writer.write(" target=\"" + rule.getTarget() + "\"/>");
    }

    public static MessageMapper parse(XMLStreamReader xsr) throws XMLStreamException {
        DefaultMessageMapper msgMapper = new DefaultMessageMapper();
        Map nsMap = XMLUtils.getNamespaceDefinitionsStax((XMLStreamReader)xsr);
        msgMapper.setNamespaceMap(nsMap);
        while (xsr.hasNext()) {
            String elemName;
            int eventType = xsr.next();
            if (eventType == 1) {
                String elmName = xsr.getLocalName();
                if ("property".equals(elmName)) {
                    msgMapper.addProperty(xsr.getAttributeValue(null, "name"), xsr.getAttributeValue(null, "value"));
                    continue;
                }
                if ("mapInput".equals(elmName)) {
                    MessageMapperSerializer.parseRules(msgMapper, xsr, 0, "mapInput", null);
                    continue;
                }
                if ("mapOutput".equals(elmName)) {
                    MessageMapperSerializer.parseRules(msgMapper, xsr, 1, "mapOutput", null);
                    continue;
                }
                if (!"mapFault".equals(elmName)) continue;
                String name = xsr.getAttributeValue(null, "name");
                MessageMapperSerializer.parseRules(msgMapper, xsr, 2, "mapFault", name);
                continue;
            }
            if (eventType != 2 || !MSGMAPPER.equals(elemName = xsr.getLocalName())) continue;
            break;
        }
        return msgMapper;
    }

    private static void parseRules(DefaultMessageMapper msgMapper, XMLStreamReader xsr, int type, String elemName, String faultName) throws XMLStreamException {
        while (xsr.hasNext()) {
            String elmName;
            int eventType = xsr.next();
            if (eventType == 1) {
                elmName = xsr.getLocalName();
                if (!"rule".equals(elmName)) continue;
                String target = xsr.getAttributeValue(null, "target");
                String actionStr = xsr.getAttributeValue(null, "action");
                MappingAction action = DefaultMessageMapper.stringToAction(actionStr);
                String source = xsr.getAttributeValue(null, "source");
                String actionResource = xsr.getAttributeValue(null, "use");
                actionResource = StringEscapeUtils.unescapeXml((String)actionResource);
                MessageMapperSerializer.populateMapping(actionResource, type, faultName, msgMapper, source, target, action);
                continue;
            }
            if (eventType != 2 || !(elmName = xsr.getLocalName()).equals(elemName)) continue;
            return;
        }
    }

    private static void populateMapping(String actionResource, int type, String faultName, DefaultMessageMapper msgMapper, String source, String target, MappingAction action) {
        String[] actionResources = new String[]{actionResource};
        if (type == 0) {
            InputMappingRule mapRule = msgMapper.createInputMappingRule(source, target, action, actionResources);
            msgMapper.addInputMapping(mapRule);
        } else if (type == 1) {
            OutputMappingRule mapRule = msgMapper.createOutputMappingRule(source, target, action, actionResources);
            msgMapper.addOutputMapping(mapRule);
        } else if (type == 2) {
            FaultMappingRule mapRule = msgMapper.createFaultMappingRule(source, target, action, actionResources);
            msgMapper.addFaultMapping(faultName, mapRule);
        }
    }

    public static Element marshallAsDOM(MessageMapper mapper, Element parentElem) {
        Map<String, MappingRuleList> faultRuleMap;
        Element mappingElement = DOMUtils.createXQElement((Document)parentElem.getOwnerDocument(), (String)MSGMAPPER);
        parentElem.appendChild(mappingElement);
        MappingRuleList mapRuleList = mapper.getInputMappingRules();
        if (mapRuleList != null) {
            MessageMapperSerializer.addMapRuleList(mappingElement, null, mapRuleList, "mapInput");
        }
        if ((mapRuleList = mapper.getOutputMappingRules()) != null) {
            MessageMapperSerializer.addMapRuleList(mappingElement, null, mapRuleList, "mapOutput");
        }
        if ((faultRuleMap = mapper.getFaultMappingRules()) != null) {
            for (Map.Entry<String, MappingRuleList> entry : faultRuleMap.entrySet()) {
                MessageMapperSerializer.addMapRuleList(mappingElement, entry.getKey(), entry.getValue(), "mapFault");
            }
        }
        return mappingElement;
    }

    private static void addMapRuleList(Element msgMapperElem, String name, MappingRuleList mapRuleList, String ruleType) {
        Element ruleListElem = DOMUtils.createXQElement((Document)msgMapperElem.getOwnerDocument(), (String)ruleType);
        if (name != null) {
            ruleListElem.setAttribute("name", name);
        }
        msgMapperElem.appendChild(ruleListElem);
        Iterator<MappingRule> rules = mapRuleList.getMappingRules();
        while (rules.hasNext()) {
            MappingRule rule = rules.next();
            Element ruleElem = DOMUtils.createXQElement((Document)msgMapperElem.getOwnerDocument(), (String)"rule");
            ruleElem.setAttribute("source", rule.getSource());
            ruleElem.setAttribute("target", rule.getTarget());
            ruleElem.setAttribute("action", DefaultMessageMapper.actionToString(rule.getMappingAction()));
            ruleElem.setAttribute("use", rule.getMappingActionResource()[0]);
            ruleListElem.appendChild(ruleElem);
        }
    }
}

