/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.BaseMappingAction;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.xqimpl.script.XFormUtil;
import net.sf.saxon.value.SequenceExtent;

public class XPathMappingAction
extends BaseMappingAction
implements MappingAction {
    @Override
    public Object doAction(Object content, String[] xpathExpression, ExpressionContext exprCtx) {
        if (xpathExpression != null && xpathExpression.length > 0) {
            if (content instanceof String) {
                try {
                    XFormUtil xFormUtil = this.getXFormUtil(exprCtx);
                    SequenceExtent xpathResult = xFormUtil.performXPath((String)content, xpathExpression[0]);
                    return xFormUtil.createStringFromXPathValue(xpathResult);
                }
                catch (MappingException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new MappingException("Error while performing [" + this.toString(content, xpathExpression[0]) + "]", e);
                }
            }
            throw new MappingException("Cannot perform XPath action on data that is not a String. Content is of type: " + content.getClass());
        }
        throw new MappingException("Error while performing XPath action as xpath expression is null");
    }

    private String toString(Object content, String xpathExpression) {
        return "XPath with expression `" + xpathExpression + "` for " + content;
    }

    public String toString() {
        return "XPath";
    }
}

