/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.process.model.Action;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Properties;

public class PopulateProcCtxAction
implements Action {
    public static final String MESSAGE_ID = "MessageID";
    public static final String CORRELATION_ID = "CorrelationID";
    public static final String REPLY_TO = "ReplyTo";
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);

    @Override
    public void execute(Token token, Action.Type type, ActivityNode targetNode, ActivityEdge targetEdge) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.isSubProcess() || procInst instanceof FaultProcessInstance) {
            return;
        }
        Properties inflightProps = procInst.getProcessInstanceProperties().createInflightPropsIfNull();
        XQMessage msg = ((EsbMessageExchange)token.getData()).getInputMessage();
        try {
            XQAddress replyToAddr;
            inflightProps.setProperty(MESSAGE_ID, (String)msg.getHeaderValue("JMSMessageID"));
            String correlationID = msg.getCorrelationId();
            if (correlationID != null) {
                inflightProps.setProperty(CORRELATION_ID, correlationID);
            }
            if ((replyToAddr = msg.getReplyTo()) != null) {
                inflightProps.setProperty(REPLY_TO, replyToAddr.getName());
            }
        }
        catch (XQMessageException e) {
            s_log.logWarning("Error setting default process context properties");
            s_log.logDebug((Throwable)e);
        }
    }
}

