/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.jeri.esb;

import com.sonicsw.esb.jeri.DebugDestination;
import com.sonicsw.esb.jeri.DebugEndpoint;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.Part;
import progress.message.jimpl.Message;

public final class ESBServerEndpoint
implements ServerEndpoint {
    private static XQLog log = XQLogImpl.getCategoryLog((int)128);
    private String m_jeriUUID;
    private String m_correlationID;
    private MessagingBean m_bean = null;
    private static final MessageListener m_esbMessageListener = new ESBMessageListener();
    private static Map m_invocationTable = new Hashtable();

    public ESBServerEndpoint(JMSEndpoint entryEndpoint, String uuid) {
        String connectionName = entryEndpoint.getConnectionName();
        this.m_bean = (MessagingBean)EndpointManager.getInstance().getConnection(connectionName);
        this.m_jeriUUID = uuid;
        this.m_correlationID = "" + this.hashCode();
        log.logDebug("ESB Debug Server initialized");
    }

    public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        return InvocationConstraints.EMPTY;
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        try {
            ESBListenEndpoint listenEndpoint = new ESBListenEndpoint();
            ESBListenHandle listenCookie = (ESBListenHandle)listenContext.addListenEndpoint((ServerEndpoint.ListenEndpoint)listenEndpoint);
            return new DebugEndpoint(new DebugDestination(listenCookie.getListenerDestination()), this.m_jeriUUID, this.m_correlationID);
        }
        catch (JMSException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private class ESBListenEndpoint
    implements ServerEndpoint.ListenEndpoint {
        ESBListenEndpoint() {
        }

        public void checkPermissions() {
        }

        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            try {
                return new ESBListenHandle(requestDispatcher);
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private class ESBListenHandle
    implements ServerEndpoint.ListenHandle,
    ServerEndpoint.ListenCookie {
        private String m_sessionName;
        private MessageConsumer m_consumer;
        private Destination m_replyDestination;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ESBListenHandle(RequestDispatcher requestDispatcher) throws Exception {
            this.m_sessionName = ESBServerEndpoint.this.m_bean.getSessionFromPool("ESB_DEBUG_SERVER_SESSION_POOL", 0L);
            try {
                this.m_replyDestination = ESBServerEndpoint.this.m_bean.getTempDestFromPool("ESB_DEBUG_SERVER_SESSION_POOL", this.m_sessionName);
                this.m_consumer = ESBServerEndpoint.this.m_bean.getTempConsumerFromPool("ESB_DEBUG_SERVER_SESSION_POOL", this.m_sessionName);
                MessageListener listener = this.m_consumer.getMessageListener();
                if (listener == null) {
                    this.m_consumer.setMessageListener(m_esbMessageListener);
                }
                InvocationState state = new InvocationState();
                state.bean = ESBServerEndpoint.this.m_bean;
                state.dispatcher = requestDispatcher;
                state.sessionName = this.m_sessionName;
                m_invocationTable.put(ESBServerEndpoint.this.m_correlationID, state);
            }
            finally {
                ESBServerEndpoint.this.m_bean.returnSessionToPool(this.m_sessionName);
            }
        }

        public Destination getListenerDestination() {
            return this.m_replyDestination;
        }

        public void close() {
            m_invocationTable.remove(ESBServerEndpoint.this.m_correlationID);
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return this;
        }
    }

    private static class ESBMessageListener
    implements MessageListener {
        ESBMessageListener() {
        }

        public void onMessage(final javax.jms.Message m) {
            String invocationUUID = null;
            try {
                m.acknowledge();
                if (!m.propertyExists("SonicESB.CORRELATION_ID")) {
                    return;
                }
                invocationUUID = m.getStringProperty("SonicESB.CORRELATION_ID");
                final InvocationState state = (InvocationState)m_invocationTable.get(invocationUUID);
                if (state == null) {
                    return;
                }
                if (m.propertyExists("SonicESB.PING_REQUEST_PROP")) {
                    Destination pingReply = m.getJMSReplyTo();
                    Message pingReplyMsg = new Message();
                    state.bean.produceMessageWithUnbound(pingReply, (javax.jms.Message)pingReplyMsg, 1, 4, 0L, state.sessionName, null);
                    return;
                }
                byte[] request = null;
                if (m instanceof BytesMessage) {
                    BytesMessage bm = (BytesMessage)m;
                    request = new byte[(int)bm.getBodyLength()];
                    bm.readBytes(request);
                } else if (m instanceof MultipartMessage) {
                    MultipartMessage mm = (MultipartMessage)m;
                    Part p = mm.getPart(0);
                    if (p != null) {
                        request = p.getContentBytes();
                    }
                } else {
                    log.logError("Error: Debug communication received a non-recognized message type");
                    return;
                }
                final ESBInboundRequest inRqst = new ESBInboundRequest(new ByteArrayInputStream(request));
                new Thread(){

                    @Override
                    public void run() {
                        state.dispatcher.dispatch((InboundRequest)inRqst);
                        try {
                            Destination replyTo = m.getJMSReplyTo();
                            if (replyTo != null) {
                                ByteArrayOutputStream bos = (ByteArrayOutputStream)inRqst.getResponseOutputStream();
                                progress.message.jimpl.BytesMessage respMsg = new progress.message.jimpl.BytesMessage();
                                respMsg.writeBytes(bos.toByteArray());
                                state.bean.produceMessageWithUnbound(replyTo, (javax.jms.Message)respMsg, 1, 4, 0L, state.sessionName, null);
                            }
                        }
                        catch (Exception e) {
                            log.logDebug((Throwable)e);
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                log.logDebug((Throwable)e);
            }
        }
    }

    private static class ESBInboundRequest
    implements InboundRequest {
        private InputStream m_in;
        private ByteArrayOutputStream m_out = new ByteArrayOutputStream();

        ESBInboundRequest(InputStream stream) {
            this.m_in = stream;
        }

        public void checkPermissions() {
        }

        public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
            return InvocationConstraints.EMPTY;
        }

        public void populateContext(Collection context) {
        }

        public InputStream getRequestInputStream() {
            return this.m_in;
        }

        public OutputStream getResponseOutputStream() {
            return this.m_out;
        }

        public void abort() {
        }
    }

    private class InvocationState {
        String sessionName;
        RequestDispatcher dispatcher;
        MessagingBean bean;

        private InvocationState() {
        }
    }
}

