/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.common;

import com.sonicsw.xq.service.common.RoutingRule;
import com.sonicsw.xqimpl.util.ClassUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import modelobjects.template.ParsedTemplate;
import modelobjects.template.TemplateProcessor;
import modelobjects.util.NewlineFixerFilterWriter;
import org.apache.axis.utils.DOM2Writer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RulesSpec {
    public static final String DEFAULT_HELPER_FILE = "sonicfs:///System/SonicESB/jsHelperFunctions.js";
    private String declarations;
    private String[] helperFileURLs;
    private RoutingRule[] routingRules;
    private static final String TEMPLATE_FILE = "com/sonicsw/xqimpl/service/cbr/CBRRules.template";
    protected static final String RULE_NS_URI = "http://www.sonicsw.com/rule";
    protected static final String RULE_PREFIX = "rule:";
    protected static final String RULESPEC_ELEM = "ruleSpec";
    protected static final String RULE_ELEM = "routingRule";
    protected static final String CONDITION_ELEM = "condition";
    protected static final String ENDPOINT_ELEM = "endpoint";
    protected static final String DECLARATIONS_ELEM = "declarations";
    protected static final String HELPER_FILE_ELEM = "helperFile";
    protected static final String HELPER_URL_ATTR = "url";
    protected static final String ENDPOINT_REF_ATTR = "endpoint_ref";
    protected static final String ENDPOINT_TYPE_ATTR = "type";

    static String[] getInitialDefaultHelperFiles() {
        return new String[]{DEFAULT_HELPER_FILE};
    }

    public RulesSpec() {
        this(RulesSpec.getInitialDefaultHelperFiles(), "", new RoutingRule[0]);
    }

    public RulesSpec(String[] helperFileURLs, String declarations, RoutingRule[] routingRules) {
        this.helperFileURLs = (String[])ClassUtils.arrayCopy((Object[])helperFileURLs);
        this.declarations = declarations;
        this.routingRules = (RoutingRule[])ClassUtils.arrayCopy((Object[])routingRules);
    }

    public RulesSpec(Element domTree) {
        DomTreeTranslator translator = new DomTreeTranslator(domTree);
        translator.translateDomTree(this);
    }

    public Element toDOM() {
        DomTreeBuilder treeBuilder = new DomTreeBuilder(this.declarations, this.routingRules, this.helperFileURLs);
        return treeBuilder.buildDomTree();
    }

    public String toXMLSource() {
        try {
            StringWriter writer = new StringWriter();
            DOM2Writer.serializeAsXML((Node)this.toDOM(), (Writer)writer, (boolean)true, (boolean)true);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJavaScript() throws IOException {
        if (!(this.routingRules != null && this.routingRules.length != 0 || this.declarations != null && this.declarations.length() != 0)) {
            return null;
        }
        ParsedTemplate template = new ParsedTemplate(TEMPLATE_FILE);
        StringWriter stringWriter = new StringWriter();
        NewlineFixerFilterWriter writer = new NewlineFixerFilterWriter(stringWriter);
        PrintWriter outputSink = new PrintWriter(writer);
        TemplateProcessor templateProcessor = new TemplateProcessor(template, outputSink, this);
        templateProcessor.setTypeCheckingEnabled(true);
        TemplateProcessor.setStackTraceOnErrorEnabled(true);
        templateProcessor.processTemplate();
        outputSink.close();
        return stringWriter.toString();
    }

    public String getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(String declarations) {
        this.declarations = declarations;
    }

    public String[] getHelperFileURLs() {
        return this.helperFileURLs;
    }

    public void setHelperFileURLs(String[] helperFileURLs) {
        this.helperFileURLs = helperFileURLs;
    }

    public RoutingRule[] getRoutingRules() {
        return this.routingRules;
    }

    public void setRoutingRules(RoutingRule[] routingRules) {
        this.routingRules = routingRules;
    }

    private static class DomTreeTranslator {
        private ArrayList<String> helpersList = new ArrayList();
        private ArrayList<RoutingRule> rulesList = new ArrayList();
        private Element ruleSetElem;

        DomTreeTranslator(Element ruleSetElem) {
            this.ruleSetElem = ruleSetElem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void translateDomTree(RulesSpec rulesSpec) throws DOMException {
            String declarations = null;
            Element element = this.ruleSetElem;
            synchronized (element) {
                String tagName = this.ruleSetElem.getTagName();
                if (!this.isTag(tagName, RulesSpec.RULESPEC_ELEM)) {
                    throw new IllegalArgumentException("not a ruleSpec element");
                }
                NodeList childNodeList = this.ruleSetElem.getChildNodes();
                int num = childNodeList.getLength();
                for (int i = 0; i < num; ++i) {
                    Node childNode = childNodeList.item(i);
                    if (!(childNode instanceof Element)) continue;
                    Element childElem = (Element)childNode;
                    String childTag = childElem.getTagName();
                    if (this.isTag(childTag, RulesSpec.DECLARATIONS_ELEM)) {
                        childElem.normalize();
                        NodeList declChildren = childElem.getChildNodes();
                        if (declChildren.getLength() != 1) continue;
                        declarations = declChildren.item(0).getNodeValue();
                        continue;
                    }
                    if (this.isTag(childTag, RulesSpec.HELPER_FILE_ELEM)) {
                        this.helpersList.add(childElem.getAttribute(RulesSpec.HELPER_URL_ATTR));
                        continue;
                    }
                    if (this.isTag(childTag, RulesSpec.RULE_ELEM)) {
                        this.rulesList.add(this.translateRuleElement(childElem));
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected element: " + childTag);
                }
            }
            String[] helperFileURLs = new String[this.helpersList.size()];
            this.helpersList.toArray(helperFileURLs);
            RoutingRule[] routingRules = new RoutingRule[this.rulesList.size()];
            this.rulesList.toArray(routingRules);
            rulesSpec.setHelperFileURLs(helperFileURLs);
            rulesSpec.setDeclarations(declarations);
            rulesSpec.setRoutingRules(routingRules);
        }

        RoutingRule translateRuleElement(Element ruleElem) {
            NodeList conditionNodeList = ruleElem.getElementsByTagNameNS(RulesSpec.RULE_NS_URI, RulesSpec.CONDITION_ELEM);
            NodeList endpoingNodeList = ruleElem.getElementsByTagNameNS(RulesSpec.RULE_NS_URI, RulesSpec.ENDPOINT_ELEM);
            Element conditionElem = (Element)conditionNodeList.item(0);
            Element endpointElem = (Element)endpoingNodeList.item(0);
            conditionElem.normalize();
            String condition = conditionElem.getChildNodes().item(0).getNodeValue();
            String endpointName = endpointElem.getAttribute(RulesSpec.ENDPOINT_REF_ATTR);
            String endpointKind = endpointElem.getAttribute(RulesSpec.ENDPOINT_TYPE_ATTR);
            int endpointCode = 0;
            if (endpointKind.equals("SERVICE")) {
                endpointCode = 1;
            } else if (endpointKind.equals("PROCESS")) {
                endpointCode = 2;
            } else if (endpointKind.equals("REPLY_TO")) {
                endpointCode = 3;
            }
            RoutingRule rule = new RoutingRule(condition, endpointName, endpointKind, endpointCode);
            return rule;
        }

        private boolean isTag(String elementTagName, String unqualifiedName) {
            return elementTagName.equals(unqualifiedName) || elementTagName.endsWith(":" + unqualifiedName);
        }
    }

    public static class DomTreeBuilder {
        private String declarations;
        private RoutingRule[] routingRules;
        private String[] helperFileURLs;

        DomTreeBuilder(String declarations, RoutingRule[] routingRules, String[] helperFileURLs) {
            this.declarations = declarations;
            this.routingRules = routingRules;
            this.helperFileURLs = helperFileURLs;
        }

        public Element buildDomTree() throws DOMException {
            Document document = DOMUtils.createDocument();
            Element rootElement = document.createElementNS(RulesSpec.RULE_NS_URI, "rule:ruleSpec");
            document.appendChild(rootElement);
            int numHelperFiles = this.helperFileURLs == null ? 0 : this.helperFileURLs.length;
            for (int i = 0; i < numHelperFiles; ++i) {
                String helperFileURL = this.helperFileURLs[i];
                if (helperFileURL == null || "".equals(helperFileURL)) continue;
                Element helperFileElem = document.createElementNS(RulesSpec.RULE_NS_URI, "rule:helperFile");
                helperFileElem.setAttribute(RulesSpec.HELPER_URL_ATTR, helperFileURL);
                rootElement.appendChild(helperFileElem);
            }
            if (this.declarations != null) {
                Element declElem = document.createElementNS(RulesSpec.RULE_NS_URI, "rule:declarations");
                declElem.appendChild(document.createTextNode(this.declarations));
                rootElement.appendChild(declElem);
            }
            int numRules = this.routingRules == null ? 0 : this.routingRules.length;
            for (int i = 0; i < numRules; ++i) {
                RoutingRule rule = this.routingRules[i];
                String conditionExpr = rule.getConditionExpression();
                String endpointName = rule.getEndpointName();
                String endpointKind = rule.getEndpointKind();
                if (conditionExpr == null || "".equals(conditionExpr) || endpointName == null || "".equals(endpointName) || endpointKind == null || "".equals(endpointKind)) continue;
                Element conditionElem = document.createElementNS(RulesSpec.RULE_NS_URI, "rule:condition");
                conditionElem.appendChild(document.createTextNode(conditionExpr));
                Element endpointElem = document.createElementNS(RulesSpec.RULE_NS_URI, "rule:endpoint");
                endpointElem.setAttribute(RulesSpec.ENDPOINT_REF_ATTR, endpointName);
                endpointElem.setAttribute(RulesSpec.ENDPOINT_TYPE_ATTR, endpointKind);
                Element ruleElem = document.createElementNS(RulesSpec.RULE_NS_URI, "rule:routingRule");
                ruleElem.appendChild(conditionElem);
                ruleElem.appendChild(endpointElem);
                rootElement.appendChild(ruleElem);
            }
            return rootElement;
        }
    }
}

