/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.esb.jeri.esb.ESBPreferredEndpointTracker;
import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.RunContext;
import com.sonicsw.esb.run.RunDisconnectException;
import com.sonicsw.esb.run.RunRuntimeException;
import com.sonicsw.esb.run.RunTimeoutException;
import com.sonicsw.esb.run.handlers.scriptengine.impl.ParameterValuesReferenceImpl;
import com.sonicsw.esb.run.handlers.scriptengine.impl.ScriptEngineLocationImpl;
import com.sonicsw.esb.run.handlers.scriptengine.impl.ScriptEngineUtil;
import com.sonicsw.esb.run.handlers.scriptengine.impl.VariableValuesReferenceImpl;
import com.sonicsw.esb.run.impl.LocationContext;
import com.sonicsw.esb.run.impl.util.PreferredExporterFactory;
import com.sonicsw.esb.run.util.XQMessageUtil;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.script.ExtractedValue;
import com.sonicsw.xqimpl.script.ExtractionRules;
import com.sonicsw.xqimpl.script.ICommand;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.IScriptCommand;
import com.sonicsw.xqimpl.script.InsertionRules;
import com.sonicsw.xqimpl.script.Namespaces;
import com.sonicsw.xqimpl.script.Parameter;
import com.sonicsw.xqimpl.script.ParameterConstants;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ParameterValueFactory;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.Variable;
import com.sonicsw.xqimpl.script.VariableValue;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Command
implements ICommand {
    private ExtractionRules m_extractionRules;
    private InsertionRules m_insertionRules;
    private ScriptObject m_script;
    private XQMessage m_message;
    private ParameterConstants m_parameterConstants;
    private Namespaces m_namespaces;
    public static final String CURRENT_VERSION = "1.0";
    private static XQLog log = XQLogImpl.getCategoryLog((int)64);
    private String m_encoding = null;
    private RunContext m_runContext = null;
    private String m_jeriUUID = null;
    private String m_name = null;
    private static ThreadLocal m_command = new ThreadLocal();

    public static Command getCommand() {
        return (Command)m_command.get();
    }

    public Command(XQMessage message, XQParameters params, ScriptObject object) throws XQMessageException, ScriptEngineException {
        String command = null;
        Element commandElm = null;
        if (message.containsHeader("command")) {
            command = message.getStringHeader("command");
            log.logDebug("Retrieved command from property");
            try {
                commandElm = DOMUtils.getDocumentBuilder().parse(new InputSource(new StringReader(command))).getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                ScriptEngineException se = new ScriptEngineException(e.getMessage(), 1);
                se.setLinkedException(e);
                throw se;
            }
            catch (SAXException e) {
                throw Util.createParserException(e, command);
            }
            catch (IOException e) {
                ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
                se.setLinkedException(e);
                throw se;
            }
        } else {
            if (message instanceof XQMessageInternal) {
                commandElm = (Element)((XQMessageInternal)message).removeSidebandProperty("ScriptCommandElement");
            }
            if (commandElm == null) {
                commandElm = (Element)params.getParameterObject("command", 2);
            }
            log.logDebug("Retrieved command from runtime parameters");
        }
        this.m_script = object;
        this.deserializeCommand(commandElm);
        this.m_message = message;
        if (this.m_name == null) {
            this.m_name = object.getURL();
        }
        this.m_runContext = XQMessageUtil.getRunContextFromMessage(this.m_message);
        this.m_jeriUUID = XQMessageUtil.getUUIDFromMessage(this.m_message);
    }

    public Command(String commandXML, ScriptObject engine) throws ScriptEngineException {
        try {
            Element commandElm = DOMUtils.getDocumentBuilder().parse(new InputSource(new StringReader(commandXML))).getDocumentElement();
            this.m_script = engine;
            this.deserializeCommand(commandElm);
            if (this.m_name == null) {
                this.m_name = engine.getURL();
            }
        }
        catch (ScriptEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw Util.createParserException(e, commandXML);
        }
    }

    @Override
    public XQMessage getXQMessage() {
        return this.m_message;
    }

    public RunContext getRunContext() {
        return this.m_runContext;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    private void deserializeCommand(Element commandElm) throws ScriptEngineException {
        Element insertElm;
        String version = commandElm.getAttribute("version");
        if ("".equals(version)) {
            version = CURRENT_VERSION;
        }
        if (!CURRENT_VERSION.equals(version)) {
            throw new ScriptEngineException("unsupported-verson", new Object[]{new Integer(version)}, 1);
        }
        String name = commandElm.getAttribute("name");
        if (name != null && !"".equals(name)) {
            this.m_name = name;
        }
        this.deserializeNamespaces(commandElm);
        this.m_parameterConstants = new ParameterConstants(commandElm);
        this.m_encoding = (String)this.m_parameterConstants.getParameterConstantsMap().get("byte_array_encoding");
        if (this.m_encoding != null && this.m_encoding.length() == 0) {
            this.m_encoding = null;
        }
        this.m_script.setEncoding(this.m_encoding);
        Element extractElm = DOMUtils.getImmediateChildElementByName((Element)commandElm, (String)"extractionRules");
        if (extractElm != null) {
            this.m_extractionRules = new ExtractionRules(extractElm, this.m_namespaces, this.m_encoding);
            this.m_extractionRules.validateVariables(this.m_script.getVariableMap());
            log.logDebug("Command Extraction rules unmarshalled and validated");
        }
        if ((insertElm = DOMUtils.getImmediateChildElementByName((Element)commandElm, (String)"insertionRules")) != null) {
            this.m_insertionRules = new InsertionRules(this.m_script, this.m_namespaces, insertElm);
            this.m_insertionRules.validateVariables(this.m_script.getVariableMap());
            log.logDebug("Command Insertion rules unmarshalled and validated");
        }
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    private void deserializeNamespaces(Element commandElm) throws ScriptEngineException {
        try {
            Element tempEl = DOMUtils.getImmediateChildElementByName((Element)commandElm, (String)"nameSpaces");
            if (tempEl == null) {
                return;
            }
            this.m_namespaces = new Namespaces(tempEl);
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    public HashMap getParameterConstants() {
        return this.m_parameterConstants.getParameterConstantsMap();
    }

    ScriptObject getScript() {
        return this.m_script;
    }

    public ExtractedValue getVariableValue(String name) throws ScriptEngineException, XQMessageException {
        if (this.m_extractionRules != null) {
            return this.m_extractionRules.getVariableValue(name, this.m_message);
        }
        return null;
    }

    public void execute() throws Exception {
        m_command.set(this);
        List values = this.executeScriptCommand();
        Map outputVariables = this.getOutputVariableValues(values);
        this.processVariableTestLocation(outputVariables, 3);
        this.consumeParts(this.m_message);
        if (outputVariables != null) {
            this.insertVariables(outputVariables, this.m_message);
        }
        m_command.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeScriptCommand() throws Exception {
        HashMap mergedMap = (HashMap)this.m_script.getParameterConstants().clone();
        mergedMap.put("com_sonicsw_xqimpl_invk_ESBConstants_Command", this);
        mergedMap.putAll(this.getParameterConstants());
        boolean loadDTDs = true;
        String loadDTDsValue = (String)mergedMap.get("load_external_dtds");
        if (loadDTDsValue != null) {
            loadDTDs = Boolean.valueOf(loadDTDsValue);
        }
        IScriptCommand scriptCommand = this.m_script.getScriptCommand();
        scriptCommand.setParameterValueFactory(new ParameterValueFactory(loadDTDs, this.m_encoding));
        scriptCommand.setScriptObject(this.m_script);
        List parameters = this.getInputParameterValues();
        Location scriptLocation = this.pushRunDebugLocation(1);
        List values = null;
        try {
            this.processParameterTestLocation(parameters, scriptLocation);
            log.logDebug("Invoking script command");
            values = this.m_script.getScriptCommand().execute(parameters, mergedMap);
        }
        finally {
            this.popRunDebugLocation();
        }
        this.setParameterInfo(values);
        scriptLocation = this.pushRunDebugLocation(2);
        try {
            this.processParameterTestLocation(values, scriptLocation);
        }
        finally {
            this.popRunDebugLocation();
        }
        return values;
    }

    public Location pushRunDebugLocation(int locationType) {
        RunContext runContext;
        if (XQContainer.isTestContainer() && (runContext = this.getRunContext()) != null && this.m_name != null) {
            ScriptEngineLocationImpl testLocation = new ScriptEngineLocationImpl(this.m_name, locationType);
            runContext.push(testLocation);
            return testLocation;
        }
        return null;
    }

    public void popRunDebugLocation() {
        RunContext runContext;
        if (XQContainer.isTestContainer() && (runContext = this.getRunContext()) != null && this.m_name != null) {
            runContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processParameterTestLocation(List parameters, Location testLocation) {
        block8: {
            if (XQContainer.isTestContainer()) {
                try {
                    RunContext runContext = this.getRunContext();
                    PreferredExporterFactory exporterFactory = null;
                    if (runContext == null || this.m_name == null) break block8;
                    exporterFactory = new PreferredExporterFactory(ESBPreferredEndpointTracker.getInstance(), this.m_jeriUUID);
                    ParameterValuesReferenceImpl remoteParameters = ScriptEngineUtil.createRemoteParametersReference(parameters, testLocation, exporterFactory);
                    remoteParameters.export();
                    try {
                        LocationContext context = new LocationContext(testLocation, remoteParameters, exporterFactory, runContext);
                        context.setRemoteLocationData(remoteParameters);
                        runContext.process(context);
                    }
                    finally {
                        remoteParameters.unexport();
                    }
                }
                catch (RunDisconnectException e) {
                    log.logDebug((Throwable)e);
                    throw new RunRuntimeException(e);
                }
                catch (RunTimeoutException e) {
                    log.logError("Timeout attempting to contact the test client.  The invocation was cancelled.");
                    throw new RunRuntimeException(e);
                }
                catch (Exception e) {
                    log.logError("Error in invocation session: " + e.getMessage() + ". The invocation was canceled.");
                    throw new RunRuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processVariableTestLocation(Map variables, int location) {
        block11: {
            if (XQContainer.isTestContainer()) {
                RunContext runContext = this.getRunContext();
                PreferredExporterFactory exporterFactory = null;
                try {
                    if (runContext == null || this.m_name == null) break block11;
                    ScriptEngineLocationImpl testLocation = new ScriptEngineLocationImpl(this.m_name, location);
                    exporterFactory = new PreferredExporterFactory(ESBPreferredEndpointTracker.getInstance(), this.m_jeriUUID);
                    VariableValuesReferenceImpl remoteVariables = ScriptEngineUtil.createRemoteVariablesReference(variables, testLocation, exporterFactory);
                    remoteVariables.export();
                    try {
                        LocationContext context = new LocationContext(testLocation, remoteVariables, exporterFactory, runContext);
                        context.setRemoteLocationData(remoteVariables);
                        runContext.push(testLocation);
                        try {
                            runContext.process(context);
                        }
                        finally {
                            runContext.pop();
                        }
                    }
                    finally {
                        remoteVariables.unexport();
                    }
                }
                catch (RunDisconnectException e) {
                    log.logDebug((Throwable)e);
                    throw new RunRuntimeException(e);
                }
                catch (RunTimeoutException e) {
                    log.logError("Timeout attempting to contact the test client.  The invocation was cancelled.");
                    log.logDebug((Throwable)e);
                    throw new RunRuntimeException(e);
                }
                catch (Exception e) {
                    log.logError("Error in invocation session: " + e.getMessage() + ". The invocation was canceled");
                    log.logDebug((Throwable)e);
                    throw new RunRuntimeException(e);
                }
            }
        }
    }

    private List getParameters() {
        return this.m_script.getScriptCommand().getParameters();
    }

    public List getInputParameterValues() throws ScriptEngineException, XQMessageException {
        List parameters = this.getParameters();
        if (parameters != null) {
            ArrayList<IParameterValue> result = new ArrayList<IParameterValue>();
            for (Parameter p : parameters) {
                if (p.getDirection() == ParameterDirection.IN || p.getDirection() == ParameterDirection.INOUT) {
                    IParameterValue value = this.m_script.getParameterValue(p.getName(), p.getBaseType(), this);
                    if (value == null) continue;
                    value.setDisplayType(p.getDisplayType());
                    value.setDirection(p.getDirection());
                    result.add(value);
                    log.logDebug("Created Input parameter name=" + value.getParamName() + ", value=" + value.getAsString() + ", direction=" + p.getDirection());
                    continue;
                }
                ParameterValueFactory factory = this.getScript().getScriptCommand().getParameterValueFactory();
                IParameterValue value = factory.createParameterValue(p.getName(), p.getBaseType(), (String)null);
                value.setDisplayType(p.getDisplayType());
                value.setDirection(p.getDirection());
                result.add(value);
                log.logDebug("Created Input parameter name=" + value.getParamName() + ", direction=" + p.getDirection());
            }
            return result;
        }
        return null;
    }

    public void setParameterInfo(List parameters) {
        if (parameters != null) {
            Map map = this.m_script.getScriptCommand().getOutParameterMap();
            for (IParameterValue p : parameters) {
                Parameter param = (Parameter)map.get(p.getParamName());
                if (param == null) continue;
                p.setDirection(param.getDirection());
                p.setDisplayType(param.getDisplayType());
            }
        }
    }

    public void insertVariables(Map outputVariables, XQMessage msg) throws ScriptEngineException, XQMessageException {
        if (this.m_insertionRules != null) {
            this.m_insertionRules.insertVariables(outputVariables, msg);
        }
    }

    public void consumeParts(XQMessage msg) throws ScriptEngineException, XQMessageException {
        if (this.m_extractionRules != null) {
            this.m_extractionRules.consumeParts(msg);
        }
    }

    public Map getOutputVariableValues(List outputParms) throws ScriptEngineException {
        if (outputParms == null) {
            return null;
        }
        HashMap<String, VariableValue> map = new HashMap<String, VariableValue>();
        for (IParameterValue pvalue : outputParms) {
            Variable var;
            VariableValue vvalue = this.m_script.getVariableValue(pvalue);
            if (vvalue == null) continue;
            Map varMap = this.m_script.getVariableMap();
            if (varMap != null && (var = (Variable)varMap.get(vvalue.getVariableName())) != null) {
                vvalue.setDisplayType(var.getType());
            }
            map.put(vvalue.getVariableName(), vvalue);
            log.logDebug("Creating output variable name=" + vvalue.getVariableName() + ", parameter name=" + pvalue.getParamName());
        }
        return map;
    }

    public boolean hasInsertionRules() {
        return this.m_insertionRules != null && this.m_insertionRules.hasInsertionRules();
    }

    public boolean hasExtractionRules() {
        return this.m_extractionRules != null && this.m_extractionRules.hasExtractionRules();
    }
}

