/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.aspects;

import com.sonicsw.esb.aspects.AspectsConfigBean;
import com.sonicsw.esb.aspects.DynamicPointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SonicAspectsDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAspectJAutoProxyCreatorIfNecessary((ParserContext)parserContext, null);
        AbstractBeanDefinition configBean = this.createAspectsConfig(element, parserContext);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)configBean);
        RootBeanDefinition dynamicPointcut = this.createDynamicPointcutDefinition(configBean);
        String pointcutRef = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)dynamicPointcut);
        String adviseRef = this.createAdviseBeanReference(element, parserContext);
        RootBeanDefinition advisor = this.createAdvisorDefinition(element, parserContext, pointcutRef, adviseRef);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)advisor);
        return null;
    }

    protected AbstractBeanDefinition createAspectsConfig(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder def = BeanDefinitionBuilder.rootBeanDefinition(AspectsConfigBean.class);
        if (element.hasAttribute("serviceName")) {
            def.addPropertyValue("serviceName", (Object)element.getAttribute("serviceName"));
        }
        if (element.hasAttribute("processName")) {
            def.addPropertyValue("processName", (Object)element.getAttribute("processName"));
        }
        if (element.hasAttribute("stepName")) {
            def.addPropertyValue("stepName", (Object)element.getAttribute("stepName"));
        }
        if (element.hasAttribute("interceptorClass")) {
            def.addPropertyValue("interceptorClass", (Object)element.getAttribute("interceptorClass"));
        }
        if (element.hasAttribute("order")) {
            def.addPropertyValue("order", (Object)element.getAttribute("order"));
        }
        return def.getBeanDefinition();
    }

    protected RootBeanDefinition createPointcutDefinition(String expression) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(AspectJExpressionPointcut.class);
        beanDefinition.setScope("prototype");
        beanDefinition.setSynthetic(true);
        beanDefinition.getPropertyValues().addPropertyValue("expression", (Object)expression);
        return beanDefinition;
    }

    protected RootBeanDefinition createDynamicPointcutDefinition(AbstractBeanDefinition configDef) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(DynamicPointcut.class);
        beanDefinition.setScope("singleton");
        beanDefinition.setSynthetic(true);
        ConstructorArgumentValues cav = beanDefinition.getConstructorArgumentValues();
        cav.addIndexedArgumentValue(0, (Object)configDef);
        return beanDefinition;
    }

    private RootBeanDefinition createAdvisorDefinition(Element advisorElement, ParserContext parserContext, String pointcutRef, String adviceRef) {
        RootBeanDefinition advisorDefinition = new RootBeanDefinition(DefaultBeanFactoryPointcutAdvisor.class);
        advisorDefinition.setScope("singleton");
        advisorDefinition.getPropertyValues().addPropertyValue("adviceBeanName", (Object)new RuntimeBeanNameReference(adviceRef));
        if (advisorElement.hasAttribute("order")) {
            advisorDefinition.getPropertyValues().addPropertyValue(new PropertyValue("order", (Object)advisorElement.getAttribute("order")));
        }
        advisorDefinition.getPropertyValues().addPropertyValue("pointcut", (Object)new RuntimeBeanReference(pointcutRef));
        return advisorDefinition;
    }

    private String createAdviseBeanReference(Element element, ParserContext parserContext) {
        if (element.hasAttribute("interceptorClass") && element.hasAttribute("interceptorRef")) {
            parserContext.getReaderContext().error("Cannot define both 'interceptorClass' and 'interceptorRef' on <" + element.getLocalName() + " > tag.", (Object)element);
            return null;
        }
        if (element.hasAttribute("interceptorClass")) {
            String classname = element.getAttribute("interceptorClass");
            RootBeanDefinition adviseDefinition = new RootBeanDefinition(classname, new ConstructorArgumentValues(), new MutablePropertyValues());
            adviseDefinition.setScope("singleton");
            String adviseRef = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)adviseDefinition);
            return adviseRef;
        }
        if (element.hasAttribute("interceptorRef")) {
            String adviseRef = element.getAttribute("interceptorRef");
            return adviseRef;
        }
        parserContext.getReaderContext().error("Must define one of 'interceptorClass' or 'interceptorRef' on <" + element.getLocalName() + " > tag.", (Object)element);
        return null;
    }
}

