/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.continuation;

import com.sonicsw.esb.itinerary.continuation.FaultItineraryContinuation;
import com.sonicsw.esb.itinerary.continuation.ItineraryContinuation;
import com.sonicsw.esb.itinerary.continuation.ItineraryRuntimeInfo;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQFaultProcessContinuation;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQProcessContinuationHandler;
import com.sonicsw.xq.XQRuntimeProcess;
import com.sonicsw.xq.XQServiceContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.axis.encoding.Base64;
import org.apache.axis.utils.ByteArrayOutputStream;

public class MsgHeaderContinuationHandler
implements XQProcessContinuationHandler {
    private String m_headerName = "JMSCorrelationID";

    public MsgHeaderContinuationHandler() {
    }

    public MsgHeaderContinuationHandler(String headerName) {
        this.m_headerName = headerName;
    }

    public void save(XQMessage message, XQServiceContext serviceContext, XQProcessContinuation continuation) {
        if (continuation == null) {
            throw new ItineraryException("The continuation object cannot be null", null);
        }
        if (continuation.getRootProcessName() == null) {
            throw new ItineraryException("The root process name cannot be null in the continuation object", null);
        }
        if (continuation.getCompositeStepName() == null) {
            throw new ItineraryException("The composite step name cannot be null in the continuation object", null);
        }
        try {
            Properties props = this.getProperties(continuation);
            if (continuation instanceof XQFaultProcessContinuation) {
                XQProcessContinuation origProcContinuation = ((XQFaultProcessContinuation)continuation).getOriginalProcessContinuation();
                if (origProcContinuation == null) {
                    throw new ItineraryException("The continuation object for the original process instance cannot be null", null);
                }
                Properties origProcProps = this.getProperties(origProcContinuation);
                props.put("SonicESB.OriginalProcess.Properties", origProcProps);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)baos);
            oos.writeObject(props);
            String base64Str = Base64.encode((byte[])baos.toByteArray());
            message.setHeaderValue(this.m_headerName, (Object)base64Str);
        }
        catch (XQMessageException e) {
            throw new RuntimeException("Error while persisting continuation header");
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating continuation header", e);
        }
    }

    private Properties getProperties(XQProcessContinuation continuation) {
        ProcessInstanceProps procInstProps = this.getProcessInstanceProps(continuation);
        Properties props = procInstProps.getAllProcessProps();
        if (continuation.getLevel() == XQProcessContinuation.Level.ITINERARY) {
            EsbMsgUtilsFactory msgUtils = new EsbMsgUtilsFactory();
            String procInstStr = msgUtils.getXQMessageToXml().getXQMessageString((XQMessage)continuation.getProcessInstanceData());
            props.put("Itinerary", procInstStr);
        }
        return props;
    }

    private ProcessInstanceProps getProcessInstanceProps(XQProcessContinuation continuation) {
        ProcessInstanceProps procInstProps;
        block8: {
            procInstProps = null;
            try {
                procInstProps = new ProcessInstanceProps(new Properties(), null);
                if (continuation.getProcessRuntime() != null) {
                    ItineraryRuntimeInfo.populateProcessInstanceProps(procInstProps, continuation.getProcessRuntime());
                }
                procInstProps.setRootProcessName(continuation.getRootProcessName());
                procInstProps.setProcessName(continuation.getCurrentProcessName());
                procInstProps.setStepName(continuation.getCompositeStepName());
                if (!continuation.getLevel().isGreaterThan(XQProcessContinuation.Level.STATELESS)) break block8;
                XQRuntimeProcess processContext = continuation.getProcessRuntime();
                if (processContext != null) {
                    XQAddress address = null;
                    address = processContext.getFaultAddress();
                    if (address != null) {
                        procInstProps.setFaultAddress(address);
                    }
                    if ((address = processContext.getRMEAddress()) != null) {
                        procInstProps.setRMEAddress(address);
                    }
                    if ((address = processContext.getEventAddress()) != null) {
                        procInstProps.setTrackingEndpoint(address);
                    }
                    Properties props = processContext.getInflightProperties();
                    procInstProps.setInflightProperties(props);
                    String trackingID = processContext.getTrackingID();
                    procInstProps.setTrackingId(trackingID);
                    int trackingLevel = processContext.getTrackingLevel();
                    if (trackingLevel >= 0) {
                        procInstProps.setTrackingLevel(trackingLevel);
                    }
                    procInstProps.setTTL(processContext.getTTL());
                    break block8;
                }
                throw new ItineraryException("Process context information not found in continuation object even though its Level 1", null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return procInstProps;
    }

    public XQProcessContinuation retrieve(XQMessage message, XQServiceContext serviceContext) {
        String continuationStr = null;
        try {
            continuationStr = (String)message.getHeaderValue(this.m_headerName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (continuationStr == null) {
            throw new RuntimeException(this.m_headerName + " header is missing. Unable to find continuaiton string.");
        }
        try {
            byte[] continuationBytes = Base64.decode((String)continuationStr);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(continuationBytes));
            Properties props = (Properties)ois.readObject();
            ItineraryContinuation continuation = this.createContinuation(props);
            Properties origProcProps = (Properties)props.remove("SonicESB.OriginalProcess.Properties");
            if (origProcProps != null) {
                ItineraryContinuation origProcContinuation = this.createContinuation(origProcProps);
                ((XQFaultProcessContinuation)continuation).setOriginalProcessContinuation((XQProcessContinuation)origProcContinuation);
            }
            return continuation;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while creating continuation header", e);
        }
    }

    private ItineraryContinuation createContinuation(Properties props) throws IOException {
        XQProcessContinuation.Level level = XQProcessContinuation.Level.PROCESS_CONTEXT;
        String procInstStr = (String)props.remove("Itinerary");
        XQMessage procInstMsg = null;
        if (procInstStr != null) {
            System.out.println(procInstStr);
            EsbMsgUtilsFactory msgUtils = new EsbMsgUtilsFactory();
            procInstMsg = msgUtils.getXMLToXQMessage().createXQMessage(procInstStr);
            level = XQProcessContinuation.Level.ITINERARY;
        }
        ProcessInstanceProps procInstProps = new ProcessInstanceProps(props, null);
        ItineraryContinuation continuation = null;
        continuation = props.get("SonicESB.OriginalProcess.Properties") != null ? new FaultItineraryContinuation(procInstProps, level) : new ItineraryContinuation(procInstProps, level);
        if (procInstMsg != null) {
            continuation.setProcessInstanceData(procInstMsg);
        }
        return continuation;
    }
}

