/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.engine.bootstrap;

import com.sonicsw.esb.itinerary.engine.ItineraryEngineFactory;
import com.sonicsw.esb.process.engine.ProcessEngine;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.Version;
import com.sonicsw.xqimpl.util.URLUtil;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.List;
import org.springframework.context.ConfigurableApplicationContext;

public class PEConfigUtil {
    public static final String GLOBAL_PE_CONFIG_LOCATION = "System/SonicESB/" + Version.getMajorMinorVersion() + "/ItineraryEngineConfig.xml";
    public static final String GLOBAL_PE_CONFIG_URL = "sonicfs:///" + GLOBAL_PE_CONFIG_LOCATION;
    public static final String PROCESS_ENGINE_BEAN_ID = "ProcessEngine";
    public static final String PE_SPRING_CONFIG_PATH = "com.sonicsw.esb.process.config";
    private static final XQLog s_log = XQLogImpl.getInstance();
    private static final XQLog s_DetailedLog = XQLogImpl.getCategoryLog((int)32768);

    private static ProcessEngine createDefaultProcessEngine() {
        ItineraryEngineFactory factory = new ItineraryEngineFactory();
        factory.init();
        return factory.getProcessEngine();
    }

    public static ProcessEngine setupForProcessEngineInitialization(ConfigurableApplicationContext rootCtx) {
        if (!PEConfigUtil.bootstrapUsingSpring(rootCtx, System.getProperty(PE_SPRING_CONFIG_PATH)) && !PEConfigUtil.bootstrapUsingSpring(rootCtx, GLOBAL_PE_CONFIG_LOCATION)) {
            s_DetailedLog.logDebug("Using default configurations for Itinerary Engine");
            return PEConfigUtil.createDefaultProcessEngine();
        }
        return null;
    }

    private static boolean bootstrapUsingSpring(ConfigurableApplicationContext rootCtx, String url) {
        if (url != null && URLUtil.exists((String)("sonicfs:///" + url)) && rootCtx.containsBean("sharedApplicationContextConfigs")) {
            List configs = (List)rootCtx.getBean("sharedApplicationContextConfigs");
            configs.add(0, url);
            s_log.logInformation("Itinerary Engine will be initialized using Spring config from: `sonicfs:///" + url + "`");
            return true;
        }
        return false;
    }

    public static ProcessEngine getProcessEngine(ConfigurableApplicationContext appCtx) {
        return appCtx.containsBean(PROCESS_ENGINE_BEAN_ID) ? (ProcessEngine)appCtx.getBean(PROCESS_ENGINE_BEAN_ID) : null;
    }

    public static void validateProcessEngineConfig(ProcessEngine engine) {
        if (engine == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine could not be initialized. Check container log for errors.");
        }
        if (engine.getParserFactory() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Definition Parser Factory is null");
        }
        if (engine.getProcessChangeEventManager() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Event Change Manager is null");
        }
        if (engine.getProcessDefSerializerFactory() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Definition Serializer Factory is null");
        }
        if (engine.getProcessResourceFactory() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Resource Factory is null");
        }
        if (engine.getProcessInstanceGeneratorFactory() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Instance Generator Factory is null");
        }
        if (engine.getProcessInstanceSerializerFactory() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Instance Serializer Factory is null");
        }
        if (engine.getProcessEngineActionManager() == null) {
            throw new IllegalStateException("Container initialization failed as the Itinerary Engine's Process Engine Action Manager is null");
        }
        if (s_DetailedLog.isDebugLoggingEnabled()) {
            s_DetailedLog.logDebug("**************************");
            s_DetailedLog.logDebug("Itinerary Engine Details ");
            s_DetailedLog.logDebug("Engine: " + engine.getClass().getName());
            s_DetailedLog.logDebug("Process Definition Parser Factory: " + engine.getParserFactory().getClass().getName());
            s_DetailedLog.logDebug("Process Definition Serializer Factory: " + engine.getProcessDefSerializerFactory().getClass().getName());
            s_DetailedLog.logDebug("Event Change Manager: " + engine.getProcessChangeEventManager().getClass().getName());
            s_DetailedLog.logDebug("Process Resource Factory: " + engine.getProcessResourceFactory().getClass().getName());
            s_DetailedLog.logDebug("Process Instance Generator Factory: " + engine.getProcessInstanceGeneratorFactory().getClass().getName());
            s_DetailedLog.logDebug("Process Instance Serializer Factory: " + engine.getProcessInstanceSerializerFactory().getClass().getName());
            s_DetailedLog.logDebug("Itinerary Engine Action Manager: " + engine.getProcessEngineActionManager().getClass().getName());
            s_DetailedLog.logDebug("**************************");
        }
    }
}

