/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQContentTypeException;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQHeader;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.connector.jms.ContentTypeJMSMapper;
import com.sonicsw.xq.connector.jms.ContentTypeJMSMapperConstants;
import com.sonicsw.xq.connector.jms.GlobalContentTypeJMSMapperOverride;
import com.sonicsw.xq.connector.jms.MappingException;
import com.sonicsw.xq.connector.jms.MessageMapper;
import com.sonicsw.xq.connector.jms.XQJMSMessage;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.MessageUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.w3c.dom.Node;
import progress.message.jclient.Header;
import progress.message.jclient.Message;
import progress.message.jclient.Part;
import progress.message.jimpl.BytesMessage;
import progress.message.jimpl.MapMessage;
import progress.message.jimpl.ObjectMessage;
import progress.message.jimpl.StreamMessage;
import progress.message.jimpl.TextMessage;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.jimpl.xmessage.XMLMessage;
import progress.message.util.StringUtil;

public class XQJMSMessageMapper
implements MessageMapper {
    private static final String IS_MULTIPART = "JMS_SonicMQ_XQ.isMultipart";
    private static final String SET_CONTENT_TYPE = "JMS_SonicMQ_XQ.setContentType";
    private static final int JMS_HEADER_MAX_VALUE_LENGTH = 65535;
    private static XQJMSMessageMapper m_mapper = null;
    private static XQJMSMessageMapper m_standaloneMapper = null;
    private static XQLog m_log = XQLogImpl.getInstance();
    private boolean m_standalone = false;

    public static synchronized XQJMSMessageMapper create() {
        if (m_mapper == null) {
            m_mapper = new XQJMSMessageMapper(false);
        }
        return m_mapper;
    }

    public static synchronized XQJMSMessageMapper createStandalone() {
        if (m_standaloneMapper == null) {
            m_standaloneMapper = new XQJMSMessageMapper(true);
        }
        return m_standaloneMapper;
    }

    private XQJMSMessageMapper(boolean standaloneMapper) {
        this.m_standalone = standaloneMapper;
    }

    @Override
    public Object translateInput(XQMessage source, XQEndpoint destination) throws MappingException {
        Message msg = null;
        if (source != null) {
            try {
                msg = this.toJms(source);
            }
            catch (XQMessageException e) {
                throw new MappingException(e);
            }
        }
        return msg;
    }

    private Message toJms(XQMessage xqMsg) throws XQMessageException {
        Message jmsMsg;
        try {
            jmsMsg = this.internalToJms(xqMsg);
        }
        catch (JMSException e) {
            throw new XQMessageException("Failed to create message", (Throwable)e);
        }
        try {
            this.overrideContentTypeIfNecessary(jmsMsg);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return jmsMsg;
    }

    private Message internalToJms(XQMessage xqMsg) throws XQMessageException, JMSException {
        Message jmsMsg;
        if (this.needsDowngrade(xqMsg)) {
            jmsMsg = this.downgradeMessage(xqMsg);
            if (jmsMsg == null) {
                jmsMsg = this.createMultipartMessage(xqMsg);
            }
        } else {
            jmsMsg = this.createMultipartMessage(xqMsg);
        }
        return jmsMsg;
    }

    private Message downgradeMessage(XQMessage message) throws XQMessageException, JMSException {
        progress.message.jimpl.Message newMsg = null;
        String contentType = null;
        String contentID = null;
        if (message.getPartCount() < 1) {
            newMsg = new progress.message.jimpl.Message();
        } else {
            XQPart xqPart = message.getPart(0);
            Object content = xqPart.getContent();
            contentType = this.downgradeContentType(message, xqPart);
            contentID = xqPart.getHeader().getValue("Content-ID");
            if (contentType != null) {
                ContentTypeJMSMapperConstants.JMSMessageType jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN;
                jmsMessageType = content instanceof MapMessage ? ContentTypeJMSMapperConstants.JMSMessageType.MAP : (content instanceof ObjectMessage ? ContentTypeJMSMapperConstants.JMSMessageType.OBJECT : (content instanceof StreamMessage ? ContentTypeJMSMapperConstants.JMSMessageType.STREAM : XQJMSMessageMapper.getMatchedJMSMessageType(contentType)));
                switch (jmsMessageType) {
                    case TEXT: {
                        newMsg = this.setTextMessageBody(new TextMessage(), content);
                        break;
                    }
                    case XML: {
                        newMsg = this.setTextMessageBody((TextMessage)new XMLMessage(), content);
                        break;
                    }
                    case BYTES: {
                        newMsg = this.setBytesMessageBody(content);
                        break;
                    }
                    case MULTIPART: {
                        break;
                    }
                    default: {
                        if (!(content instanceof Message)) break;
                        newMsg = (Message)content;
                        XQJMSMessageMapper.makeMessageWriteable((Message)newMsg);
                    }
                }
            }
            if (message.getStringHeader("Content-Type") == null && xqPart.getHeader().getValue("Content-Type") == null) {
                contentType = null;
            }
        }
        if (newMsg != null) {
            this.copyMessageHeadersFromXq(message, (Message)newMsg);
            XQJMSMessageMapper.setContentHeaders(contentID, contentType, (javax.jms.Message)newMsg);
        }
        return newMsg;
    }

    private Message setBytesMessageBody(Object content) throws JMSException {
        if (content instanceof byte[]) {
            BytesMessage newMsg = new BytesMessage();
            newMsg.writeBytes((byte[])content);
            return newMsg;
        }
        return null;
    }

    private Message setTextMessageBody(TextMessage newMsg, Object content) throws JMSException {
        if (content instanceof String) {
            newMsg.setText((String)content);
            return newMsg;
        }
        if (content instanceof Node) {
            StringWriter writer = new StringWriter();
            DOMUtils.serializeNodeToWriter((Node)((Node)content), (Writer)writer);
            newMsg.setText(writer.toString());
            return newMsg;
        }
        return null;
    }

    private String downgradeContentType(XQMessage message, XQPart xqPart) throws XQMessageException {
        String messageContentType = message.getStringHeader("Content-Type");
        String partContentType = xqPart.getContentType();
        if (messageContentType == null && partContentType == null) {
            return null;
        }
        if (messageContentType == null && partContentType != null) {
            return partContentType;
        }
        if (messageContentType != null && partContentType == null) {
            return messageContentType;
        }
        m_log.logDebug("XQJMSMessageMapper(downgradeContentType): both XQMessage and part have Content-Type set.  XQMessage's Content-Type=" + messageContentType + " Part's Content-Type=" + partContentType);
        m_log.logDebug("XQJMSMessageMapper(downgradeContentType): choosing part's Content-Type over message's Content-Type");
        return partContentType;
    }

    private static void setContentHeaders(String contentId, String contentType, javax.jms.Message msg) throws JMSException {
        if (contentId != null) {
            msg.setStringProperty("Content-ID", contentId);
        }
        if (contentType != null) {
            msg.setStringProperty("Content-Type", contentType);
        }
    }

    private boolean needsDowngrade(XQMessage xqMsg) throws XQMessageException {
        int count = xqMsg.getPartCount();
        if (count > 1) {
            return false;
        }
        if (count == 1) {
            XQPart part = xqMsg.getPart(0);
            Iterator names = part.getHeader().getKeys();
            while (names.hasNext()) {
                String key = (String)names.next();
                if (key.equals("Content-Type") || MessageUtils.isContentID((Object)key)) continue;
                return false;
            }
            if (xqMsg.getBooleanHeader(IS_MULTIPART)) {
                return false;
            }
        }
        return true;
    }

    private MultipartMessage createMultipartMessage(XQMessage xqMsg) throws JMSException, XQMessageException {
        MultipartMessage newMessage = new MultipartMessage();
        this.copyMessageHeadersFromXq(xqMsg, (Message)newMessage);
        for (int i = 0; i < xqMsg.getPartCount(); ++i) {
            XQPart xqPart = xqMsg.getPart(i);
            Part jmsPart = this.createJMSPart(xqPart, newMessage);
            newMessage.addPart(jmsPart);
        }
        return newMessage;
    }

    private void copyMessageHeadersFromXq(XQMessage from, Message to) throws XQMessageException, JMSException {
        Iterator headerNames = from.getHeaderNames();
        while (headerNames.hasNext()) {
            String header = (String)headerNames.next();
            JMSHeaderHandler.getHandler(header).xqToJms(from, to, header);
        }
    }

    private Part createJMSPart(XQPart xqPart, MultipartMessage message) throws XQContentTypeException {
        Part jmsPart = null;
        try {
            Object content = xqPart.getContent();
            String type = xqPart.getContentType();
            jmsPart = content instanceof Message ? message.createMessagePart((javax.jms.Message)((Message)content)) : message.createPart(content, type);
            XQJMSMessageMapper.copyHeader(xqPart, jmsPart);
        }
        catch (JMSException e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
        return jmsPart;
    }

    private static void copyHeader(XQPart xqPart, Part jmsPart) throws XQContentTypeException {
        try {
            Header jmsHeader = jmsPart.getHeader();
            XQHeader xqHeader = xqPart.getHeader();
            jmsHeader.removeAllHeaders();
            if (xqHeader != null) {
                Iterator keys = xqHeader.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = xqHeader.getValue(key);
                    jmsHeader.setHeaderField(key, val);
                }
            }
        }
        catch (Exception e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
    }

    private void overrideContentTypeIfNecessary(Message jmsMsg) throws JMSException {
        if (jmsMsg.propertyExists(SET_CONTENT_TYPE)) {
            String contentType = jmsMsg.getStringProperty(SET_CONTENT_TYPE);
            jmsMsg.setStringProperty(SET_CONTENT_TYPE, null);
            if (contentType != null && contentType.trim().length() != 0) {
                jmsMsg.setStringProperty("Content-Type", contentType);
            }
        }
    }

    @Override
    public XQMessage translateOutput(Object msg, XQEndpoint source) throws MappingException {
        return this.translateOutput(msg, source, null);
    }

    @Override
    public XQMessage translateOutput(Object msg, XQEndpoint source, IEndpointRegistry reg) throws MappingException {
        if (msg != null) {
            try {
                String name = source == null ? null : source.getName();
                XQJMSMessage impl = new XQJMSMessage(name, this.m_standalone);
                if (reg != null) {
                    impl.setEndpointRegistry(reg);
                }
                this.fromJMS((Message)msg, impl);
                return impl;
            }
            catch (Exception e) {
                throw new MappingException(e);
            }
        }
        return null;
    }

    private void fromJMS(Message jmsMsg, XQJMSMessage xqMsg) throws JMSException, XQMessageException {
        if (!jmsMsg.propertyExists(IS_MULTIPART)) {
            xqMsg.setBooleanHeader(IS_MULTIPART, jmsMsg instanceof MultipartMessage);
        } else {
            xqMsg.setBooleanHeader(IS_MULTIPART, jmsMsg.getBooleanProperty(IS_MULTIPART));
        }
        xqMsg.addSidebandProperty("SonicESB.JMSPriority.incoming", jmsMsg.getJMSPriority());
        this.copyMessageHeadersFromJMS(jmsMsg, xqMsg);
        if (jmsMsg instanceof MultipartMessage) {
            MultipartMessage mm = (MultipartMessage)jmsMsg;
            for (int i = 0; i < mm.getPartCount(); ++i) {
                Part jmsPart = mm.getPart(i);
                XQPart xqPart = xqMsg.createPart();
                XQJMSMessageMapper.copyPartHeader(jmsPart, xqPart);
                if (mm.isMessagePart(i)) {
                    Message partMessage = (Message)mm.getMessageFromPart(i);
                    XQJMSMessageMapper.setPartContentFromMessage(xqPart, partMessage);
                } else {
                    XQJMSMessageMapper.setPartContent(xqPart, jmsPart);
                }
                xqMsg.addPart(xqPart);
            }
        } else if (!progress.message.jimpl.Message.class.getName().equals(jmsMsg.getClass().getName())) {
            XQPart xqPart = xqMsg.createPart();
            XQJMSMessageMapper.copyContentHeaders(jmsMsg, xqPart);
            XQJMSMessageMapper.setPartContentFromMessage(xqPart, jmsMsg);
            xqMsg.addPart(xqPart);
        }
    }

    private void copyMessageHeadersFromJMS(Message jms, XQJMSMessage xqMsg) throws XQMessageException, JMSException {
        for (Map.Entry entry : jms.getProperties().entrySet()) {
            xqMsg.setHeaderValue((String)entry.getKey(), entry.getValue());
        }
        xqMsg.setHeaderValue("JMSDestination", jms.getJMSDestination());
        xqMsg.setHeaderValue("JMSDeliveryMode", jms.getJMSDeliveryMode());
        xqMsg.setHeaderValue("JMSMessageID", jms.getJMSMessageID());
        xqMsg.setHeaderValue("JMSTimestamp", jms.getJMSTimestamp());
        xqMsg.setHeaderValue("JMSCorrelationID", jms.getJMSCorrelationID());
        xqMsg.setHeaderValue("JMSReplyTo", jms.getJMSReplyTo());
        xqMsg.setHeaderValue("JMSRedelivered", jms.getJMSRedelivered());
        xqMsg.setHeaderValue("JMSType", jms.getJMSType());
        xqMsg.setHeaderValue("JMSExpiration", jms.getJMSExpiration());
        xqMsg.setHeaderValue("JMSPriority", jms.getJMSPriority());
    }

    private static void copyContentHeaders(Message jmsMessage, XQPart xqPart) throws XQContentTypeException {
        try {
            XQHeader xqHeader = xqPart.getHeader();
            xqHeader.removeAll();
            if (jmsMessage != null) {
                String contentType;
                String contentID = XQJMSMessageMapper.getJMSContentID(jmsMessage);
                if (null != contentID) {
                    xqHeader.setValue("Content-ID", contentID);
                }
                if (null != (contentType = XQJMSMessageMapper.getJMSContentType(jmsMessage))) {
                    xqHeader.setValue("Content-Type", contentType);
                }
            }
        }
        catch (Exception e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
    }

    private static String getJMSContentType(Message msg) {
        try {
            return msg.getStringProperty("Content-Type");
        }
        catch (JMSException jMSException) {
            return null;
        }
    }

    private static String getJMSContentID(Message msg) {
        try {
            return (String)msg.getObjectProperty("Content-ID");
        }
        catch (JMSException jMSException) {
            return null;
        }
    }

    private static ContentTypeJMSMapperConstants.JMSMessageType getMatchedJMSMessageType(String contentType) {
        ContentTypeJMSMapperConstants.JMSMessageType jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN;
        ContentTypeJMSMapper override = GlobalContentTypeJMSMapperOverride.getContentTypeJMSMapper();
        if (override != null && override.hasMappings() && (jmsMessageType = override.getMatchedJMSMessageType(contentType)) != ContentTypeJMSMapperConstants.JMSMessageType.UNKNOWN) {
            return jmsMessageType;
        }
        if (contentType.toLowerCase().startsWith("text/xml".toLowerCase())) {
            jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.XML;
        } else if (contentType.toLowerCase().startsWith("text/plain".toLowerCase())) {
            jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.TEXT;
        } else if (contentType.toLowerCase().startsWith("text/html".toLowerCase())) {
            jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.TEXT;
        } else if (contentType.toLowerCase().startsWith("text/".toLowerCase())) {
            jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.TEXT;
        } else if (contentType.toLowerCase().startsWith("application/octet-stream".toLowerCase())) {
            jmsMessageType = ContentTypeJMSMapperConstants.JMSMessageType.BYTES;
        }
        return jmsMessageType;
    }

    private static void setPartContentFromMessage(XQPart part, Message message) throws XQContentTypeException {
        String contentType = XQJMSMessageMapper.getJMSContentType(message);
        if (message instanceof XMLMessage) {
            if (contentType == null || contentType.length() == 0) {
                contentType = "text/xml";
            }
            XQJMSMessageMapper.setPartContent(part, (TextMessage)((XMLMessage)message), contentType);
        } else if (message instanceof TextMessage) {
            if (contentType == null || contentType.length() == 0) {
                contentType = "text/plain";
            }
            XQJMSMessageMapper.setPartContent(part, (TextMessage)message, contentType);
        } else if (message instanceof BytesMessage) {
            if (contentType == null || contentType.length() == 0) {
                contentType = "application/octet-stream";
            }
            XQJMSMessageMapper.setPartContent(part, (BytesMessage)message, contentType);
        } else {
            if (contentType == null || contentType.length() == 0) {
                if (message instanceof MapMessage) {
                    contentType = "application/x-sonicmq-mapmessage";
                } else if (message instanceof ObjectMessage) {
                    contentType = "application/x-sonicmq-objectmessage";
                } else if (message instanceof StreamMessage) {
                    contentType = "application/x-sonicmq-streammessage";
                }
            }
            XQJMSMessageMapper.makeMessageWriteable(message);
            part.setContent((Object)message, contentType);
        }
    }

    private static void makeMessageWriteable(Message message) {
        progress.message.jimpl.Message jMessage = (progress.message.jimpl.Message)message;
        try {
            jMessage.setPropertiesReadOnly(false);
            if (message instanceof MultipartMessage) {
                if (((MultipartMessage)message).isReadOnly()) {
                    ((MultipartMessage)message).clearReadOnly();
                }
            } else {
                jMessage.setBodyReadOnly(false);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private static void setPartContent(XQPart part, TextMessage msg, String contentType) throws XQContentTypeException {
        try {
            String content = msg.getText();
            if (content == null) {
                content = "";
            }
            part.setContent((Object)content, contentType);
        }
        catch (Exception e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
    }

    private static void setPartContent(XQPart part, BytesMessage msg, String contentType) throws XQContentTypeException {
        try {
            msg.reset();
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream(msg.getBodySize());
            int i = msg.readBytes(buffer);
            while (i != -1) {
                out.write(buffer, 0, i);
                i = msg.readBytes(buffer);
            }
            part.setContent((Object)out.toByteArray(), contentType);
        }
        catch (Exception e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
    }

    private static void copyPartHeader(Part jmsPart, XQPart xqPart) throws XQContentTypeException {
        try {
            Header jmsHeader = jmsPart.getHeader();
            XQHeader xqHeader = xqPart.getHeader();
            xqHeader.removeAll();
            if (jmsHeader != null) {
                Enumeration keys = jmsHeader.getHeaderFieldNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String val = jmsHeader.getHeaderField(key);
                    xqHeader.setValue(key, val);
                }
            }
        }
        catch (Exception e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
    }

    private static void setPartContent(XQPart xqPart, Part jmsPart) throws XQContentTypeException {
        try {
            String contentType = null;
            Header jmsHeader = jmsPart.getHeader();
            if (jmsHeader != null) {
                xqPart.setContentId(jmsHeader.getContentId());
                contentType = jmsHeader.getContentType();
            }
            xqPart.setContent(jmsPart.getContent(), contentType);
        }
        catch (Exception e) {
            throw new XQContentTypeException("Unknown message type: ", (Throwable)e);
        }
    }

    public XQMessage createMessage() throws MappingException {
        try {
            return new XQJMSMessage(this.m_standalone);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    static enum JMSHeaderHandler {
        JMSDestination{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setHeaderValue("JMSDestination", (Object)from.getJMSDestination());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSDestination((Destination)from.getHeaderValue("JMSDestination"));
            }
        }
        ,
        JMSDeliveryMode{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setIntHeader("JMSDeliveryMode", from.getJMSDeliveryMode());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSDeliveryMode(from.getIntHeader("JMSDeliveryMode"));
            }
        }
        ,
        JMSMessageID{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setStringHeader("JMSMessageID", from.getJMSMessageID());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSMessageID(from.getStringHeader("JMSMessageID"));
            }
        }
        ,
        JMSTimestamp{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setLongHeader("JMSTimestamp", from.getJMSTimestamp());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSTimestamp(from.getLongHeader("JMSTimestamp"));
            }
        }
        ,
        JMSCorrelationID{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setStringHeader("JMSCorrelationID", from.getJMSCorrelationID());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSCorrelationID(from.getStringHeader("JMSCorrelationID"));
            }
        }
        ,
        JMSReplyTo{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setHeaderValue("JMSReplyTo", (Object)from.getJMSReplyTo());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSReplyTo((Destination)from.getHeaderValue("JMSReplyTo"));
            }
        }
        ,
        JMSRedelivered{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setBooleanHeader("JMSRedelivered", from.getJMSRedelivered());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSRedelivered(from.getBooleanHeader("JMSRedelivered"));
            }
        }
        ,
        JMSType{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setStringHeader("JMSType", from.getJMSType());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSType(from.getStringHeader("JMSType"));
            }
        }
        ,
        JMSExpiration{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setLongHeader("JMSExpiration", from.getJMSExpiration());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSExpiration(from.getLongHeader("JMSExpiration"));
            }
        }
        ,
        JMSPriority{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setIntHeader("JMSPriority", from.getJMSPriority());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                int priority = from.getIntHeader("JMSPriority");
                if (priority < 0) {
                    priority = 0;
                } else if (priority > 9) {
                    priority = 9;
                }
                to.setJMSPriority(priority);
            }
        }
        ,
        ESBCorrelation{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws XQMessageException, JMSException {
                to.setCorrelationId(from.getJMSCorrelationID());
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                to.setJMSCorrelationID(from.getCorrelationId());
            }
        }
        ,
        DEFAULT{

            @Override
            void jmsToXq(Message from, XQMessage to, String propertyName) throws JMSException, XQMessageException {
                to.setHeaderValue(propertyName, from.getObjectProperty(propertyName));
            }

            @Override
            void xqToJms(XQMessage from, Message to, String propertyName) throws JMSException, XQMessageException {
                Object headerValue = this.getSafeValue(from.getHeaderValue(propertyName));
                to.setObjectProperty(propertyName, headerValue);
            }
        };

        private static Map<String, JMSHeaderHandler> s_handlerMap;

        public static JMSHeaderHandler getHandler(String name) {
            JMSHeaderHandler handler = s_handlerMap.get(name);
            if (handler == null) {
                handler = DEFAULT;
            }
            return handler;
        }

        protected Object getSafeValue(Object value) {
            Object result = value;
            if (value instanceof String) {
                String str = (String)value;
                if (StringUtil.lengthUTF((String)str) > 65535) {
                    str = StringUtil.truncateUTF((String)str, (int)65530) + "...]";
                }
                result = str;
            }
            return result;
        }

        abstract void jmsToXq(Message var1, XQMessage var2, String var3) throws JMSException, XQMessageException;

        abstract void xqToJms(XQMessage var1, Message var2, String var3) throws JMSException, XQMessageException;

        static {
            s_handlerMap = new HashMap<String, JMSHeaderHandler>();
            for (JMSHeaderHandler handler : JMSHeaderHandler.values()) {
                s_handlerMap.put(handler.name(), handler);
            }
            s_handlerMap.put("{http://www.sonicsw.com/esb}CorrelationId", ESBCorrelation);
        }
    }
}

