/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.adapter.XQAdapterContext;
import com.sonicsw.xq.adapter.XQMessageAdapter;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointCfg;
import com.sonicsw.xqimpl.endpoint.container.EndpointContext;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnection;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAEndpointContext;
import com.sonicsw.xqimpl.endpoint.container.jca.XQAdapterContextImpl;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.service.XQDispatcher;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.ManagedConnectionFactory;

public abstract class JCABaseEndpoint
extends EndpointCfg
implements Endpoint {
    protected XQMessageAdapter m_messageAdapter;
    protected XQLog m_log;
    protected JCAConnection m_connection;
    protected JCAConnectionManager m_connectionManager;
    protected ManagedConnectionFactory m_mcf;
    private static HashMap<String, Class> m_classCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCABaseEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log, JCAConnection connection, XQMessageFactory messageFactory, JCAConnectionManager connectionManager) throws XQEndpointCreationException {
        super(config, typeConfig);
        this.m_log = log;
        this.m_connection = connection;
        this.m_mcf = this.m_connection.getManagedConnectionFactory();
        this.m_connectionManager = connectionManager;
        XQAddressFactoryImpl addressFactory = new XQAddressFactoryImpl(config.getName(), 0);
        String classname = this.m_typeConfig.getMessageAdapterClassname();
        String uri = this.m_typeConfig.getMessageAdapterJarURI();
        if (classname == null || "".equals(classname.trim()) || uri == null || "".equals(uri.trim())) {
            throw new XQEndpointCreationException("messageAdapterClass and messageAdapterJarURI must be specified for JCA Endpoints");
        }
        Class<?> adapterClass = null;
        HashMap<String, Class> hashMap = m_classCache;
        synchronized (hashMap) {
            if (m_classCache.containsKey(classname)) {
                adapterClass = m_classCache.get(classname);
            } else {
                try {
                    ClassLoader rarClassLoader = connection.getClassLoader();
                    URLClassLoader cl = new URLClassLoader(new URL[]{new URL(uri)}, rarClassLoader);
                    adapterClass = cl.loadClass(classname);
                    m_classCache.put(classname, adapterClass);
                }
                catch (MalformedURLException cnfe) {
                    throw new XQEndpointCreationException(" not found in the specified url: ", (Throwable)cnfe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new XQEndpointCreationException(" not found in the specified url: ", (Throwable)cnfe);
                }
            }
        }
        if (!XQMessageAdapter.class.isAssignableFrom(adapterClass)) {
            throw new XQEndpointCreationException("messageAdapterClass must implement XQMessageAdapter");
        }
        try {
            this.m_messageAdapter = (XQMessageAdapter)adapterClass.newInstance();
        }
        catch (Exception e) {
            throw new XQEndpointCreationException("messageAdapterClass must implement XQMessageAdapter", (Throwable)e);
        }
        this.m_messageAdapter.init((XQAdapterContext)new XQAdapterContextImpl((XQParameters)this.m_params, this.m_log, this.m_connection, messageFactory, addressFactory, new EnvelopeFactory()));
    }

    public JCAConnection getConnection() {
        return this.m_connection;
    }

    @Override
    public void destroy() {
        this.m_messageAdapter.destroy();
    }

    @Override
    public void stopMessageListener(String name) throws Exception {
        throw new UnsupportedOperationException("This JCA version does not support receive functionality");
    }

    @Override
    public void setMessageListener(String name, IXQMessageListener msgListener, Map<String, Object> subscriptionSpec) throws Exception {
        throw new UnsupportedOperationException("This JCA version does not support receive functionality");
    }

    @Override
    public void send(String name, XQMessage msg) throws XQEndpointException {
        this.doSend(msg);
        this.checkConnectionClosed();
    }

    @Override
    public void send(XQMessage msg) throws XQEndpointException {
        this.doSend(msg);
    }

    private void doSend(XQMessage msg) throws XQEndpointException {
        try {
            this.m_messageAdapter.send(msg);
            this.m_connectionManager.handleSendCompletion(this.m_mcf, true);
        }
        catch (XQEndpointException e) {
            this.m_connectionManager.handleSendCompletion(this.m_mcf, false);
            throw e;
        }
    }

    @Override
    public HashMap<String, String> sendWithQoS(String sessionName, boolean commit, XQQualityofService qos, XQMessage msg) throws XQEndpointException {
        this.send(sessionName, msg);
        return null;
    }

    public XQMessage call(XQMessage msg, long timeout) throws XQEndpointException {
        XQMessage returnMessage = null;
        try {
            returnMessage = this.m_messageAdapter.call(msg, timeout);
            this.m_connectionManager.handleSendCompletion(this.m_mcf, true);
        }
        catch (XQEndpointException e) {
            this.m_connectionManager.handleSendCompletion(this.m_mcf, false);
            throw e;
        }
        this.checkConnectionClosed();
        return returnMessage;
    }

    private void checkConnectionClosed() throws XQEndpointException {
        if (!this.m_connectionManager.haveConnectionsClosedProperly(this.m_mcf)) {
            throw new XQEndpointException("The LocalTransaction did not complete properly.  This is most likely due to not closing the connection in the XQMessageAdapter implementation or attempting to start a nested transaction.");
        }
    }

    public String getName() {
        return this.m_config.getName();
    }

    @Override
    public EndpointContext createContext(String name, String qos, XQDispatcher dispatcher, String entryEndpointConnection) throws Exception {
        return new JCAEndpointContext(name, qos);
    }

    public XQMessage createMessage() throws XQEndpointException {
        return this.m_messageAdapter.createMessage();
    }

    @Override
    public String getConnectionName() {
        return this.m_config.getConnection();
    }
}

