/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.jndi.ObjHelper;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.endpoint.container.RefCountableEndpoint;
import com.sonicsw.xqimpl.envelope.IXQAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.jclient.DestinationFactory;

public class XQURLAddressImpl
implements XQAddress,
IXQAddressImpl {
    private static String[] s_addrTypeNames = new String[]{"endpoint", "service", "process"};
    public static final String SONIC_URL_LOCAL_PREFIX = "sonic:///local?";
    private IXQAddressImpl m_wrappedAddress;
    private String m_url;
    private RefCountableEndpoint m_endpoint;
    private static Pattern jndiEsbPattern = Pattern.compile("^jndi:/SonicESB/(.+?)/(.+?)(?:/(.+?))?$");
    private static final int JNDIESB_PATTERN_NODE = 1;
    private static final int JNDIESB_PATTERN_NAME = 2;
    private static final int JNDIESB_PATTERN_ENTRY = 3;
    private static Pattern jndiPattern = Pattern.compile("^jndi:/(.+?)$");
    private static final int JNDI_PATTERN_NAME = 1;
    private static Pattern sonicUrlPattern = Pattern.compile("^sonic:///(.*)?/(.*?)(?:\\?(.*))?$");
    private static final int SONIC_PATTERN_NODE = 1;
    private static final int SONIC_PATTERN_NAME = 2;
    private static final int SONIC_PATTERN_ENTRY = 3;
    private static Pattern httpUrlPattern = Pattern.compile("^(?:(.*)::)?(https?:(?:[0-9]+)?//.*)");
    private static final int HTTP_PATTERN_NODE = 1;
    private static final int HTTP_PATTERN_URL = 2;
    public static final String ADDRESS_STRING_URL = "ADDRESS_STRING_URL";

    public XQURLAddressImpl(String url, XQEndpointConfig source, XQAddressFactoryImpl factory, XQConnectionConfig connectionConfig, Hashtable props) throws XQAddressNotFoundException {
        this.initXQURLAddress(url, source, factory, connectionConfig, props);
    }

    public XQURLAddressImpl(String url, String source, XQAddressFactoryImpl factory) throws XQAddressNotFoundException {
        try {
            XQEndpointConfig endpointSource = ((JMSEndpoint)EndpointManager.getInstance().getEndpoint(source)).getConfig();
            this.initXQURLAddress(url, endpointSource, factory, null, null);
        }
        catch (XQEndpointCreationException ex) {
            throw new XQAddressNotFoundException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public XQURLAddressImpl(String url) {
        this.m_url = url;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseUrl(String epName, XQAddressFactory factory, XQEndpointConfig endpointConfig, XQConnectionConfig xqConnectionConfig, Hashtable dsConnProps) throws XQAddressNotFoundException {
        String lookupStr = null;
        boolean jmsDestination = false;
        Destination destination = null;
        Matcher sonicMatcher = sonicUrlPattern.matcher(this.m_url);
        Matcher jndiEsbMatcher = jndiEsbPattern.matcher(this.m_url);
        Matcher jndiMatcher = jndiPattern.matcher(this.m_url);
        Matcher httpMatcher = httpUrlPattern.matcher(this.m_url);
        if (sonicMatcher.matches()) {
            lookupStr = sonicMatcher.group(2);
        } else if (jndiEsbMatcher.matches()) {
            lookupStr = jndiEsbMatcher.group(2);
        } else if (jndiMatcher.matches()) {
            lookupStr = jndiMatcher.group(1);
            jmsDestination = true;
        } else {
            if (!httpMatcher.matches()) throw new XQAddressNotFoundException("invalid url:" + this.m_url);
            jmsDestination = true;
            destination = this.getJMSDestination(this.m_url);
        }
        if (!jmsDestination) {
            XQConfiguration lookupObj = XQURLAddressImpl.lookupConfigObject(lookupStr, s_addrTypeNames[2], dsConnProps);
            if (lookupObj != null) {
                this.m_wrappedAddress = (IXQAddressImpl)factory.createProcessAddress(lookupStr);
                return;
            } else {
                lookupObj = XQURLAddressImpl.lookupConfigObject(lookupStr, s_addrTypeNames[1], dsConnProps);
                if (lookupObj == null) throw new XQAddressNotFoundException(this.m_url + " doesn't point to either process or service");
                this.m_wrappedAddress = (IXQAddressImpl)factory.createServiceAddress(lookupStr);
            }
            return;
        }
        if (destination == null) {
            IComponentContext cc = XQConfigManager.getInstance(null).getComponentContext();
            if (cc != null) {
                destination = this.getJMSDestination(lookupStr, cc);
            } else {
                try {
                    IDirectoryAdminService proxy = XQConfigManager.getInstance((Hashtable)dsConnProps).getDirectoryService();
                    IDirElement e = proxy.getElement("/_MFContext/" + lookupStr, false);
                    destination = this.getJMSDestination(lookupStr, (IElement)e);
                }
                catch (DirectoryServiceException e1) {
                    throw new XQAddressNotFoundException("unable to get destination for url:" + this.m_url, (Exception)((Object)e1));
                }
            }
        }
        Throwable thrown = null;
        try {
            EndpointManager mgr = EndpointManager.getInstance();
            XQEndpointConfig config = mgr.createNamedEndpointConfig(epName, endpointConfig, destination);
            this.m_endpoint = mgr.getRefEndpoint(epName, config, xqConnectionConfig, dsConnProps);
            this.m_wrappedAddress = new XQAddressImpl(epName, 0);
        }
        catch (JMSException e) {
            thrown = e;
        }
        catch (XQEndpointCreationException e) {
            thrown = e;
        }
        if (thrown == null) return;
        throw new XQAddressNotFoundException("failed to create endpoint for:" + this.m_url, (Exception)thrown);
    }

    private static IXQAddressImpl computeWrappedAddress(String addressStr, XQAddressFactoryImpl factory, Hashtable dsConnProps) throws XQAddressNotFoundException {
        String address;
        IXQAddressImpl returnAddress;
        String[] parts = addressStr.split("=");
        if (parts.length < 2) {
            XQURLAddressImpl.throwException(addressStr);
        }
        int addressType = -1;
        try {
            addressType = XQAbstractAddressImpl.getTypeAsInt((String)parts[0].toUpperCase());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (addressType < 0 || addressType > 2) {
            XQURLAddressImpl.throwException(addressStr);
        }
        if ((returnAddress = XQURLAddressImpl.createAddress(factory, address = parts[1], addressType, dsConnProps)) == null) {
            throw new XQAddressNotFoundException(SONIC_URL_LOCAL_PREFIX + addressStr + " doesn't point to a valid process, service or endpoint");
        }
        return returnAddress;
    }

    private static void throwException(String addressStr) {
        throw new IllegalArgumentException(SONIC_URL_LOCAL_PREFIX + addressStr + " is invalid. The right format is " + SONIC_URL_LOCAL_PREFIX + "<Type>=<ArtifactName>. <Type> takes one of the following values - Endpoint, Service, Process. <ArtifactName> is the name of the endpoint, service or process.");
    }

    private static String getEntryEndpointName(String addressStr, XQConfiguration config) {
        String entryEPName = null;
        try {
            entryEPName = config instanceof XQProcessConfig ? ((XQProcessConfig)config).getEntryEndpoint() : (config instanceof XQServiceConfig ? ((XQServiceConfig)config).getEntryEndpoint() : config.getName());
        }
        catch (Throwable e) {
            throw new IllegalStateException("Error while getting entry endpoint name for: " + addressStr);
        }
        if (entryEPName == null) {
            throw new IllegalStateException("Entry endpoint not defined for: " + addressStr);
        }
        return entryEPName;
    }

    private static IXQAddressImpl createAddress(XQAddressFactoryImpl factory, String addressStr, int addressType, Hashtable dsConnProps) throws XQAddressNotFoundException {
        IXQAddressImpl addr = null;
        XQConfiguration lookupObj = XQURLAddressImpl.lookupConfigObject(addressStr, s_addrTypeNames[addressType], dsConnProps);
        if (lookupObj != null) {
            String endpointName = null;
            if (addressType == 0) {
                endpointName = addressStr;
            } else {
                endpointName = XQURLAddressImpl.getEntryEndpointName(addressStr, lookupObj);
                lookupObj = XQURLAddressImpl.lookupConfigObject(endpointName, s_addrTypeNames[0], dsConnProps);
            }
            addr = (IXQAddressImpl)factory.createAddress(endpointName, "ENDPOINT", lookupObj);
        }
        return addr;
    }

    private static XQConfiguration lookupConfigObject(String name, String typeStr, Hashtable dsConnProps) {
        XQConfiguration ret = null;
        try {
            XQConfigManager configManager = XQConfigManager.getInstance((Hashtable)dsConnProps);
            ret = (XQConfiguration)configManager.lookup(name, typeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private void initXQURLAddress(String url, XQEndpointConfig source, XQAddressFactoryImpl factory, XQConnectionConfig connectionConfig, Hashtable props) throws XQAddressNotFoundException {
        this.m_url = url;
        IElement e = null;
        IComponentContext context = XQConfigManager.getInstance((Hashtable)props).getComponentContext();
        Destination destination = null;
        String lookupString = null;
        if (url.startsWith(SONIC_URL_LOCAL_PREFIX)) {
            lookupString = url.substring(SONIC_URL_LOCAL_PREFIX.length());
            this.m_wrappedAddress = XQURLAddressImpl.computeWrappedAddress(lookupString, factory, props);
        } else {
            lookupString = this.getLookupString(url);
            if (context != null) {
                e = context.getConfiguration("/_MFContext/" + lookupString, false);
                if (e == null) {
                    throw new XQAddressNotFoundException("Unable to locate destination from url: " + url);
                }
                destination = this.getJMSDestination(lookupString, context);
            } else {
                IDirectoryAdminService proxy = XQConfigManager.getInstance((Hashtable)props).getDirectoryService();
                try {
                    e = proxy.getElement("/_MFContext/" + lookupString, false);
                    destination = this.getJMSDestination(lookupString, e);
                }
                catch (DirectoryServiceException exception) {
                    throw new XQAddressNotFoundException("Unable to get destination from url: " + url + " due to " + exception.getMessage(), (Exception)((Object)exception));
                }
            }
            if (e == null) {
                throw new XQAddressNotFoundException("Unable to lookup destination from url: " + url);
            }
            this.m_wrappedAddress = factory.createAddress(source, destination, connectionConfig, props, false);
        }
        if (this.m_wrappedAddress == null) {
            throw new XQAddressNotFoundException("Unable to retrieve address for: " + url);
        }
    }

    private Destination getJMSDestination(String lookupString, IElement elem) throws XQAddressNotFoundException {
        Destination jmsDestination;
        try {
            Object obj = XQURLAddressImpl.elementToReference(elem);
            AdministeredObjectFactory fact = new AdministeredObjectFactory();
            jmsDestination = (Destination)fact.getObjectInstance(obj, null, null, null);
        }
        catch (Exception ex) {
            throw new XQAddressNotFoundException("Unable to lookup url: " + lookupString, ex);
        }
        if (jmsDestination == null) {
            throw new XQAddressNotFoundException("The destination associated with: " + lookupString + " is null");
        }
        return jmsDestination;
    }

    private static Object elementToReference(IElement element) throws NamingException {
        String elmntType = element.getIdentity().getType();
        if ("SerializedObject".equals(elmntType)) {
            IAttributeSet attrs = element.getAttributes();
            byte[] bytes = (byte[])attrs.getAttribute("data");
            return ObjHelper.deserializeObject((byte[])bytes);
        }
        if ("ReferenceObject".equals(elmntType)) {
            return ObjHelper.convertElementToRef((IElement)element, (boolean)false);
        }
        throw new NameNotFoundException(element.getIdentity().getName() + " is not of a ReferenceObject or a SerializedObject types");
    }

    private Destination getJMSDestination(String lookupString, IComponentContext context) throws XQAddressNotFoundException {
        Destination jmsDestination;
        try {
            Object obj = context.getInitialContext().lookup(lookupString);
            AdministeredObjectFactory fact = new AdministeredObjectFactory();
            jmsDestination = (Destination)fact.getObjectInstance(obj, null, null, null);
        }
        catch (Exception ex) {
            throw new XQAddressNotFoundException("Unable to lookup url: " + lookupString, ex);
        }
        if (jmsDestination == null) {
            throw new XQAddressNotFoundException("The destination associated with: " + lookupString + " is null");
        }
        return jmsDestination;
    }

    private String getLookupString(String locationURL) throws XQAddressNotFoundException {
        String lookupString;
        if (locationURL.startsWith("sonic:///")) {
            lookupString = "SonicESB/" + locationURL.substring(locationURL.indexOf("sonic:///") + "sonic:///".length());
            if (lookupString.indexOf(":") == -1) {
                lookupString = lookupString + "/Entry";
            }
        } else if (locationURL.startsWith("jndi:/")) {
            lookupString = locationURL.substring(locationURL.indexOf("jndi:/") + 6);
        } else {
            throw new XQAddressNotFoundException("Unrecognized port URL syntax " + locationURL);
        }
        return lookupString;
    }

    private Destination getJMSDestination(String url) throws XQAddressNotFoundException {
        Queue dest = null;
        try {
            dest = DestinationFactory.createQueue((String)url);
        }
        catch (JMSException e) {
            throw new XQAddressNotFoundException("failed to create destination for " + url, (Exception)((Object)e));
        }
        return dest;
    }

    @Override
    public void setName(String name) {
        this.m_wrappedAddress.setName(name);
    }

    @Override
    public void setTypeAsString(String type) {
        this.m_wrappedAddress.setTypeAsString(type);
    }

    @Override
    public void setType(int type) {
        this.m_wrappedAddress.setType(type);
    }

    @Override
    public String getName() {
        return this.m_wrappedAddress.getName();
    }

    @Override
    public String getReplyToName() {
        return this.m_url;
    }

    @Override
    public int getType() {
        return this.m_wrappedAddress.getType();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.m_wrappedAddress.equals(((XQURLAddressImpl)obj).m_wrappedAddress);
        }
        return this.m_wrappedAddress.equals(obj);
    }

    public int hashCode() {
        return this.m_wrappedAddress.toString().hashCode();
    }

    public String toString() {
        if (this.m_wrappedAddress != null) {
            return this.m_wrappedAddress.toString();
        }
        return " Address for:" + this.m_url;
    }

    @Override
    public String getTypeAsString() {
        return ADDRESS_STRING_URL;
    }

    public boolean isHttp() {
        return httpUrlPattern.matcher(this.m_url).matches();
    }

    public boolean isJNDI() {
        return jndiPattern.matcher(this.m_url).matches();
    }

    @Override
    public XQConfiguration getConfig() {
        return null;
    }

    public XQAddress getWrappedAddress() {
        return this.m_wrappedAddress;
    }
}

