/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.service.InstanceMetricCapable;
import com.sonicsw.xqimpl.service.XQAppManager;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XQServiceMetrics
implements InstanceMetricCapable {
    private static XQLog log = XQLogImpl.getCategoryLog((int)16);
    public static final IMetricIdentity MESSAGES_RECEIVED = MetricsFactory.createMetricIdentity((String)"esb.service.messages.Received");
    public static final IMetricIdentity MESSAGES_RECEIVED_INTRACONTAINER = MetricsFactory.createMetricIdentity((String)"esb.service.messages.ReceivedIntraContainer");
    public static final IMetricIdentity MESSAGES_FAULTED = MetricsFactory.createMetricIdentity((String)"esb.service.messages.Faulted");
    public static final IMetricIdentity MESSAGES_REJECTED = MetricsFactory.createMetricIdentity((String)"esb.service.messages.Rejected");
    public static final IMetricIdentity AVERAGE_PROCESSING_TIME = MetricsFactory.createMetricIdentity((String)"esb.service.messages.AverageProcessingTime");
    public static final IMetricIdentity MESSAGES_RECEIVED_PER_SECOND = MetricsFactory.createMetricIdentity((String)"esb.service.messages.ReceivedPerSecond");
    public static final IMetricIdentity MESSAGES_RECEIVED_PER_MINUTE = MetricsFactory.createMetricIdentity((String)"esb.service.messages.ReceivedPerMinute");
    public static final IMetricIdentity MESSAGES_RECEIVED_PER_HOUR = MetricsFactory.createMetricIdentity((String)"esb.service.messages.ReceivedPerHour");
    public static final IMetricIdentity MESSAGES_SENT_TO_OUTBOX = MetricsFactory.createMetricIdentity((String)"esb.service.messages.SentToOutbox");
    public static final IMetricIdentity MESSAGES_SENT_WITH_DISPATCH = MetricsFactory.createMetricIdentity((String)"esb.service.messages.SentWithDispatch");
    public static final IMetricIdentity LISTENERS_REFRESH_INTERVAL_MAX_ACTIVE = MetricsFactory.createMetricIdentity((String)"esb.service.listeners.RefreshIntervalMaxActive");
    public static final IMetricIdentity LISTENERS_USAGE = MetricsFactory.createMetricIdentity((String)"esb.service.listeners.Usage");
    public static final IMetricIdentity LISTENERS_AVERAGE_USAGE = MetricsFactory.createMetricIdentity((String)"esb.service.listeners.AverageUsage");
    public static final IMetricIdentity CONCURRENCY_REFRESH_INTERVAL_MAX_ACTIVE = MetricsFactory.createMetricIdentity((String)"esb.service.concurrency.RefreshIntervalMaxActive");
    public static final IMetricIdentity CONCURRENCY_USAGE = MetricsFactory.createMetricIdentity((String)"esb.service.concurrency.Usage");
    public static final IMetricIdentity CONCURRENCY_AVERAGE_USAGE = MetricsFactory.createMetricIdentity((String)"esb.service.concurrency.AverageUsage");
    private static Map<IMetricIdentity, IMetricInfo> s_infos = new HashMap<IMetricIdentity, IMetricInfo>();
    private final Map<IMetricIdentity, Statistic> m_statistics = new HashMap<IMetricIdentity, Statistic>();
    private UsageStatisticProvider m_listenerUsage;
    private UsageStatisticProvider m_listenerAverageUsage;
    private UsageStatisticProvider m_concurrencyUsage;
    private UsageStatisticProvider m_concurrencyAverageUsage;

    public static IMetricInfo[] getMetricInfos() {
        IMetricInfo[] infos = s_infos.values().toArray(new IMetricInfo[0]);
        return infos;
    }

    private static IMetricInfo createMetricInfo(IMetricIdentity id, short valueType, String description) {
        return MetricsFactory.createMetricInfo((IMetricIdentity)id, (short)valueType, (String)description, null, (boolean)true, (boolean)true);
    }

    private static IMetricInfo createMetricInfo(IMetricIdentity id, short valueType, String description, boolean supportsHighAlerts, boolean supportsLowAlerts, String units) {
        return MetricsFactory.createMetricInfo((IMetricIdentity)id, (short)valueType, (String)description, null, (boolean)true, (boolean)true, (boolean)supportsHighAlerts, (boolean)supportsLowAlerts, (String)units);
    }

    private static void addInfo(IMetricInfo info) {
        s_infos.put(info.getMetricIdentity(), info);
    }

    public static List<String> getServiceMetricInstanceNames(IMetricInfo info, XQAppManager appManager) {
        String[][] servicesInfo;
        IMetricIdentity id = info.getMetricIdentity();
        ArrayList<String> names = new ArrayList<String>();
        for (String[] serviceInfo : servicesInfo = appManager.getServicesInfo()) {
            String serviceName = serviceInfo[0];
            String serviceType = serviceInfo[1];
            if (XQContainer.isHiddenComponentType(serviceType) || (id.equals(CONCURRENCY_USAGE) || id.equals(CONCURRENCY_AVERAGE_USAGE)) && appManager.getServiceApplication(serviceName).isUnlimitedConcurrentCalls()) continue;
            names.add(serviceName);
        }
        return Collections.unmodifiableList(names);
    }

    public XQServiceMetrics() {
        for (IMetricIdentity id : s_infos.keySet()) {
            this.m_statistics.put(id, new Statistic(id));
        }
    }

    public void setListenerUsage(UsageStatisticProvider provider) {
        provider.setMetricId(LISTENERS_USAGE);
        this.m_listenerUsage = provider;
    }

    public void setListenerAverageUsage(UsageStatisticProvider provider) {
        provider.setMetricId(LISTENERS_AVERAGE_USAGE);
        this.m_listenerAverageUsage = provider;
    }

    public void setConcurrencyUsage(UsageStatisticProvider provider) {
        provider.setMetricId(CONCURRENCY_USAGE);
        this.m_concurrencyUsage = provider;
    }

    public void setConcurrencyAverageUsage(UsageStatisticProvider provider) {
        provider.setMetricId(CONCURRENCY_AVERAGE_USAGE);
        this.m_concurrencyAverageUsage = provider;
    }

    public Statistic getStatistic(IMetricIdentity id) {
        return this.m_statistics.get(id);
    }

    public boolean managesMetric(IMetricIdentity metricId) {
        return s_infos.containsKey(metricId);
    }

    @Override
    public IStatistic enableInstanceMetric(IMetricIdentity metricId) {
        Statistic holder = this.m_statistics.get(metricId);
        IStatistic stat = this.createStatistic(metricId);
        holder.setTarget(stat);
        if (stat instanceof ISampledStatistic) {
            IStatisticProvider[] providers = ((ISampledStatistic)stat).getStatisticProviders();
            for (int i = 0; i < providers.length; ++i) {
                IStatisticProvider provider = providers[i];
                if (!(provider instanceof UsageStatisticProvider)) continue;
                ((UsageStatisticProvider)provider).enable();
            }
        }
        return stat;
    }

    @Override
    public void disableInstanceMetric(IMetricIdentity metricId) {
        Statistic holder = this.m_statistics.get(metricId);
        IStatistic stat = holder.unsetTarget();
        if (stat instanceof ISampledStatistic) {
            IStatisticProvider[] providers = ((ISampledStatistic)stat).getStatisticProviders();
            for (int i = 0; i < providers.length; ++i) {
                IStatisticProvider provider = providers[i];
                if (!(provider instanceof UsageStatisticProvider)) continue;
                ((UsageStatisticProvider)provider).disable();
            }
        }
    }

    private IStatistic createStatistic(IMetricIdentity metricId) {
        IStatistic stat;
        if (MESSAGES_RECEIVED_PER_SECOND.equals(metricId) || MESSAGES_RECEIVED_PER_MINUTE.equals(metricId) || MESSAGES_RECEIVED_PER_HOUR.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
        } else if (AVERAGE_PROCESSING_TIME.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)2);
        } else if (LISTENERS_REFRESH_INTERVAL_MAX_ACTIVE.equals(metricId) || CONCURRENCY_REFRESH_INTERVAL_MAX_ACTIVE.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)5, (boolean)false, null, (short)0);
        } else if (LISTENERS_USAGE.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])new IStatisticProvider[]{this.m_listenerUsage}, (short)0);
            this.m_listenerUsage.enable();
        } else if (LISTENERS_AVERAGE_USAGE.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])new IStatisticProvider[]{this.m_listenerAverageUsage}, (short)1);
            this.m_listenerAverageUsage.enable();
        } else if (CONCURRENCY_USAGE.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])new IStatisticProvider[]{this.m_concurrencyUsage}, (short)0);
            this.m_concurrencyUsage.enable();
        } else if (CONCURRENCY_AVERAGE_USAGE.equals(metricId)) {
            stat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])new IStatisticProvider[]{this.m_concurrencyAverageUsage}, (short)1);
            this.m_concurrencyAverageUsage.enable();
        } else {
            stat = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
        }
        return stat;
    }

    static {
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_RECEIVED, (short)0, "Messages received."));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_RECEIVED_INTRACONTAINER, (short)0, "Messages received intracontainer."));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_REJECTED, (short)0, "Messages received and then rejected."));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_FAULTED, (short)0, "Messages received that produced one or more faults."));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(AVERAGE_PROCESSING_TIME, (short)5, "Average processing time for successful invocations of service().", true, true, "milliseconds"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_RECEIVED_PER_SECOND, (short)8, "Messages received per second.", true, true, "messages per second"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_RECEIVED_PER_MINUTE, (short)10, "Messages received per minute.", true, true, "messages per minute"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_RECEIVED_PER_HOUR, (short)12, "Messages received per hour.", true, true, "messages per hour"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_SENT_TO_OUTBOX, (short)0, "Messages sent to the outbox."));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(MESSAGES_SENT_WITH_DISPATCH, (short)0, "Messages sent using XQDispatch.dispatch."));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(LISTENERS_REFRESH_INTERVAL_MAX_ACTIVE, (short)4, "Highest number of listeners active within the refresh interval.", true, true, "active listeners"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(LISTENERS_USAGE, (short)0, "Percentage listener capacity over the refresh interval.", true, true, "%"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(LISTENERS_AVERAGE_USAGE, (short)5, "Average percentile listener capacity over the collection interval.", true, true, "%"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(CONCURRENCY_REFRESH_INTERVAL_MAX_ACTIVE, (short)4, "Highest number of concurrent service requests active within the refresh interval.", true, true, "concurrent active service requests"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(CONCURRENCY_USAGE, (short)0, "Percentage concurrent service capacity over the refresh interval.", true, true, "%"));
        XQServiceMetrics.addInfo(XQServiceMetrics.createMetricInfo(CONCURRENCY_AVERAGE_USAGE, (short)5, "Average percentile concurrent service capacity over the collection interval.", true, true, "%"));
    }

    public static class UsageStatisticProvider
    implements IStatisticProvider {
        private final SimpleDateFormat m_debugDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        private final String m_resourcesName;
        private final int m_numResources;
        private IMetricIdentity m_metricId;
        private boolean enable = false;
        private final Map<Object, Long> m_resourceStartTime;
        private long m_intervalStartTime = -1L;
        private long m_usageTime = 0L;

        public UsageStatisticProvider(String resourcesName, int numResources) {
            this.m_resourcesName = resourcesName;
            this.m_numResources = numResources;
            this.m_resourceStartTime = new HashMap<Object, Long>();
        }

        void setMetricId(IMetricIdentity m_metricId) {
            this.m_metricId = m_metricId;
        }

        public synchronized void enable() {
            this.enable = true;
        }

        public synchronized void disable() {
            this.enable = false;
            this.clear();
        }

        public synchronized void clear() {
            this.m_intervalStartTime = 0L;
            this.m_usageTime = 0L;
            this.m_resourceStartTime.clear();
        }

        public synchronized void registerResourceStart(Object resourceId) {
            if (!this.enable) {
                return;
            }
            this.m_resourceStartTime.put(resourceId, new Long(System.currentTimeMillis()));
        }

        public synchronized void registerResourceEnd(Object resourceId) {
            if (!this.enable) {
                return;
            }
            long resourceEndTime = System.currentTimeMillis();
            Long l = this.m_resourceStartTime.remove(resourceId);
            long resourceStartTime = l == null ? 0L : l;
            this.m_usageTime += resourceEndTime - Math.max(this.m_intervalStartTime, resourceStartTime);
        }

        public void resetStatistic(ISampledStatistic stat) {
            stat.reset();
            this.clear();
        }

        public synchronized void updateStatistic(ISampledStatistic stat) {
            if (!this.enable) {
                return;
            }
            long intervalDuration = stat.getLastRefreshCycleDuration();
            if (intervalDuration != -1L) {
                StringBuffer logBuf;
                long intervalStartTime = stat.getCurrencyTimestamp();
                long intervalEndTime = intervalStartTime + intervalDuration;
                StringBuffer stringBuffer = logBuf = log.isDebugLoggingEnabled() ? new StringBuffer() : null;
                if (logBuf != null) {
                    logBuf.append(this.getDisplayName()).append(": updating statistic\n");
                    logBuf.append("  interval: start ").append(" ").append(this.m_debugDateFormat.format(new Date(intervalStartTime))).append(" - duration ").append(intervalDuration).append("\n");
                    logBuf.append("  collected usage time ").append(this.m_usageTime).append("\n");
                }
                for (long resourceStartTime : this.m_resourceStartTime.values()) {
                    long resourceRunningTime = intervalEndTime - Math.max(resourceStartTime, intervalStartTime);
                    this.m_usageTime += resourceRunningTime;
                    if (logBuf == null) continue;
                    logBuf.append("  resource running time ").append(resourceRunningTime).append("\n");
                }
                long usagePercentage = Math.round(this.m_usageTime * 100L / ((long)this.m_numResources * intervalDuration));
                stat.updateValue(usagePercentage);
                if (logBuf != null) {
                    logBuf.append("  total usage time ").append(this.m_usageTime).append(" (").append(usagePercentage).append("%)");
                    log.logDebug(logBuf.toString());
                }
            }
            this.m_intervalStartTime = System.currentTimeMillis();
            this.m_usageTime = 0L;
        }

        public String getDisplayName() {
            if (this.m_resourcesName != null && this.m_metricId != null) {
                return "Statistic provider of " + this.m_resourcesName + " for metric " + this.m_metricId;
            }
            return super.toString();
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public class Statistic {
        private IStatistic m_target;
        private IMetricIdentity m_id;

        public Statistic(IMetricIdentity id) {
            this.m_id = id;
        }

        void setTarget(IStatistic statistic) {
            this.m_target = statistic;
        }

        IStatistic unsetTarget() {
            IStatistic stat = this.m_target;
            this.m_target = null;
            return stat;
        }

        public boolean updateValue(long value) {
            IStatistic stat = this.m_target;
            if (stat != null) {
                stat.updateValue(value);
                return true;
            }
            return false;
        }

        public boolean increment() {
            return this.updateValue(1L);
        }

        public boolean decrement() {
            return this.updateValue(-1L);
        }
    }
}

