/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.wsinvk;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQTransientNamingService;
import com.sonicsw.xqimpl.script.ScriptEngine;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.service.wsinvk.WSInvocationScriptObject;
import java.util.Hashtable;
import javax.naming.InitialContext;
import org.w3c.dom.Element;

public class WSInvocationScriptEngine
extends ScriptEngine {
    private DirectoryServiceProxy m_dsProxy = null;
    private Hashtable m_envProps = null;
    private boolean m_inContainer = false;
    private XQConnectionConfig m_xqConnConfig = null;
    private static volatile XQTransientNamingService m_tns = null;

    public WSInvocationScriptEngine(IComponentContext iComponentCtx) {
        super(iComponentCtx);
        this.m_inContainer = true;
    }

    public WSInvocationScriptEngine(Hashtable envProps, DirectoryServiceProxy proxy, XQConnectionConfig xqConnConfig) {
        super(proxy);
        this.m_inContainer = false;
        this.m_dsProxy = proxy;
        this.m_envProps = envProps;
        this.m_xqConnConfig = xqConnConfig;
        if (m_tns == null) {
            try {
                InitialContext ctx = new InitialContext(this.m_envProps);
                m_tns = new XQTransientNamingService(ctx);
                m_tns.init();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ScriptObject getScript(String scriptURL) throws ScriptEngineException {
        ScriptObject scriptObject = this.getScriptFromCache(scriptURL);
        if (scriptObject != null && scriptObject instanceof WSInvocationScriptObject) {
            WSInvocationScriptObject wsiScriptObject = (WSInvocationScriptObject)scriptObject;
            wsiScriptObject.reinitialize(this.m_inContainer, this.m_dsProxy, this.m_envProps, this.m_xqConnConfig);
            return wsiScriptObject;
        }
        return this.createScript(scriptURL);
    }

    @Override
    public ScriptObject createScriptObject(Element script) throws ScriptEngineException {
        return new WSInvocationScriptObject(script, this.m_inContainer, this.m_dsProxy, this.m_envProps, this.m_xqConnConfig);
    }

    @Override
    public ScriptObject createScriptObject() throws ScriptEngineException {
        return new WSInvocationScriptObject(this.m_inContainer, this.m_dsProxy, this.m_envProps, this.m_xqConnConfig);
    }
}

