/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import modelobjects.expr.Expression;
import modelobjects.expr.LiteralExpression;
import modelobjects.expr.PostEvalConverter;
import modelobjects.util.LexerTokenTypes;

class UnaryExpression
extends Expression
implements LexerTokenTypes {
    protected int operator;
    protected Expression operand;

    UnaryExpression(int operator, Expression operand) {
        this.operator = operator;
        this.operand = operand;
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        Object val = this.operand.eval(rootObject, cvtr, rule);
        if (val == null) {
            throw new NullPointerException("Null operand for " + UnaryExpression.opName(this.operator));
        }
        switch (this.operator) {
            case -30: {
                if (!(val instanceof Number)) break;
                return val;
            }
            case -31: {
                if (!(val instanceof Number)) break;
                return LiteralExpression.canonicalize(-((Number)val).doubleValue());
            }
            case -64: {
                if (!(val instanceof Boolean)) break;
                return val.equals(Boolean.FALSE) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new RuntimeException("Illegal operand for " + UnaryExpression.opName(this.operator) + ": " + val);
    }

    public String toString() {
        return "(" + UnaryExpression.opName(this.operator) + " " + this.operand.toString() + ")";
    }
}

