/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.el.BaseELResolver;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;

public class SystemPropertyELResolver
extends BaseELResolver {
    public SystemPropertyELResolver() {
    }

    public SystemPropertyELResolver(boolean readOnly) {
        super(readOnly);
    }

    public Object getValue(ELContext context, Object base, Object property) {
        String result = null;
        if (this.isResolvable(context, base, property) && (result = SystemPropertyELResolver.resolveSystemProperty((String)property)) != null) {
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isResolvable(context, base, property)) {
            throw new PropertyNotWritableException("System properties cannot be set");
        }
    }

    @Override
    protected final boolean isResolvable(Object base) {
        return base.equals(System.getProperties());
    }

    @Override
    protected final boolean isResolvable(ELContext context, Object base, Object property) {
        return this.isResolvable(base) && property instanceof String;
    }

    private static String resolveSystemProperty(String key) {
        String value = null;
        try {
            value = System.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }
}

