/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.common;

import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.rules.IRuleEvaluator;
import com.sonicsw.xq.service.common.CacheableJavaScriptRule;
import com.sonicsw.xq.service.common.IJavaScriptRule;
import com.sonicsw.xq.service.common.NonCacheableJavaScriptRule;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class RulesProcessor {
    protected List<XQEnvelope> m_processedMsgs = new ArrayList<XQEnvelope>();
    protected XQServiceContext m_serviceContext = null;
    protected XQMessage m_message = null;
    protected XQEnvelope m_envelope = null;
    protected Hashtable<String, IRuleEvaluator> m_ruleFileCache = null;
    private Hashtable<String, Class<?>> m_ruleEvaluatorsClassCache = null;
    private String m_ruleEvaluatorClassname = null;
    private XQParameters m_params = null;
    private boolean m_enableCache = true;
    private IJavaScriptRule m_rule = null;
    private Object m_evaluatorSyncObject = new Object();

    public RulesProcessor() {
        this.m_ruleEvaluatorsClassCache = new Hashtable();
        this.m_ruleFileCache = new Hashtable();
    }

    public void init(XQParameters params, boolean enableCache) throws XQServiceException {
        IRuleEvaluator evaluator = null;
        try {
            this.m_rule = enableCache ? new CacheableJavaScriptRule() : new NonCacheableJavaScriptRule();
            if (params != null) {
                this.m_params = params;
                this.m_params.setBooleanParameter("ENABLED_CACHE", 1, enableCache);
                this.m_ruleEvaluatorClassname = params.getParameter("ruleEvaluatorClass", 1);
            }
            if (this.m_ruleEvaluatorClassname != null) {
                if (this.m_ruleEvaluatorClassname.equals("com.sonicsw.xqimpl.service.accessor.ScriptEvaluator")) {
                    this.m_ruleEvaluatorClassname = "com.sonicsw.xq.service.common.ScriptEvaluator";
                }
                evaluator = this.lookup(this.m_ruleEvaluatorClassname);
                if (!this.m_ruleEvaluatorClassname.equals("com.sonicsw.xq.service.common.ScriptEvaluator")) {
                    evaluator.init(params);
                }
            }
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    public void processRules(XQParameters runtimeParams) throws XQServiceException {
        Object result = this.evaluate(runtimeParams);
        if (result != null) {
            this.processMessage(runtimeParams, result);
        } else {
            this.m_processedMsgs.add(this.m_envelope);
        }
        int msgCount = this.m_processedMsgs.size();
        if (this.m_serviceContext != null) {
            while (msgCount-- > 0) {
                this.m_serviceContext.addOutgoing(this.m_processedMsgs.get(msgCount));
            }
        }
        this.m_processedMsgs.clear();
    }

    public void setServiceContext(XQServiceContext context) {
        this.m_serviceContext = context;
    }

    public void setEnvelope(XQEnvelope envelope) {
        this.m_envelope = envelope;
    }

    public void setMessage(XQMessage message) {
        this.m_message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRuleEvaluator lookup(String ruleEvaluatorClassname) throws XQServiceException {
        Class<?> ruleEvaluatorClass = null;
        IRuleEvaluator evaluator = null;
        if (ruleEvaluatorClassname == null) {
            return null;
        }
        Hashtable<String, Class<?>> hashtable = this.m_ruleEvaluatorsClassCache;
        synchronized (hashtable) {
            if (this.m_ruleEvaluatorsClassCache.containsKey(ruleEvaluatorClassname)) {
                ruleEvaluatorClass = this.m_ruleEvaluatorsClassCache.get(ruleEvaluatorClassname);
            } else {
                try {
                    ruleEvaluatorClass = Class.forName(ruleEvaluatorClassname, true, this.getClass().getClassLoader());
                    this.m_ruleEvaluatorsClassCache.put(ruleEvaluatorClassname, ruleEvaluatorClass);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new XQServiceException("Rule Evaluator class not found:" + ruleEvaluatorClassname);
                }
            }
        }
        if (!IRuleEvaluator.class.isAssignableFrom(ruleEvaluatorClass)) {
            throw new XQServiceException("Rule Evaluators must implement IRuleEvaluator");
        }
        try {
            evaluator = (IRuleEvaluator)ruleEvaluatorClass.newInstance();
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
        return evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluate(XQParameters runtimeParams) throws XQServiceException {
        Object retVal;
        block18: {
            retVal = null;
            IRuleEvaluator evaluator = null;
            String runtimeRuleFile = null;
            if (runtimeParams != null) {
                runtimeRuleFile = new CacheableJavaScriptRule().getRule(runtimeParams);
            }
            try {
                if (this.m_ruleEvaluatorClassname == null || this.m_params == null) break block18;
                Object object = this.m_evaluatorSyncObject;
                synchronized (object) {
                    evaluator = this.lookup(this.m_ruleEvaluatorClassname);
                    if (this.m_ruleEvaluatorClassname.equals("com.sonicsw.xq.service.common.ScriptEvaluator")) {
                        String initRuleFile = this.getInitRuleFile(this.m_params);
                        if (runtimeRuleFile != null) {
                            if (!this.m_ruleFileCache.containsKey(runtimeRuleFile)) {
                                evaluator.init(this.m_params);
                                this.cacheEvaluator(runtimeRuleFile, evaluator);
                            } else {
                                evaluator = this.m_ruleFileCache.get(runtimeRuleFile);
                            }
                        } else if (runtimeRuleFile == null && initRuleFile != null) {
                            if (!this.m_ruleFileCache.containsKey(initRuleFile)) {
                                evaluator.init(this.m_params);
                                this.cacheEvaluator(initRuleFile, evaluator);
                            } else {
                                evaluator = this.m_ruleFileCache.get(initRuleFile);
                            }
                        } else if (runtimeRuleFile == null && initRuleFile == null) {
                            String serviceName = this.m_serviceContext.getParameters().getParameter("SonicXQ.ServiceName", 1);
                            throw new XQServiceException(serviceName + " initialization failed. No javascript rules specified!");
                        }
                    } else {
                        evaluator.init(this.m_params);
                    }
                    retVal = evaluator.evaluateRule(runtimeParams, this.m_serviceContext, this.m_message);
                }
            }
            catch (Throwable e) {
                if (e instanceof XQServiceException) {
                    throw (XQServiceException)e;
                }
                throw new XQServiceException(e);
            }
        }
        return retVal;
    }

    public String getInitRuleFile(XQParameters params) {
        return this.m_rule.getRule(params);
    }

    private void cacheEvaluator(String ruleFile, IRuleEvaluator evaluator) {
        if (this.m_enableCache) {
            this.m_ruleFileCache.put(ruleFile, evaluator);
        }
    }

    protected abstract void processMessage(XQParameters var1, Object var2) throws XQServiceException;

    public void clear() {
        this.m_envelope = null;
        this.m_message = null;
        this.m_processedMsgs.clear();
        this.m_serviceContext = null;
    }
}

