/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.actional.lg.visitor;

import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalBasePart;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public final class ActionalXQPart
extends ActionalBasePart {
    private XQPart m_part;

    public ActionalXQPart(XQPart part) {
        this.m_part = part;
        this.m_contentType = this.m_part.getContentType();
        this.m_contentID = this.m_part.getContentId();
    }

    protected XQPart getPart() {
        return this.m_part;
    }

    @Override
    public void release() {
        super.release();
        this.m_part = null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ActionalXQPart)) {
            return false;
        }
        ActionalXQPart other = (ActionalXQPart)((Object)o);
        return other.getPart() == this.getPart();
    }

    @Override
    protected byte[] retrieveBytes() throws RuntimeException {
        Object contentObj = this.m_part.getContent();
        if (contentObj instanceof byte[]) {
            return (byte[])contentObj;
        }
        if (contentObj instanceof TextMessage) {
            String contentString;
            try {
                contentString = ((TextMessage)contentObj).getText();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
            try {
                return contentString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        String contentString = (String)contentObj;
        try {
            return contentString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

